/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public class MultiLabelReference
extends ExprNode {
    private String fullName;
    private String name;
    private int relativeIndex;

    public MultiLabelReference(String string, DebugInfo debugInfo) {
        super(debugInfo);
        this.fullName = string;
        if (string.endsWith("-")) {
            this.relativeIndex = 0;
        } else if (string.endsWith("+")) {
            this.relativeIndex = 1;
        } else {
            throw new AsmError("Missing direction on multilabel reference '" + string + "'", debugInfo);
        }
        this.name = string.substring(0, string.length() - 1);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) throws AsmException {
        SymbolScopeValue symbolScopeValue = evaluationState.getCurrentScope().getSymbols().getMultiLabelValue(this.name, this.relativeIndex);
        if (symbolScopeValue == null) {
            throw new AsmError("Unknown symbol '" + this.fullName + "'", this.debug);
        }
        return symbolScopeValue;
    }

    public String toString() {
        return "MultiLabelReference(" + this.fullName + ")";
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("MulLabelRef", this.name, Integer.toString(this.relativeIndex), new ExprNode[0]);
        return exprTreeBuilder;
    }
}

