/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.LockableValue;
import cml.kickass.values.Value;

public class InvalidValue
extends LockableValue {
    public static final InvalidValue instance = new InvalidValue();
    private static FunctionTable functions = new InvalidValueFunctionTable();

    private InvalidValue() {
        this.setInvalid();
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_STRINGVALUE) {
            return "<<Invalid Value>>";
        }
        return null;
    }

    @Override
    public String getType() {
        return "Invalid value";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(DebugInfo debugInfo) {
    }

    @Override
    protected Value localGetVariable(String string, DebugInfo debugInfo) throws AsmException {
        throw new AsmError("You are trying to access a variable on an invalid value", debugInfo);
    }

    static class InvalidValueFunctionTable
    extends FunctionTable {
        InvalidValueFunctionTable() {
        }

        @Override
        public Function get(String string, Value[] valueArray, DebugInfo debugInfo) {
            return new Function(string, null, null, true){

                @Override
                public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                    throw new AsmError("You are trying to call a function on an invalid object", debugInfo);
                }
            };
        }

        @Override
        public boolean exist(String string, Value[] valueArray) {
            throw NotImplementedException.intance;
        }
    }
}

