/*
 * Decompiled with CFR 0.152.
 */
package cml.log;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class Log {
    private static boolean debuggingOn = false;
    private static boolean warningsOn = true;
    private static List<PrintStream> printStreams = new ArrayList<PrintStream>();
    private String classname;

    public static void setDebugging(boolean bl) {
        debuggingOn = bl;
    }

    public static void setWarnings(boolean bl) {
        warningsOn = bl;
    }

    public void addPrintStream(PrintStream printStream) {
        printStreams.add(printStream);
    }

    private void printlnToAllStreams(String string) {
        for (int i = 0; i < printStreams.size(); ++i) {
            printStreams.get(i).println(string);
        }
    }

    public Log(String string) {
        this.classname = string;
    }

    public void println() {
        this.printlnToAllStreams("");
    }

    public void println(String string) {
        this.printlnToAllStreams(string);
    }

    public void mark(String string) {
        if (debuggingOn) {
            this.printlnToAllStreams(string);
        }
    }

    public void warn(String string) {
        if (warningsOn) {
            this.printlnToAllStreams(string);
        }
    }

    public void error(Exception exception) {
        this.printlnToAllStreams(exception.getMessage());
        if (debuggingOn) {
            exception.printStackTrace(System.out);
        }
    }

    public void error(String string) {
        this.printlnToAllStreams(string);
    }
}

