/*
 * Decompiled with CFR 0.152.
 */
package algebra;

import algebra.Algebra;
import algebra.Vector3f;
import java.io.Serializable;

public class Base
implements Serializable {
    public final Vector3f u;
    public final Vector3f v;
    public final Vector3f w;
    public static final Base STANDARD = new Base(Vector3f.I, Vector3f.J, Vector3f.K);

    public Base(Vector3f a, Vector3f b) {
        this.w = Algebra.unit(a);
        Vector3f bxw = Algebra.cross(b, this.w);
        this.u = Algebra.unit(bxw);
        this.v = Algebra.cross(this.w, this.u);
    }

    public Base(Vector3f u, Vector3f v, Vector3f w) {
        this.u = u;
        this.v = v;
        this.w = w;
    }

    public boolean equals(Object other) {
        if (other instanceof Base) {
            Base that = (Base)other;
            if (!this.u.equals(that.u)) {
                return false;
            }
            if (!this.v.equals(that.v)) {
                return false;
            }
            return this.w.equals(that.w);
        }
        return false;
    }

    public String toString() {
        return "[" + this.u.toString() + "; " + this.v.toString() + "; " + this.w.toString() + "]";
    }
}

