/*
 * Decompiled with CFR 0.152.
 */
package geometry;

import algebra.Algebra;
import algebra.TexCoord2f;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.ray.Ray;
import geometry.ray.RayResult;

public class Triangle
extends Geometry {
    private static final float epsilon = 5.0E-5f;
    private final Vector3f va;
    private final Vector3f vb;
    private final Vector3f vc;
    private final Vector3f na;
    private final Vector3f nb;
    private final Vector3f nc;
    private final TexCoord2f ta;
    private final TexCoord2f tb;
    private final TexCoord2f tc;
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    private final float e;
    private final float f;
    private final float area;

    public Triangle(Vector3f va, Vector3f vb, Vector3f vc, Vector3f na, Vector3f nb, Vector3f nc, TexCoord2f ta, TexCoord2f tb, TexCoord2f tc) {
        this.va = va;
        this.vb = vb;
        this.vc = vc;
        this.na = Algebra.unit(na);
        this.nb = Algebra.unit(nb);
        this.nc = Algebra.unit(nc);
        this.ta = ta;
        this.tb = tb;
        this.tc = tc;
        this.a = va.x - vb.x;
        this.b = va.y - vb.y;
        this.c = va.z - vb.z;
        this.d = va.x - vc.x;
        this.e = va.y - vc.y;
        this.f = va.z - vc.z;
        float la = Algebra.length(Algebra.substract(va, vb));
        float lb = Algebra.length(Algebra.substract(vb, vc));
        float lc = Algebra.length(Algebra.substract(vc, va));
        float s = (la + lb + lc) * 0.5f;
        this.area = (float)Math.sqrt(s * (s - la) * (s - lb) * (s - lc));
    }

    public Triangle(Vector3f va, Vector3f vb, Vector3f vc, Vector3f na, Vector3f nb, Vector3f nc) {
        this(va, vb, vc, na, nb, nc, null, null, null);
    }

    public Triangle(Vector3f va, Vector3f vb, Vector3f vc) {
        this(va, vb, vc, Algebra.cross(Algebra.substract(vb, va), Algebra.substract(vc, va)), Algebra.cross(Algebra.substract(vb, va), Algebra.substract(vc, va)), Algebra.cross(Algebra.substract(vb, va), Algebra.substract(vc, va)));
    }

    @Override
    public RayResult intersect(Ray ray) {
        float k = this.va.y - ray.e.y;
        float j = this.va.x - ray.e.x;
        float ak_jb = this.a * k - j * this.b;
        float l = this.va.z - ray.e.z;
        float jc_al = j * this.c - this.a * l;
        float bl_kc = this.b * l - k * this.c;
        float i = ray.d.z;
        float h = ray.d.y;
        float ei_hf = this.e * i - h * this.f;
        float g = ray.d.x;
        float gf_di = g * this.f - this.d * i;
        float dh_eg = this.d * h - this.e * g;
        float invM = 1.0f / (this.a * ei_hf + this.b * gf_di + this.c * dh_eg);
        float t = -(this.f * ak_jb + this.e * jc_al + this.d * bl_kc) * invM;
        if (t < -5.0E-5f) {
            return null;
        }
        float gamma = (i * ak_jb + h * jc_al + g * bl_kc) * invM;
        if (gamma < -5.0E-5f || gamma > 1.00005f) {
            return null;
        }
        float beta = (j * ei_hf + k * gf_di + l * dh_eg) * invM;
        if (beta < -5.0E-5f || beta > 1.0f - gamma + 5.0E-5f) {
            return null;
        }
        return new RayTriangleResult(ray, t, this, beta, gamma);
    }

    @Override
    public Vector3f getMin() {
        return Algebra.min(this.va, Algebra.min(this.vb, this.vc));
    }

    @Override
    public Vector3f getMax() {
        return Algebra.max(this.va, Algebra.max(this.vb, this.vc));
    }

    @Override
    public float getArea() {
        return this.area;
    }

    public class RayTriangleResult
    extends RayResult {
        private final float beta;
        private final float gamma;

        public RayTriangleResult(Ray ray, float t, Geometry hit, float beta, float gamma) {
            super(ray, t, hit);
            this.beta = beta;
            this.gamma = gamma;
        }

        @Override
        protected Vector3f calcNormal() {
            if (Triangle.this.na == Triangle.this.nb && Triangle.this.nb == Triangle.this.nc) {
                return Triangle.this.na;
            }
            float alpha = 1.0f - this.beta - this.gamma;
            return Algebra.unit(Algebra.sum(Algebra.sum(Algebra.scalar(Triangle.this.na, alpha), Algebra.scalar(Triangle.this.nb, this.beta)), Algebra.scalar(Triangle.this.nc, this.gamma)));
        }

        @Override
        protected TexCoord2f calcTexCoord() {
            if (Triangle.this.ta == null || Triangle.this.tb == null || Triangle.this.tc == null) {
                throw new NullPointerException();
            }
            float alpha = 1.0f - this.beta - this.gamma;
            return Triangle.this.ta.mult(alpha).sum(Triangle.this.tb.mult(this.beta).sum(Triangle.this.tc.mult(this.gamma)));
        }
    }
}

