/*
 * Decompiled with CFR 0.152.
 */
package geometry.ray;

import algebra.Algebra;
import algebra.Matrix4f;
import algebra.Vector3f;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import geometry.ray.ShadingRay;
import scene.Scene;

public class ShadowRay
extends Ray {
    public ShadowRay(Vector3f e, Vector3f d) {
        super(e, d);
        assert (Algebra.isUnit(this.d)) : "ShadowRays need unit directions for distance measurement.";
    }

    public boolean isVisible(Scene scene) {
        RayResult rayResult = scene.intersect(this);
        if (rayResult == null) {
            return true;
        }
        return rayResult.t <= 0.0f;
    }

    public boolean isVisible(Scene scene, float maxt) {
        RayResult rayResult = scene.intersect(this);
        if (rayResult == null) {
            return true;
        }
        return rayResult.t <= 0.0f || rayResult.t > maxt;
    }

    @Override
    public Ray cloneTransformed(Matrix4f m) {
        Vector3f e = Algebra.multPoint(m, this.e);
        Vector3f d = Algebra.multArrow(m, this.d);
        return new ShadingRay(e, d);
    }
}

