/*
 * Decompiled with CFR 0.152.
 */
package io.boxIO;

import geometry.bounding.KDBox;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import scene.model.KDModel;

public class KDBoxIO {
    public static void write(KDModel model, String fileName) {
        KDBoxIO.write(model.getBox(), fileName);
    }

    public static void write(KDBox box, String fileName) {
        try {
            System.out.println("Writing box.");
            FileOutputStream fileOut = new FileOutputStream(fileName);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(box);
            out.close();
            fileOut.close();
            System.out.println("Box written.");
        }
        catch (IOException i) {
            i.printStackTrace();
            System.exit(0);
        }
    }

    public static KDBox read(String fileName) {
        System.out.println("Reading box: " + fileName);
        KDBox box = null;
        try {
            FileInputStream fileIn = new FileInputStream(fileName);
            ObjectInputStream in = new ObjectInputStream(fileIn);
            box = (KDBox)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException i) {
            i.printStackTrace();
            throw new RuntimeException("Reading error.");
        }
        catch (ClassNotFoundException c) {
            c.printStackTrace();
            throw new RuntimeException("Reading error.");
        }
        System.out.println("Box read.");
        return box;
    }
}

