/*
 * Decompiled with CFR 0.152.
 */
package io.meshParser;

import algebra.Algebra;
import algebra.TexCoord2f;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.Triangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.StringTokenizer;

public class MeshParser {
    private final ArrayList<Vector3f> vecs;
    private final ArrayList<Vector3f> nors;
    private final ArrayList<TexCoord2f> texs;
    private final ArrayList<Geometry> tris;
    private final ArrayList<TriangleStub> stubs;
    private final VecStubMap vecMap;
    public static final String vecm = "^f .* .* .*$";
    public static final String texm = "^f .*/.* .*/.* .*/.*$";
    public static final String norNoTexm = "^f .*//.* .*//.* .*//.*$";
    public static final String norTexm = "^f .*/.*/.* .*/.*/.* .*/.*/.*$";

    public MeshParser(String filename) {
        this(filename, false);
    }

    public MeshParser(String filename, boolean interpolate) {
        File file = new File(filename);
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        this.vecs = new ArrayList();
        this.nors = new ArrayList();
        this.texs = new ArrayList();
        this.tris = new ArrayList();
        this.stubs = new ArrayList();
        this.vecMap = new VecStubMap();
        System.out.println("Parser start. " + file.getName());
        String string = scanner.nextLine();
        while (scanner.hasNext()) {
            block29: {
                StringTokenizer tokenizer = new StringTokenizer(string, " ");
                if (!tokenizer.hasMoreElements()) break block29;
                switch (tokenizer.nextToken()) {
                    case "#": {
                        System.out.println(string);
                        break;
                    }
                    case "v": {
                        this.vecs.add(this.parseVec(tokenizer));
                        break;
                    }
                    case "vn": {
                        this.nors.add(this.parseVec(tokenizer));
                        break;
                    }
                    case "vt": {
                        this.texs.add(this.parseTex(tokenizer));
                        break;
                    }
                    case "f": {
                        if (string.matches(norTexm)) {
                            if (string.matches(norNoTexm)) {
                                this.tris.add(this.parseTriNorm(tokenizer));
                                break;
                            }
                            this.tris.add(this.parseTriNormTex(tokenizer));
                            break;
                        }
                        if (interpolate) {
                            if (string.matches(texm)) {
                                this.stubs.add(this.parseTriStubTex(tokenizer));
                                break;
                            }
                            this.stubs.add(this.parseTriStub(tokenizer));
                            break;
                        }
                        if (string.matches(texm)) {
                            this.tris.add(this.parseTriFlatTex(tokenizer));
                            break;
                        }
                        this.tris.add(this.parseTriFlat(tokenizer));
                        break;
                    }
                }
            }
            string = scanner.nextLine();
        }
        if (interpolate && this.stubs.size() != 0) {
            System.out.println("Building " + this.stubs.size() + " stubs.");
            for (TriangleStub t : this.stubs) {
                this.tris.add(t.getTriangle(this.vecMap));
            }
        }
        System.out.println("Parser stop.");
        scanner.close();
    }

    private TexCoord2f parseTex(StringTokenizer tokenizer) {
        return new TexCoord2f(Float.parseFloat(tokenizer.nextToken()), Float.parseFloat(tokenizer.nextToken()));
    }

    private Vector3f parseVec(StringTokenizer tokenizer) {
        return new Vector3f(Float.parseFloat(tokenizer.nextToken()), Float.parseFloat(tokenizer.nextToken()), Float.parseFloat(tokenizer.nextToken()));
    }

    private Triangle parseTriNorm(StringTokenizer tokenizer) {
        String[] as = tokenizer.nextToken().split("/");
        String[] bs = tokenizer.nextToken().split("/");
        String[] cs = tokenizer.nextToken().split("/");
        Vector3f va = this.vecs.get(Integer.parseInt(as[0]) - 1);
        Vector3f na = this.nors.get(Integer.parseInt(as[2]) - 1);
        Vector3f vb = this.vecs.get(Integer.parseInt(bs[0]) - 1);
        Vector3f nb = this.nors.get(Integer.parseInt(bs[2]) - 1);
        Vector3f vc = this.vecs.get(Integer.parseInt(cs[0]) - 1);
        Vector3f nc = this.nors.get(Integer.parseInt(cs[2]) - 1);
        return new Triangle(va, vb, vc, na, nb, nc);
    }

    private Triangle parseTriNormTex(StringTokenizer tokenizer) {
        String[] as = tokenizer.nextToken().split("/");
        String[] bs = tokenizer.nextToken().split("/");
        String[] cs = tokenizer.nextToken().split("/");
        Vector3f va = this.vecs.get(Integer.parseInt(as[0]) - 1);
        TexCoord2f ta = this.texs.get(Integer.parseInt(as[1]) - 1);
        Vector3f na = this.nors.get(Integer.parseInt(as[2]) - 1);
        Vector3f vb = this.vecs.get(Integer.parseInt(bs[0]) - 1);
        TexCoord2f tb = this.texs.get(Integer.parseInt(bs[1]) - 1);
        Vector3f nb = this.nors.get(Integer.parseInt(bs[2]) - 1);
        Vector3f vc = this.vecs.get(Integer.parseInt(cs[0]) - 1);
        TexCoord2f tc = this.texs.get(Integer.parseInt(cs[1]) - 1);
        Vector3f nc = this.nors.get(Integer.parseInt(cs[2]) - 1);
        return new Triangle(va, vb, vc, na, nb, nc, ta, tb, tc);
    }

    private Triangle parseTriFlat(StringTokenizer tokenizer) {
        String[] as = tokenizer.nextToken().split("/");
        String[] bs = tokenizer.nextToken().split("/");
        String[] cs = tokenizer.nextToken().split("/");
        Vector3f va = this.vecs.get(Integer.parseInt(as[0]) - 1);
        Vector3f vb = this.vecs.get(Integer.parseInt(bs[0]) - 1);
        Vector3f vc = this.vecs.get(Integer.parseInt(cs[0]) - 1);
        Vector3f n = Algebra.unit(Algebra.cross(Algebra.substract(vb, va), Algebra.substract(vc, va)));
        this.nors.add(n);
        return new Triangle(va, vb, vc, n, n, n);
    }

    private Triangle parseTriFlatTex(StringTokenizer tokenizer) {
        String[] as = tokenizer.nextToken().split("/");
        String[] bs = tokenizer.nextToken().split("/");
        String[] cs = tokenizer.nextToken().split("/");
        Vector3f va = this.vecs.get(Integer.parseInt(as[0]) - 1);
        Vector3f vb = this.vecs.get(Integer.parseInt(bs[0]) - 1);
        Vector3f vc = this.vecs.get(Integer.parseInt(cs[0]) - 1);
        Vector3f n = Algebra.unit(Algebra.cross(Algebra.substract(vb, va), Algebra.substract(vc, va)));
        this.nors.add(n);
        TexCoord2f ta = this.texs.get(Integer.parseInt(as[1]) - 1);
        TexCoord2f tb = this.texs.get(Integer.parseInt(bs[1]) - 1);
        TexCoord2f tc = this.texs.get(Integer.parseInt(cs[1]) - 1);
        return new Triangle(va, vb, vc, n, n, n, ta, tb, tc);
    }

    private TriangleStub parseTriStub(StringTokenizer tokenizer) {
        String[] as = tokenizer.nextToken().split("/");
        String[] bs = tokenizer.nextToken().split("/");
        String[] cs = tokenizer.nextToken().split("/");
        Vector3f va = this.vecs.get(Integer.parseInt(as[0]) - 1);
        Vector3f vb = this.vecs.get(Integer.parseInt(bs[0]) - 1);
        Vector3f vc = this.vecs.get(Integer.parseInt(cs[0]) - 1);
        return new TriangleStub(va, vb, vc);
    }

    private TriangleStub parseTriStubTex(StringTokenizer tokenizer) {
        String[] as = tokenizer.nextToken().split("/");
        String[] bs = tokenizer.nextToken().split("/");
        String[] cs = tokenizer.nextToken().split("/");
        Vector3f va = this.vecs.get(Integer.parseInt(as[0]) - 1);
        Vector3f vb = this.vecs.get(Integer.parseInt(bs[0]) - 1);
        Vector3f vc = this.vecs.get(Integer.parseInt(cs[0]) - 1);
        TexCoord2f ta = this.texs.get(Integer.parseInt(as[1]) - 1);
        TexCoord2f tb = this.texs.get(Integer.parseInt(bs[1]) - 1);
        TexCoord2f tc = this.texs.get(Integer.parseInt(cs[1]) - 1);
        return new TriangleStub(va, vb, vc, ta, tb, tc);
    }

    public Collection<Geometry> getTriangles() {
        return this.tris;
    }

    private class TriangleStub {
        private final Vector3f va;
        private final Vector3f vb;
        private final Vector3f vc;
        private final TexCoord2f ta;
        private final TexCoord2f tb;
        private final TexCoord2f tc;
        private final Vector3f normal;

        public TriangleStub(Vector3f va, Vector3f vb, Vector3f vc) {
            this(va, vb, vc, null, null, null);
        }

        public TriangleStub(Vector3f va, Vector3f vb, Vector3f vc, TexCoord2f ta, TexCoord2f tb, TexCoord2f tc) {
            this.va = va;
            this.vb = vb;
            this.vc = vc;
            this.normal = Algebra.unit(Algebra.cross(Algebra.substract(vb, va), Algebra.substract(vc, va)));
            this.ta = ta;
            this.tb = tb;
            this.tc = tc;
            MeshParser.this.vecMap.add(va, this);
            MeshParser.this.vecMap.add(vb, this);
            MeshParser.this.vecMap.add(vc, this);
        }

        public Triangle getTriangle(VecStubMap map) {
            Vector3f na = this.interpolate(map, this.va);
            Vector3f nb = this.interpolate(map, this.vb);
            Vector3f nc = this.interpolate(map, this.vc);
            if (this.ta == null) {
                return new Triangle(this.va, this.vb, this.vc, na, nb, nc, this.ta, this.tb, this.tc);
            }
            return new Triangle(this.va, this.vb, this.vc, na, nb, nc, this.ta, this.tb, this.tc);
        }

        private Vector3f interpolate(VecStubMap map, Vector3f v) {
            Vector3f result = Vector3f.O;
            for (TriangleStub t : map.get(v)) {
                if (t.va == v) {
                    result = Algebra.sum(result, t.normal);
                    continue;
                }
                if (t.vb == v) {
                    result = Algebra.sum(result, t.normal);
                    continue;
                }
                if (t.vc != v) continue;
                result = Algebra.sum(result, t.normal);
            }
            Vector3f n = Algebra.unit(result);
            return n;
        }
    }

    private class VecStubMap {
        private final Hashtable<Vector3f, LinkedList<TriangleStub>> stubLists = new Hashtable();

        public void add(Vector3f v, TriangleStub stub) {
            LinkedList<TriangleStub> list = this.stubLists.get(v);
            if (list == null) {
                list = new LinkedList();
                this.stubLists.put(v, list);
            }
            list.add(stub);
        }

        public LinkedList<TriangleStub> get(Vector3f v) {
            return this.stubLists.get(v);
        }
    }
}

