/*
 * Decompiled with CFR 0.152.
 */
package scene.material;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import scene.Scene;
import scene.light.AmbientLight;
import scene.light.DirectionalLight;
import scene.light.Light;
import scene.light.PointLight;
import scene.material.LambertianMaterial;
import scene.material.texture.Texture;

public class PhongMaterial
extends LambertianMaterial {
    protected final Texture phongTexture;
    protected final float expPhong;

    public PhongMaterial(Texture texture, Texture phongTexture, float expPhong) {
        super(texture);
        this.phongTexture = phongTexture;
        this.expPhong = expPhong;
    }

    @Override
    public Color3f shade(Scene scene, RayResult rayResult) {
        Color3f resultColor = Color3f.BLACK;
        Color3f color = this.getColor(rayResult);
        Color3f phongColor = this.getPhongColor(rayResult);
        for (Light l : scene.getLights()) {
            if (!l.visibility(rayResult, scene)) continue;
            Color3f lColor = null;
            if (l instanceof AmbientLight) {
                lColor = this.light((AmbientLight)l, rayResult, color);
            } else if (l instanceof DirectionalLight) {
                lColor = this.light((DirectionalLight)l, rayResult, color, phongColor);
            } else if (l instanceof PointLight) {
                lColor = this.light((PointLight)l, rayResult, color, phongColor);
            }
            resultColor = resultColor.sum(lColor);
        }
        return resultColor;
    }

    protected Color3f getPhongColor(RayResult rayResult) {
        return this.phongTexture.getColor(rayResult);
    }

    protected Color3f getColor(RayResult rayResult) {
        return this.texture.getColor(rayResult);
    }

    public Color3f light(AmbientLight light, RayResult rayResult, Color3f color) {
        return color.mult(light.getIntensity());
    }

    public Color3f light(DirectionalLight light, RayResult rayResult, Color3f color, Color3f phongColor) {
        float cos = Math.max(0.0f, Algebra.dot(rayResult.getNormal(), light.getLightDirection()));
        Vector3f h = Algebra.unit(Algebra.sum(light.getLightDirection(), Algebra.neg(rayResult.getWorldRay().d)));
        float cosPhong = (float)Math.pow(Math.max(0.0f, Algebra.dot(rayResult.getNormal(), h)), this.expPhong);
        return color.mult(light.getIntensity().mult(cos)).sum(phongColor.mult(light.getIntensity().mult(cosPhong)));
    }

    public Color3f light(PointLight light, RayResult rayResult, Color3f color, Color3f phongColor) {
        Vector3f lightDirection = Algebra.unit(Algebra.substract(light.getLightPosition(), rayResult.getWorldLocation()));
        float cos = Math.max(0.0f, Algebra.dot(rayResult.getNormal(), lightDirection));
        Vector3f h = Algebra.unit(Algebra.sum(lightDirection, Algebra.neg(rayResult.getWorldRay().d)));
        float cosPhong = (float)Math.pow(Algebra.dot(rayResult.getNormal(), h), this.expPhong);
        return color.mult(light.getIntensity().mult(cos)).sum(phongColor.mult(light.getIntensity().mult(cosPhong)));
    }
}

