/*
 * Decompiled with CFR 0.152.
 */
package tracer;

import algebra.Color3f;
import scene.Scene;
import tracer.RayTracer;
import util.HaltonSequence;

public class AAXTracer
extends RayTracer {
    public final int minTries;
    public final int stepTries;
    private final float delta;
    private int mostTries;

    public AAXTracer(Scene scene) {
        this(scene, 16, 8, 4096);
    }

    public AAXTracer(Scene scene, int min) {
        this(scene, min, min / 2, 256 * min);
    }

    public AAXTracer(Scene scene, int minTries, int stepTries, int levels) {
        super(scene);
        this.minTries = minTries;
        this.stepTries = stepTries;
        this.delta = 1.0f / (float)levels;
        this.mostTries = minTries;
    }

    @Override
    public Color3f trace(int x, int y) {
        HaltonSequence haltonX = new HaltonSequence(3, 3);
        HaltonSequence haltonY = new HaltonSequence(2, 20);
        int tries = 0;
        Color3f last = null;
        Color3f total = new Color3f(0.0f);
        while (true) {
            float u = (float)x + haltonX.next() - 0.5f;
            float v = (float)y + haltonY.next() - 0.5f;
            total = total.sum(this.shoot(u, v));
            if (++tries == this.minTries || tries % this.stepTries == 0 && tries >= this.minTries) {
                Color3f next = total.mult(1.0f / (float)tries);
                float diffr = last.x - next.x;
                float diffg = last.y - next.y;
                float diffb = last.z - next.z;
                last = next;
                if (!(-this.delta < diffr) || !(diffr < this.delta) || !(-this.delta < diffg) || !(diffg < this.delta) || !(-this.delta < diffb) || !(diffb < this.delta)) continue;
                break;
            }
            last = total.mult(1.0f / (float)tries);
        }
        if (tries > this.mostTries) {
            this.mostTries = tries;
            System.out.println("New most tries: " + tries);
        }
        return last;
    }
}

