// a full-featured(?) psx-3d-engine :)
// #define WIREFRAME
#define ASM_LIGHTING
#define ASM_TRANSPROJ
#define ASM_DRAWOBJECT
#include <stdio.h>
#include "enginea.h"
#include "engine.h"
#include "main.h"
#include "util.h"

MATRIX  _identity = { {{ONE,0,0},
                      {0,ONE,0},
                      {0,0,ONE}},
                      {0,0,0} };

int engineFlags=0;

int engineOpen()
{
#ifdef DEBUG
  printf("engineOpen()\n");
#endif
  return 0;
}

void engineClose()
{
#ifdef DEBUG
  printf("engineClose()\n");
#endif
}

void DumpOT()
{
  printf("beginning OT-dump, wspacepos: %p+%d\n", _curdisplayp->wspace
                        , _curdisplayp->wspacepos);
  unsigned int startaddr=_curdisplayp->ot[0];
  while (startaddr != _curdisplayp->ot[OTSIZE-1])
  {
    printf("Current address: %x\n", startaddr&0xFFFFFF);
    char *addr=(char*)(startaddr&0xFFFFFF);
    startaddr=*((long*)addr);
    if (!(startaddr>>24))
      continue;
    printf("  next: %x len: %x\n", startaddr&0xFFFFFF, startaddr>>24);
    printf("  C: %02x R: %02x G: %02x B: %02x\n",
      addr[7], addr[6], addr[5], addr[4]);
    if ((addr[7]&0xFF)==0x20)
    {
      printf("  POLY_FT3: (%d, %d)-(%d, %d)-(%d, %d)\n",
        ((short*)addr)[4], ((short*)addr)[5], ((short*)addr)[6],
        ((short*)addr)[7], ((short*)addr)[8], ((short*)addr)[9]);
    } else if  ((addr[7]&0xFF)==76)
    {
      printf("  LINE_F3: (%d, %d)-(%d, %d)-(%d, %d)\n",
        ((short*)addr)[4], ((short*)addr)[5], ((short*)addr)[6],
        ((short*)addr)[7], ((short*)addr)[8], ((short*)addr)[9]);
    }
  }
  printf("end of ot-dump.\n");
}


void object_s::tfBegin()
{
  MakeMatrix(matrix);
  if (child)
    for (object_s **tchild=child; *tchild; tchild++)
      (*tchild)->tfBegin();
}

/* void object_s::tfMatrixA(const MATRIX mat)
{
  MulMatrix(&matrix, (MATRIX*)&mat);
} */

void object_s::tfMatrixB(const MATRIX mat)
{
  MulMatrix2((MATRIX*)&mat, &matrix);
  VECTOR tr={matrix.t[0], matrix.t[1], matrix.t[2]};
  ApplyMatrixLV((MATRIX*)&mat, &tr, &tr);
  tr.vx+=mat.t[0];
  tr.vy+=mat.t[1];
  tr.vz+=mat.t[2];
  TransMatrix(&matrix, &tr);
}

void object_s::tfEnd()
{
  if (child)
    for (object_s **tchild=child; *tchild; tchild++)
    {
      (*tchild)->tfMatrixB(matrix);
      (*tchild)->tfEnd();
    }
//  DumpOT();
/*  printf("object %x (%d faces) tr=", this, faces);
  PrintFix(matrix.t[0]);
  printf(" ");
  PrintFix(matrix.t[1]);
  printf(" ");
  PrintFix(matrix.t[2]);
  printf("\n"); */
  if (faces)        ////  doofer workaround, besonders wenns dann mal partikel geben sollte.
    DoObject(this);
//  printf("%d resulting faces\n", _curdisplayp->wspacepos/20);
//  DumpOT();
}

void object_s::MakeMatrix(MATRIX &matrix)
{
  if (!matval)
  {
    RotMatrix_gte(&pos.r, &omatrix);
    TransMatrix(&omatrix, &pos.v);
    matval=!0;
  }
  memcpy(&matrix, &omatrix, sizeof(matrix));
}

void camera_s::MakeMatrix()
{
  if (matval)
    return;

  SVECTOR nrot;

  nrot.vx=-pos.r.vx;
  nrot.vy=-pos.r.vy;
  nrot.vz=-pos.r.vz;

  RotMatrix_gte(&nrot, &matrix);

  VECTOR npos;
  npos.vx=-pos.v.vx;
  npos.vy=-pos.v.vy;
  npos.vz=-pos.v.vz;
  ApplyMatrixLV(&matrix, &npos, &npos);
  matrix.m[1][0]=-matrix.m[1][0];
  matrix.m[1][1]=-matrix.m[1][1];
  matrix.m[1][2]=-matrix.m[1][2];
  TransMatrix(&matrix, &npos);

  matval=!0;
}

int minz, maxz, rminz, rmaxz, zcor=-4096, zfak=0;

void object_s::Clip()
{
}

void object_s::CalcNormals()
{
                 // FRAGEN: a.) funzt das? - tut es. b.) GTE
                //         c.) VertexNormals ber durchschnitt berechnen ;)

/*  for (int f=0; f<points; f++)
  {
    ovnormal[f].vx=0;
    ovnormal[f].vy=0;
    ovnormal[f].vz=0;
  } */

  int df=0;

  for (int f=0; f<faces; f++)
  {
    SVECTOR &v0=point[face_point[f*3+0]], &v1=point[face_point[f*3+1]],
            &v2=point[face_point[f*3+2]];
/*    printf("point %d-%d-%d, ", face_point[f*3+0], face_point[f*3+1],
                face_point[f*3+2]); */
    SVECTOR d0={v2.vx-v0.vx, v2.vy-v0.vy, v2.vz-v0.vz},
            d1={v0.vx-v1.vx, v0.vy-v1.vy, v0.vz-v1.vz};

    SVECTOR n;
    
    n.vx=((d0.vy*d1.vz)>>12)-((d0.vz*d1.vy)>>12);
    n.vy=((d0.vz*d1.vx)>>12)-((d0.vx*d1.vz)>>12);
    n.vz=((d0.vx*d1.vy)>>12)-((d0.vy*d1.vx)>>12);

    if (n.vx||n.vy||n.vz)
      VectorNormalSS(&n, &face[f].normal);
    else
    {
      printf("DEGENERATED face: %d\n", f);
      df++;
    }


/*    for (int i=0; i<3; i++)
    {
      ovnormal[face[f].point[i]].vx+=n.vx;
      ovnormal[face[f].point[i]].vy+=n.vy;
      ovnormal[face[f].point[i]].vz+=n.vz;
    }*/
  }
#ifdef DEBUG
  printf("\n");
#endif

/*  for (int f=0; f<points; f++)
  {
    if (ovnormal[f].vx||ovnormal[f].vy||ovnormal[f].vz)
      VectorNormalSS(&ovnormal[f], &ovnormal[f]);
    else
      printf("UNUSED vertex.\n");
  } */
#ifdef DEBUG
  printf("%d degenerated faces.\n", df);
#endif
  if (df>10)
    printf("perhaps you should higher your scale ;)\n");
}

extern "C" int TransZ(int z);

void engineRender(scene_s *scene)
{
  rminz=0x7FFFFFFF;
  rmaxz=0;

  if (engineFlags & 1)
  {
    zfak=0;
    zcor=OTSIZE-10;
  }

  scene->camera.MakeMatrix();
  scene->root->tfBegin();
  scene->root->tfMatrixB(scene->camera.matrix);
  scene->root->tfEnd();

  rminz*=3000;
  rminz/=4096;
  rmaxz/=3000;
  rmaxz*=4096;
  int zdif=rmaxz-rminz;
  if (zdif<0x100)   // to prevent strange effects...
    zdif=0x100;

  zfak=4096*4096/zdif/3;

  zcor=-(rminz*3*zfak)/4096;
/*  if (doprof) // && !(frame%30) )
  {
    printf("Ri: ");
    PrintFix(rminz);
    printf(" Ra: ");
    PrintFix(rmaxz);
    printf(" Mi: ");
    PrintFix(minz);
    printf(" Ma: ");
    PrintFix(maxz);
    printf(" Zc: ");
    PrintFix(zcor);
    printf(" Zf: ");
    PrintFix(zfak);
    printf(" TMinz: ");
    PrintFix(TransZ(rminz));
    printf(" TMaxz: ");
    PrintFix(TransZ(rmaxz));
    printf(" 0x1000: ");
    PrintFix(TransZ(0x1000));
    printf("\n");
  } 
*/
}

void object_s::TransferPoints()
{
  for (int i=0; i<faces; i++)
    for (int p=0; p<3; p++)
      face[i].pos[p]=point[face_point[i*3+p]];
}

void object_s::Initialize()
{
  parent=0;
  child=0;
  pos.r.vx=
  pos.r.vy=
  pos.r.vz=0;
  pos.v.vx=
  pos.v.vy=
  pos.v.vz=0;
  scale.vx=
  scale.vy=
  scale.vz=4096;
  matval=0;
  particle=0;
  face=0;
  faces=0;
  ovnormal=0;
  vnormal=0;
  point=0;
  face_surfaceid=0;
  particle=0;
  face_point=0;
}

void object_s::Free()
{
  if (child)
  {
    for (object_s **tchild=child; *tchild; tchild++)
    {
      (*tchild)->Free();
      delete *tchild;
    }
    delete[] child;
  }

  if (ovnormal)
    delete[] ovnormal;
  if (vnormal)
    delete[] vnormal;
  if (point)
    delete[] point;
  if (face_point)
    delete[] face_point;
  if (face_surfaceid)
    delete[] face_surfaceid;
  if (face)
    delete[] face;
  if (particle)
    delete[] particle;
}


void engineSetOption(int flags)
{
  engineFlags=flags;
}
