#include "main.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static scene_s *scene;

static int startframe, currentspos, currentspos2;

static TIM_IMAGE TIMPart3Back;

static void DoSchwarz(int schwarz);
static void DoText();
static void GanzWeiss(int frame);

int Part3Init(int frame)
{
#ifdef DEBUG
  printf("part 3 init.\n");
#endif
  startframe=frame;
  scene=new scene_s;
#ifdef DEBUG
  printf("initializing scene 3\n");
#endif
  extern char M_03bck1[], M_03msk1[], M_03msk2[];
  LoadTIM(M_03bck1, &TIMPart3Back);
  LoadTIM(M_03msk2);
  LoadTIM(M_03msk1);
  extern char LWO_Thing01[];
  scene->root=LoadLWO(LWO_Thing01);
  scene->root->scene=scene;
  scene->root->child=0;
  scene->root->pos.v.vx=100000;
  currentspos=1000*128;
  currentspos2=1000*128;
  return 0;
}

int Part3Frame(int frame)
{
  int flash=0;
  int colormode=0;
  frame-=startframe;

  if (frame>1628)
    return 1;
  else if (frame>1500)
  {
    GanzWeiss(frame-1500);
    return 0;
  }

                                 // setup light sources
  scene->l_dir.m[0][0]=2896;
  scene->l_dir.m[0][1]=2896;
  scene->l_dir.m[0][2]=0;

  scene->l_dir.m[1][0]=0;
  scene->l_dir.m[1][1]=0;
  scene->l_dir.m[1][2]=-4096;

  scene->l_dir.m[2][0]=0;
  scene->l_dir.m[2][1]=0;
  scene->l_dir.m[2][2]=0;
                                  // camera position
  scene->camera.pos.v.vx=-4096;
  scene->camera.pos.v.vy=0;
  scene->camera.pos.v.vz=-8192;
                                  // camera direction
  scene->camera.pos.r.vx=0;
  scene->camera.pos.r.vy=0;
  scene->camera.pos.r.vz=0;
  scene->camera.matval=0;
                                  // object position
  scene->root->matval=0;

  int fak;

  if (frame<409)
  {
    DoSchwarz(409-frame);
    scene->root->pos.r.vx=-276;
    scene->root->pos.r.vy+=30;
    scene->root->pos.r.vz=rsin(frame*10)/50;
  
    scene->root->pos.v.vx*=4000;
    scene->root->pos.v.vx/=4096;
    scene->root->pos.v.vy=0;
    scene->root->pos.v.vz=0;
    fak=frame*10;
  } else
  {
    scene->root->pos.r.vx=-276;
    scene->root->pos.r.vy+=30;
    if(frame>1300)
      scene->root->pos.r.vy+=(frame-1300);
    scene->root->pos.r.vz=0; // rsin(frame*10)/50;
  
    scene->root->pos.v.vx=0;
    scene->root->pos.v.vy=0;
    scene->root->pos.v.vz=0;
    fak=4096;
  }
  if(frame>1300)
  {
    fak=4096+(frame-1300)*100;
    if (frame&2)
      fak=0;

    flash=(frame-1300);
  }
                                  // setup light colors
                                  // setup ambient

  scene->l_color.m[0][1]=4096*3500/4096*fak/4096;
  scene->l_color.m[1][1]=4096*3500/4096*fak/4096;
  scene->l_color.m[2][1]=4096*fak/4096;

  scene->l_color.m[0][2]=4096*3500/4096*fak/4096;
  scene->l_color.m[1][2]=4096*3500/4096*fak/4096;
  scene->l_color.m[2][2]=4096*fak/4096;
  scene->l_color.t[0]=1024*fak/4096;
  scene->l_color.t[1]=1024*fak/4096;
  scene->l_color.t[2]=1024*fak/4096;

  int r, g, b;

  r=g=b=rsin(frame*78)/256 + rsin(frame*75+12)/256 + 76 + flash;

  int rgb=r | (g<<8) | (b<<16);

  if (frame>500)
  {
    colormode=!0;
    currentspos*=4000;
    currentspos/=4096;
    if (currentspos<512)
      colormode=0;
  }
  if (frame>650)
  {
    colormode=!0;
    currentspos2*=4000;
    currentspos2/=4096;
    if (currentspos2<512)
      colormode=0;
  }
  DoText();

  if (!colormode)
  {
    scene->l_color.m[0][0]=4096*3500/4096*fak/4096;
    scene->l_color.m[1][0]=4096*3500/4096*fak/4096;
    scene->l_color.m[2][0]=4096*fak/4096;
  } else
  {
    scene->l_color.m[0][0]=abs(rsin(frame*25));
    scene->l_color.m[1][0]=abs(rsin(frame*10));
    scene->l_color.m[2][0]=abs(rsin(frame*45));
  }


  engineRender(scene);
  introShowPicture(640, 0, getClut(0, 480), 1, rgb);
    
  return 0;
}

int Part3Close()
{
#ifdef DEBUG
  printf("closing Part3 ... SHOULD delete objects here.\n");
#endif
  scene->root->Free();
  delete scene->root;
  delete scene;
  return 0;
}

static void DoSchwarz(int schwarz)
{
  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_F4 *pf4=(POLY_F4*)startp;
  u_long *ot=_curdisplayp->ot;

  setPolyF4(pf4);

  pf4->r0=pf4->g0=pf4->b0=0;
  pf4->x0=0;
  pf4->y0=0;
  pf4->x1=320;
  pf4->y1=0;

  pf4->x2=0;
  pf4->y2=schwarz;

  pf4->x3=320;
  pf4->y3=schwarz;
  addPrim(ot+1, pf4);
  pf4++;

  setPolyF4(pf4);

  pf4->r0=pf4->g0=pf4->b0=0;
  pf4->x0=0;
  pf4->y0=240-schwarz;
  pf4->x1=320;
  pf4->y1=240-schwarz;

  pf4->x2=0;
  pf4->y2=240;

  pf4->x3=320;
  pf4->y3=240;
  addPrim(ot+1, pf4);
  pf4++;

  _curdisplayp->wspacepos += (char *)pf4 - startp;
}

static void DoText()
{
  int clut=getClut(0, 401);
  int tpage=getTPage(0, 0, 0, 256);

  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  setPolyFT4(pft4);
  setSemiTrans(pft4, 1);

  int fadeout=320-currentspos/128;
  if (fadeout<0)
    fadeout=0;

  pft4->r0=fadeout>>1;
  pft4->g0=fadeout>>1;
  pft4->b0=fadeout>>1;

  pft4->clut=clut;

  pft4->tpage=tpage;

  pft4->x0=currentspos/128;
  pft4->y0=110;

  pft4->x1=currentspos/128+222;
  pft4->y1=110;

  pft4->x2=currentspos/128;
  pft4->y2=110+41;

  pft4->x3=currentspos/128+222;
  pft4->y3=110+41;

  pft4->u0=0;
  pft4->v0=0;

  pft4->u1=222;
  pft4->v1=0;

  pft4->u2=0;
  pft4->v2=41;

  pft4->u3=222;
  pft4->v3=41;
  addPrim(ot+OTSIZE-3, pft4);
  pft4++;

  fadeout=320-currentspos2/128;
  if (fadeout<0)
    fadeout=0;

  setPolyFT4(pft4);
  setSemiTrans(pft4, 1);

  pft4->r0=fadeout>>1;
  pft4->g0=fadeout>>1;
  pft4->b0=fadeout>>1;

  pft4->clut=clut;

  pft4->tpage=tpage;

  pft4->x0=300-currentspos2/128-167;
  pft4->y0=200;

  pft4->x1=300-currentspos2/128;
  pft4->y1=200;

  pft4->x2=300-currentspos2/128-167;
  pft4->y2=200+44;

  pft4->x3=300-currentspos2/128;
  pft4->y3=200+44;

  pft4->u0=0;
  pft4->v0=42;

  pft4->u1=167;
  pft4->v1=42;

  pft4->u2=0;
  pft4->v2=44+42;

  pft4->u3=167;
  pft4->v3=42+44;
  addPrim(ot+OTSIZE-3, pft4);
  pft4++;

  _curdisplayp->wspacepos += (char *)pft4 - startp;
}

static void GanzWeiss(int frame)
{
  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_F4 *pf4=(POLY_F4*)startp;
  u_long *ot=_curdisplayp->ot;

  setPolyF4(pf4);

  pf4->r0=pf4->g0=pf4->b0=255-frame*2;
  pf4->x0=0;
  pf4->y0=0;
  pf4->x1=320;
  pf4->y1=0;

  pf4->x2=0;
  pf4->y2=240;

  pf4->x3=320;
  pf4->y3=240;
  addPrim(ot+1, pf4);
  pf4++;
  _curdisplayp->wspacepos += (char *)pf4 - startp;
}
