#include "main.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static scene_s *scene;

static int startframe, pos1, pos2, pos3;

static void WriteText(int which, int x, int y);

int Part7Init(int frame)
{
#ifdef DEBUG
  printf("part 7 init.\n");
#endif
  startframe=frame;
  scene=new scene_s;
#ifdef DEBUG
  printf("initializing scene 6\n");
#endif
  extern char M_07bck1[], M_07msk1[], M_07msk2[], M_07msk3[];
  LoadTIM(M_07bck1);
  LoadTIM(M_07msk1);
  LoadTIM(M_07msk2);
  LoadTIM(M_07msk3);
  extern char LWO_Thing5_1[];
  scene->root=LoadLWO(LWO_Thing5_1);

  scene->root->scene=scene;
  pos1=500*10;
  pos2=-800*10;
  pos3=100*10;
  return 0;
}

int Part7Frame(int frame)
{
  frame-=startframe;

  int fak=4096;

  if (frame>2000)
    fak=4096-(frame-2000)*20;
  if (fak<0)
    return 1;

                                 // setup light sources
  scene->l_dir.m[0][0]=2364;
  scene->l_dir.m[0][1]=2364;
  scene->l_dir.m[0][2]=2364;

  scene->l_dir.m[1][0]=0;
  scene->l_dir.m[1][1]=0;
  scene->l_dir.m[1][2]=4096;

  scene->l_dir.m[2][0]=0;
  scene->l_dir.m[2][1]=0;
  scene->l_dir.m[2][2]=0;
                                  // setup light colors
  scene->l_color.m[0][0]=4096*fak/4096;
  scene->l_color.m[1][0]=4096*fak/4096;
  scene->l_color.m[2][0]=4096*fak/4096;

  scene->l_color.m[0][1]=1024*fak/4096;
  scene->l_color.m[1][1]=1024*fak/4096;
  scene->l_color.m[2][1]=1024*fak/4096;

  scene->l_color.m[0][2]=4096*fak/4096;
  scene->l_color.m[1][2]=4096*fak/4096;
  scene->l_color.m[2][2]=4096*fak/4096;
                                  // setup ambient
  scene->l_color.t[0]=512*fak/4096;
  scene->l_color.t[1]=512*fak/4096;
  scene->l_color.t[2]=512*fak/4096;
                                  // camera position
  scene->camera.pos.v.vx=0;
  scene->camera.pos.v.vy=0;
  scene->camera.pos.v.vz=-15192;
                                  // camera direction
  scene->camera.pos.r.vx=0;
  scene->camera.pos.r.vy=0;
  scene->camera.pos.r.vz=0;
  scene->camera.matval=0;
                                  // object position
  scene->root->matval=0;

  scene->root->pos.r.vx+=10;
  scene->root->pos.r.vy=0;
  scene->root->pos.r.vz+=rsin(frame*10)/128;

  scene->root->pos.v.vx=0;
  scene->root->pos.v.vy=-(4096-fak)*3;
  scene->root->pos.v.vz=0;

  int r, g, b;

  r=g=b=fak>>5;

  int rgb=r | (g<<8) | (b<<16);

  engineRender(scene);
  introShowPicture(640, 0, getClut(0, 480), 1, rgb);

  if (frame>6*50)
  {
    pos1*=4000;
    pos1/=4096;
  }

  if (frame>15*50)
  {
    pos2*=4000;
    pos2/=4096;

    pos1+=40;
    
    pos1*=4096;
    pos1/=4000;
  }

  if (frame>25*50)
  {
    pos3*=4000;
    pos3/=4096;

    pos2+=40;
    
    pos2*=4096;
    pos2/=4000;
  }

  if (frame>35*50)
  {
    pos3+=40;
    
    pos3*=4096;
    pos3/=4000;
  }

  if (pos1 > 10000)
    pos1=10000;
  if (pos2 > 10000)
    pos1=10000;
  if (pos3 > 10000)
    pos1=10000;

  if (pos1 < 10000)
    WriteText(0, pos1/10, 50);
  if (pos2 < 10000)
    WriteText(1, pos2/10, 120);
  if (pos3 < 10000)
    WriteText(2, 0, 200+pos3/10);

  return 0;
}

int Part7Close()
{
#ifdef DEBUG
  printf("closing Part7 ... SHOULD delete objects here.\n");
#endif
  scene->root->Free();
  delete scene->root;
  delete scene;
#ifdef DEBUG
  printf("ok.\n");
#endif
  return 0;
}

static void WriteText(int which, int x, int y)
{
  int u=0, v, w, h;
  if (which==0)
  {
    v=0;
    w=316;
    h=54;
  } else if (which==1)
  {
    v=53;
    w=288;
    h=36;
  } else if (which==2)
  {
    v=88;
    w=257;
    h=36;
  } else
    return;

  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  int tp=0, tpage=getTPage(0, 0, 0, 256), clut=getClut(0, 481);

  while (w)
  {
    setPolyFT4(pft4);

    while (u>=256)
    {
      u-=256;
      tp+=256/4; // 4bit
      tpage=getTPage(0, 1, tp, 256);
      
    }
    int tw=w;
    if (tw>256)
      tw=256;
    tw--;

    pft4->r0=pft4->g0=pft4->b0=128;

    pft4->u0=u;
    pft4->v0=v;
    pft4->u1=u+tw;
    pft4->v1=v;
    pft4->u2=u;
    pft4->v2=v+h-1;
    pft4->u3=u+tw;
    pft4->v3=v+h-1;

    pft4->tpage=tpage;
    pft4->clut=clut;

    pft4->x0=x;
    pft4->y0=y;
    pft4->x1=x+tw+1;
    pft4->y1=y;
    pft4->x2=x;
    pft4->y2=y+h;
    pft4->x3=x+tw+1;
    pft4->y3=y+h;

    addPrim(ot+OTSIZE-1, pft4);
    pft4++;
    tw++;
    x+=tw;
    w-=tw;
    u+=tw;

  }
  _curdisplayp->wspacepos += (char *)pft4 - startp;
}
