/* Text-Mode-Demo */
/* Watch on Console */
/* writen by Chrissie of X-Tra-Designs in 02/2004 */
/* now with ncurses */

/* System Includes */
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <math.h>

#include <ncurses.h>

/* Meine Includes */
#include "logo.h"

// Funktionsprototypen
void generate(void);
void darstellen (int line, int col, int zoomlevel);
void print_bar (int y);

void do_zooming (void);

/* Special Funktions */
void clrscr(void) {
   printf("\E[H\E[J");
}

void gotoxy(int x, int y) {
   printf("\E[%i%d;%dH", 0, y, x);
}

void cursoroff(void)
{
  printf("\033[?25l");
}

void cursoron(void)
{
  printf("\033[?25h");
}

#define USLEEPVALUE 10000

// Wieviele Sinus-Werte?
#define MAXDEGS 80	//300
#define MAXDEGS2 400	//720
#define BARMAX 150	//720
#define PI 3.14159265

 int sinus[MAXDEGS];
 int sinus2[MAXDEGS2];
 int barsinus[BARMAX];



/* Tabelle fuer Zoom */
int zoomtable[110]={26,26,26,26,26,26,26,24,22,20,18,16,14,12,10,8,8,7,7,6,6,6,5,5,5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

// 
int zoomlevel;
int zoomrichtung, zoomcounter;


int main (void)

{

int i;
int line, col;
int x,y,y1,y2;

int eff;	// einzeleffektschleife



// Sinustabelle
generate();

initscr();	// ncurses initialisieren
clear();	// Bildschirm loeschen
// jetzt gehts los

cursoroff();


  /* Begin of The Intro */

 

  mvprintw(6,27, "X-Tra-Designs presents");
  refresh();

  usleep (4000000);
  mvprintw(10,20, "    aaa        ooo    u   u     t      ");
  mvprintw(11,20, "       a      o   o   u   u   ttttt    ");
  mvprintw(12,20, "    aaaa      o   o   u   u     t      ");
  mvprintw(13,20, "   a   a      o   o   u   u     t      ");
  mvprintw(14,20, "   aaaaa   x   ooo     uuuuu     tt    ");

  refresh();
  usleep (4000000);

  mvprintw (18,22,"coded by Chrissie of X-Tra-Designs");
  mvprintw (19,22,"         for 0a000h 2004          ");
  
  refresh();
  usleep (4000000);


  /* end of the intro */

line=0;
col=0;
y=0;
x=0;



	// Schritt 1: zoomlevel 1, nur hin und her scrollen
	//
for (eff=0; eff < 600; eff++)
{
  y++; if (y == MAXDEGS) y=0;
  x++; if (x == MAXDEGS2) x=0;
  line=sinus[y];
  col=sinus2[x];
  darstellen (10, col, 1);
  refresh();		// print on the real screen
  usleep(USLEEPVALUE);		// war mal 100
}
	// Schritt 2: zoomlevel 1, x und y scroll
	//
for (eff=0; eff < 570; eff++)
{
  y++; if (y == MAXDEGS) y=0;
  x++; if (x == MAXDEGS2) x=0;
  line=sinus[y];
  col=sinus2[x];
  darstellen (line, col, 1);
  refresh();		// print on the real screen
  usleep(USLEEPVALUE);		// war mal 100
  
}

	// jetzt still stehen lassen und nur zoomen
zoomcounter =70;
zoomrichtung = -1; 	// erst mal groesserzoomen

for (eff=0; eff < 280; eff++)
{
  do_zooming();
  darstellen (line+(zoomlevel/2), col, zoomlevel);
  refresh();		// print on the real screen
  usleep(USLEEPVALUE);		// war mal 100
}

 //Und jetzt alles!

for (eff=0; eff < 1000; eff++)
{
  y++; if (y == MAXDEGS) y=0;
  x++; if (x == MAXDEGS2) x=0;
  line=sinus[y];
  col=sinus2[x];
  do_zooming();
  darstellen (line, col, zoomlevel);
  refresh();		// print on the real screen
  usleep(USLEEPVALUE);		// war mal 100
}

/* Do some Rasterbars */
y=0;y1=20;y2=40;
for (eff=0;eff<500;eff++)
{
  y++; if (y == BARMAX) y=0;
  y1++; if (y1 == BARMAX) y1=0;
  y2++; if (y2 == BARMAX) y2=0;
  print_bar (barsinus[y]);
  print_bar (barsinus[y1]);
  print_bar (barsinus[y2]);
  refresh();
  usleep(USLEEPVALUE);
}
 
cursoron();
printf("?FORMULA TOO COMPLEX ERROR\n\r");
printf("READY.\n\r");
return 0;
}



/* Funktionen */

 // generiert Sinustabelle
void generate(void)
{

  float step;
  float pos;
  int counter;
	     
  //y-Richtung
  step = 2*PI/MAXDEGS;
  pos=0;
  for(counter=0;counter<MAXDEGS;counter++)
  {
    sinus[counter]=20+20*sin(pos);
//    printf("%i ",sinus[counter]);
    pos=pos+step;
  };

  //x-Richtung
  step = 2*PI/MAXDEGS2;
  pos=0;
  for(counter=0;counter<MAXDEGS2;counter++)
  {
    sinus2[counter]=111+111*sin(pos);	
//    printf("%i ",sinus2[counter]);
    pos=pos+step;
  };


 //bar-Sinus
  step = 2*PI/BARMAX;
  pos=0;
  for(counter=0;counter<BARMAX;counter++)
  {
    barsinus[counter]=9+9*sin(pos);	
//    printf("%i ",barsinus[counter]);
    pos=pos+step;
  };

}

// malt eine Rasterbar auf y. y im Bereich von 0 - 20
void print_bar (int y)
{
  mvprintw(y,0,"                                                                                ");
  mvprintw(y+1,0,"................................................................................");
  mvprintw(y+2,0,";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;");
  mvprintw(y+3,0,"WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
  mvprintw(y+4,0,";;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;");
  mvprintw(y+5,0,"''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''");
  mvprintw(y+6,0,"                                                                                ");
};
 

// Diese Routine zaehlt einfach den Zoomcounter weiter
void do_zooming (void)
{
if (zoomrichtung == -1) 
{
	if (zoomcounter > 1)
	{
		zoomlevel = zoomtable[zoomcounter]; zoomcounter--;
	}
	else
	{
		zoomrichtung = +1;
	}
}
else
{
	if (zoomcounter <80)
	{
		zoomlevel = zoomtable[zoomcounter]; zoomcounter++;
	}
	else
	{
		zoomrichtung = -1;
	}
}
}
// Ausschnitt darstellen
// jetzt auch zoombar (WOW!)
// Diese Funktion stellt einen Ausschnitt vom logo x,y, zoomlevel
// auf stdscr.
// x: range 0 - 111
// y: range 0 - 20
// zoomlevel: 1 - 26   26 = 1 zu 1, nicht ausgezoomt
void darstellen (int line, int col, int zoomlevel)
{

char out[25][150];
	int i ;
	// fuer y-zooming
	int zeilenzoomwert, auslasswert, srcline;
//fuer x-zoomen
int k,l;
int endwert;
int length;

char *srcptr, *dstptr;

zeilenzoomwert = zoomlevel;
auslasswert=0;
  
for (i=0; i<25; i++)
{
  if (zoomlevel == 26)		// bei 26 garnix zoomen
  {
    memcpy (&out[i][0], &c[line+i][col], 80);
    out[i][81]=0;
  }
  else
  {
	  /* Y-Zooming */
	  if (i == zeilenzoomwert)
	  {
		  zeilenzoomwert += zoomlevel;
		  auslasswert++;
	  }
	srcline = line + auslasswert + i;
	if (srcline > 62) srcline = 62; //  weil logo nur soundso hoch
        srcptr = &c[srcline][col];

	/* X-Zooming */
    endwert=80/zoomlevel;
    dstptr = &out[i][0];
    length=zoomlevel;
    for (k=0; k<endwert+3; k++)	// +3 wegen 'Abloeschfehler' am Ende d. Zeile
    {
      memcpy (dstptr, srcptr, length);
      dstptr += zoomlevel;
      srcptr +=zoomlevel; srcptr++;
    }		    
      out[i][81]=0;
  }
	  

}

for (i=0; i<25; i++)
{
  mvprintw(i,0, out[i]);	// print all to stdscr (Achtung - y x !!)
}

}
