// Example scripting engine
// written based on Obs engine
// (c)'01 by SquoQuo
// All code done by Hopper/SquoQuo

#include <stdlib.h>		// for NULL definition
#include "Scene.h"
#include "Parameter.h"
#include "Function.h"

#ifndef __ENGINE_PART
#define __ENGINE_PART

class Part
{
public:
	char name[128];		// name of the part
	float position;		// start time of part
	float start;			// internal start time of part (added to actual time) *** use this for backwards playing
	float length;			// length of part (in seconds)
	float speed;			// 1.0=normal, -1.0=backwards, etc. (this does not apply to the parameters! only the time parameter is affected!)
	char track;				// track number (used for sorting simultaneous parts)
	Function **functions;		// list of the functions that are executed by this part

	// constructor
	Part();

	// destructor
	~Part();

	// executes the part
	// Checks, if the part is active (i.e. time is between start and start+length)
	// yes => execute all functions
	void execute(float time);
};

#endif