/* Cosine calculation using Taylor series
 * Written by Claus D. Volko a.k.a. Adok/Hugi on June 11, 2001
 * Simple version
 *
 * Note: don't use precision > 14 or it will return wrong results due to overflow errors(?)
 * Returns good results only for about -pi to +pi
 *
 * Use CTRL+BREAK to stop execution
 */

#include <stdio.h>

typedef float radiants;

float cos(radiants angle, int precision)
{
  float cosine = 1, xtag = 1, quangle = angle * angle;
  int faculty = 1, i;

  for(i = 1; i < precision; i++ )
  {
    faculty *= i;
    i++;
    faculty *= i;
    faculty = ~faculty ++;
    xtag *= quangle;
    cosine += xtag / faculty;
  }

  return cosine;
}


void main(void)
{
  int precision;
  radiants angle;

  printf("precision: ");
  scanf("%d", &precision);

  while(1)
  {
    printf("\n\nangle: ");
    scanf("%f", &angle);
    printf("\ncosine: %f", cos(angle, precision));
  }
}