/* Cosine calculation using Taylor series
 * Written by Claus D. Volko a.k.a. Adok/Hugi on June 11, 2001
 * Table version with unlimited range
 *
 * Note: don't use precision > 14 or it will return wrong results due to overflow errors(?)
 *
 * Use CTRL+BREAK to stop execution
 */

#include <stdio.h>

#define PI 3.141592654

typedef float radiants;

int cos_generatetable(signed int * costable, int precision)
{
  int faculty = 1, i, j;

  if(!costable) return NULL;

  for(i = 1, j = 0; i < precision; i++, j++)
  {
    faculty *= i;
    i++;
    faculty *= i;
    faculty = ~faculty ++;
    costable[j] = faculty;
  }

  return 1;
}

float cos(radiants angle, int precision, signed int * costable)
{
  float cosine = 1, xtag = 1, quangle;
  int j;
  char setsignflag = 0;

  if(NULL==costable) return NULL;

  if(angle < 0) angle = -angle;			// make angle a non-negative number
  angle -= 2 * PI * (int) (angle / (2 * PI));	// make angle fit in the range 0 ... 2*PI
  if(angle > PI / 2)				// make angle fit in the range -PI ... PI/2 and remember to change sign if necessary
  {
    setsignflag++;
    angle = PI - angle;
  }

  quangle = angle * angle;

  for(j = 0; j < precision >> 1; j++)
  {
    xtag *= quangle;
    cosine += xtag / costable[j];
  }

  if(setsignflag) cosine = -cosine;

  return cosine;
}


int main(void)
{
  int precision, * costable;
  radiants angle;

  printf("precision: ");
  scanf("%d", &precision);

  costable = new int[precision >> 1 + 1];
  if(!cos_generatetable(costable, precision))
  {
    printf("Memory allocation error.");
    return NULL;
  }

  while(1)
  {
    printf("\n\nangle: ");
    scanf("%f", &angle);
    printf("\ncosine: %f", cos(angle, precision, costable));
  }
}
