/* A demonstration of Selection Sort, Insertion Sort, Bubble Sort, Shell Sort and Quick Sort
 * Written by Claus D. Volko a.k.a. Adok/Hugi on June 8, 2001
 */

#define DEBUG

#define ALGONUM 5

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

void debug(int *intarray, int arraysize)
{
  int i;

  for(i=arraysize;i;i--) printf("%d ", intarray[i-1]);
  getch();
  printf("\n");
}

void swap(int *a, int *b)
{
  int h = *a;
  *a = *b;
  *b = h;
}

void selectionsort(int *array, int n)
{
  int first, i, smallest;

  for(first=0; first<n-1; first++)
  {
    smallest=first;
    for(i=first+1; i<n; i++)
    {
      if(array[i]<array[smallest]) smallest = i;
    }
    swap(&array[first], &array[smallest]);
    #ifdef DEBUG
    debug(array,n);
    #endif
  }
}

void insertionsort(int *array, int n)
{
  int source, i, j;

  for(source=1; source<n; source++)
  {
    for(j=source; j && (array[j]<array[j-1]); j--)
    {
      swap(&array[j], &array[j-1]);
    }
    #ifdef DEBUG
    debug(array,n);
    #endif
  }
}

void shellsort(int *array, int n)
{
  int distance = n / 10, source, i, j;

  if(!distance) distance++;

  for(; distance; distance/=10)
  {
    for(source=1; source<=n-distance; source++)
    {
      for(j=source; (j>=distance) && (array[j]<array[j-distance]); j--)
      {
        swap(&array[j], &array[j-distance]);
      }
      #ifdef DEBUG
      debug(array,n);
      #endif
    }
  }
}

void bubblesort(int *array, int n)
{
  int i, flag;
  do
  {
    flag = 0;
    for(i=0; i<n-1; i++)
    {
      if(array[i]>array[i+1])
      {
        swap(&array[i], &array[i+1]);
        flag = -1;
      }
    }
    #ifdef DEBUG
    debug(array,n);
    #endif
  }
  while(flag);
}

void quicksort(int *array, int start, int stop)
{
  int left = start,
      right = stop,
      center = array[(start + stop) / 2];

  while(left<right)
  {
    while(array[left]<center) left++;
    while(array[right]>center) right--;
    if(left<=right)
    {
      swap(&array[left], &array[right]);
      left++;
      right--;
    }
    #ifdef DEBUG
    debug(array+start,stop-start+1);
    #endif
  }
  if(right>start) quicksort(array, start, right);
  if(left<stop) quicksort(array, left, stop);
}

void quicksort_start(int *array, int num)
{
  quicksort(array, 0, num-1);
}


void main()
{
  int num, i, j, *orig, *temp;
  char *algoname[ALGONUM]={"Selection Sort", "Insertion Sort", "Shell Sort", "Bubble Sort", "Quick Sort"};
  void (*algocode[ALGONUM])(int *, int)={&selectionsort, &insertionsort, &shellsort, &bubblesort, &quicksort_start};

  printf("Number of List items? ");
  scanf("%d",&num);
  orig = new int[num];
  temp = new int[num];

  printf("\nUnsorted list:\n");
  #ifdef __BORLANDC__
  randomize();
  #endif
  for(i=num;i;i--) printf("%d ", temp[i-1]=orig[i-1]=rand());

  for(j=0; j<ALGONUM; j++)
  {
    printf("\n\nSorting using %s\n",algoname[j]);
    algocode[j](temp, num);
    printf("\nSorted list:\n");
    for(i=num;i;i--)
    {
      printf("%d ", temp[i-1]);
      temp[i-1]=orig[i-1];
    }
    getch();
  }
}
