// Accelerator.cpp: implementation of the CAccelerator class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Accelerator.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define	BASERADIUS		30.0f
#define	SPHERECOLOR		0x200040ff
#define FEEDBACKFACTOR	6.0f

VOID ApplyFeedback( PDIRECT3DVERTEXBUFFER8 pvb, FLOAT fWidth, FLOAT fHeight, FLOAT fFactor )
{
	PTLVERTEX				pV;

	pvb->Lock( 0, 0, (LPBYTE*)&pV, 0 );

	for( DWORD i = 1 ; i < 4 ; i++ )
	{
		pV[i*6+0].m_vPos.x = 0.0f - FEEDBACKFACTOR*fFactor*(FLOAT)i;
		pV[i*6+0].m_vPos.y = fHeight + FEEDBACKFACTOR*fFactor*(FLOAT)i;

		pV[i*6+1].m_vPos.x = 0.0f - FEEDBACKFACTOR*fFactor*(FLOAT)i;
		pV[i*6+1].m_vPos.y = 0.0f - FEEDBACKFACTOR*fFactor*(FLOAT)i;

		pV[i*6+2].m_vPos.x = fWidth + FEEDBACKFACTOR*fFactor*(FLOAT)i;
		pV[i*6+2].m_vPos.y = fHeight + FEEDBACKFACTOR*fFactor*(FLOAT)i;

		pV[i*6+3].m_vPos.x = fWidth + FEEDBACKFACTOR*fFactor*(FLOAT)i;
		pV[i*6+3].m_vPos.y = fHeight + FEEDBACKFACTOR*fFactor*(FLOAT)i;

		pV[i*6+4].m_vPos.x = 0.0f - FEEDBACKFACTOR*fFactor*(FLOAT)i;
		pV[i*6+4].m_vPos.y = 0.0f - FEEDBACKFACTOR*fFactor*(FLOAT)i;

		pV[i*6+5].m_vPos.x = fWidth + FEEDBACKFACTOR*fFactor*(FLOAT)i;
		pV[i*6+5].m_vPos.y = 0.0f - FEEDBACKFACTOR*fFactor*(FLOAT)i;
	}

	pvb->Unlock();
}

CAccelerator::CAccelerator( PDIRECT3DDEVICE8 pDevice ) : CEfx( pDevice ),
														 m_pvbParticle( NULL ),
														 m_pvbSphere( NULL ),
														 m_pvbFxPlane( NULL ),
														 m_pvbWireframe( NULL ),
														 m_pvbFxPod( NULL ),
														 m_pvbFxPod2( NULL ),
														 m_pvbBassPod( NULL ),
														 m_pibSphere( NULL ),
														 m_pibFxPlane( NULL ),
														 m_piqFade( NULL ),
														 m_piqHole( NULL ),
														 m_ptrBass( NULL ),
														 m_ptrSphere( NULL )
{

	// creatr & load

	try
	{		
		LoadAlphaTexture( "fxtexture.bmp" );
		LoadTexture( "particle.bmp" );
		LoadTexture( "pblue.jpg" );
		LoadAlphaTexture( "alpha.bmp" );
		LoadAlphaTexture( "stain.bmp" );		

		for( DWORD i = 0 ; i < 32 ; i++ )
		{
			TCHAR			name[] = "caust00.bmp";

			_stprintf( name, "caust%02i.bmp", i );
			LoadAlphaTexture( name );
			m_ptextCaust[i] = GetTexture( name );
		}
	}
	catch( CTextureException )
	{	
		throw CSystemException( "unable to load textures" );
	}

	if( !m_smAccelerator.Load( m_pDevice, "data\\objects\\accelerator.smf" ) )	
		throw CSystemException( "unable to load accelerator.smf" );	

	if( FAILED( m_pDevice->CreateVertexBuffer( 6*m_smAccelerator.GetFacesCount()*sizeof(SIMPLEVERTEX), 0, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbWireframe ) ) )	
		throw CSystemException( "unable to create wireframe vertex buffer" );	

	if( FAILED( m_pDevice->CreateVertexBuffer( 4*sizeof(LVERTEX), 0, FVF_LVERTEX, D3DPOOL_DEFAULT, &m_pvbFxPod ) ) )	
		throw CSystemException( "unable to create fxpod vertex buffer" );	

	if( FAILED( m_pDevice->CreateVertexBuffer( 2500*sizeof(LVERTEX), 0, FVF_LVERTEX, D3DPOOL_DEFAULT, &m_pvbFxPlane ) ) )	
		throw CSystemException( "unable to create fx plane vertex buffer" );	

	if( FAILED( m_pDevice->CreateIndexBuffer( 4900*sizeof(WORD), 0, D3DFMT_INDEX16, D3DPOOL_DEFAULT, &m_pibFxPlane ) ) )	
		throw CSystemException( "unable to create fx plane index buffer" );	

	if( FAILED( m_pDevice->CreateVertexBuffer( (14*8+2)*sizeof(SIMPLEVERTEX), D3DUSAGE_POINTS, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbSphere ) ) )			
		throw CSystemException( "unable to create sphere vertex buffer" );	

	if( FAILED( m_pDevice->CreateIndexBuffer( (2*16*8 + 2*7*16)*sizeof(WORD), 0, D3DFMT_INDEX16, D3DPOOL_DEFAULT, &m_pibSphere ) ) )			
		throw CSystemException( "unable to create sphere vertex buffer" );	

	if( FAILED( m_pDevice->CreateVertexBuffer( 4*6*sizeof(TLVERTEX), 0, FVF_TLVERTEX, D3DPOOL_DEFAULT, &m_pvbBassPod ) ) )			
		throw CSystemException( "unable to create bass pod" );	

	if( !m_psAccelerator.Initialize( m_pDevice ) )	
		throw CSystemException( "unable to initialize particle system" );	

	m_piqFade = new CImageQuad( m_pDevice );
	m_piqHole = new CImageQuad( m_pDevice );	

	m_ptrSphere = new CTextureRenderer( m_pDevice, FALSE, 512, 512 );
	m_ptrBass = new CTextureRenderer( m_pDevice, FALSE, 512, 512 );

	// init

	m_bRenderFade = FALSE;

	m_piqHole->Resize( -50.0f, 100.0f, 400.0f, 550.0f );

	m_psAccelerator.ConfigureGravity( G_VECTOR, he3d_CVector( 0.0f, 1.0f, 0.0f ), 0.0f );
	m_psAccelerator.SetCollision( C_OFF );
	m_psAccelerator.SetTexture( GetTexture( "particle.bmp" ) );

	he3d_CVector			pvEmiters[9];

	pvEmiters[0] = he3d_CVector( 3.2f, 33.5f, -85.0f );
	pvEmiters[1] = he3d_CVector( 33.2f, 7.0f, 95.5f );
	pvEmiters[2] = he3d_CVector( 55.0f, -3.6f, -37.5f );
	pvEmiters[3] = he3d_CVector( -60.5f, -22.2f, -10.5f );
	pvEmiters[4] = he3d_CVector( -15.0f, 37.0f, -32.0f );
	pvEmiters[5] = he3d_CVector( 55.5f, 40.0f, -9.0f );
	pvEmiters[6] = he3d_CVector( -30.5f, 68.5f, 20.5f );
	pvEmiters[7] = he3d_CVector( 37.0f, -81.0f, 22.5f );
	pvEmiters[8] = he3d_CVector( -7.0f, -21.5f, 27.5f );

	FLOAT					fLifeTime;

	for( DWORD i = 0 ; i < 9 ; i++ )
	{	
		fLifeTime = Length( pvEmiters[i] );

		for( DWORD j = 0 ; j < 3 ; j++ )
		{	
			m_peEmiters[i*3 + j].SetEmitAngle( 0.02f );
			m_peEmiters[i*3 + j].SetEmitCount( 1, 0 );		
			m_peEmiters[i*3 + j].SetVelocity( 5.0f, 2.0f );
			m_peEmiters[i*3 + j].SetSize( 10.0f, 5.0f );
			m_peEmiters[i*3 + j].SetParticleType( PT_STANDARD );

			FLOAT				fAlpha = H_2PI*RAND();
			FLOAT				fBeta = H_2PI*RAND();
			FLOAT				fRadius = 3.0f*RAND();

			m_peEmiters[i*3 + j].SetLifeTime( fLifeTime/6.0f, 0.0f );
			m_peEmiters[i*3 + j].SetEmiterPos( pvEmiters[i] + Polar2Cartesian3d( fRadius, fAlpha, fBeta ) );
			m_peEmiters[i*3 + j].SetEmiterDir( -pvEmiters[i] );

			m_psAccelerator.AddEmiter( &m_peEmiters[i*3 +j] );
		}
	}	

	for( fLifeTime = 0.0f ; fLifeTime < 20.0f ; fLifeTime += 0.25f )
		m_psAccelerator.Update( fLifeTime );

	PLVERTEX				pVerts;

	m_pvbFxPod->Lock( 0, 0, (LPBYTE*)&pVerts, 0 );

	*(pVerts++) = LVERTEX( -200.0f, -200.0f, 0.0f, 0x0, 0.0f, 1.0f );
	*(pVerts++) = LVERTEX( -200.0f, 200.0f, 0.0f, 0x0, 0.0f, 0.0f );
	*(pVerts++) = LVERTEX( 200.0f, -200.0f, 0.0f, 0x0, 1.0f, 1.0f );
	*(pVerts++) = LVERTEX(  200.0f, 200.0f, 0.0f, 0x0, 1.0f, 0.0f );

	m_pvbFxPod->Unlock();	
	
	PSIMPLEVERTEX			pVertices;	
	PVERTEX					pV;
	LPWORD					pIndices;

	m_pvbWireframe->Lock( 0, 0, (LPBYTE*)&pVertices, 0 );
	m_smAccelerator.LockMesh( (LPBYTE*)&pV, (LPBYTE*)&pIndices );

	for( i = 0 ; i < m_smAccelerator.GetFacesCount() ; i++ )
	{
		*(pVertices++) = SIMPLEVERTEX( pV[pIndices[3*i+0]].m_vPos, 0x15a0a0a0 );
		*(pVertices++) = SIMPLEVERTEX( pV[pIndices[3*i+1]].m_vPos, 0x15a0a0a0 );

		*(pVertices++) = SIMPLEVERTEX( pV[pIndices[3*i+1]].m_vPos, 0x15a0a0a0 );
		*(pVertices++) = SIMPLEVERTEX( pV[pIndices[3*i+2]].m_vPos, 0x15a0a0a0 );

		*(pVertices++) = SIMPLEVERTEX( pV[pIndices[3*i+2]].m_vPos, 0x15a0a0a0 );
		*(pVertices++) = SIMPLEVERTEX( pV[pIndices[3*i+0]].m_vPos, 0x15a0a0a0 );
	}

	m_pvbWireframe->Unlock();
	m_smAccelerator.UnlockMesh();	

	PTLVERTEX				pVerts2;
	D3DVIEWPORT8			d3dvp;

	m_pDevice->GetViewport( &d3dvp );
	m_pvbBassPod->Lock( 0, 0, (LPBYTE*)&pVerts2, 0 );
	
	*(pVerts2++) = TLVERTEX( 0.0f, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x80ffffff,  0.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f,   0.0f, 0.0f, 0.5f, 0x80ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x80ffffff,  1.0f, 1.0f );

	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x80ffffff,  1.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f, 0.0f, 0.0f, 0.5f, 0x80ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, 0.0f, 0.0f, 0.5f, 0x80ffffff,  1.0f, 0.0f );					

	*(pVerts2++) = TLVERTEX( 0.0f, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x50ffffff,  0.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f,   0.0f, 0.0f, 0.5f, 0x50ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x50ffffff,  1.0f, 1.0f );

	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x50ffffff,  1.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f, 0.0f, 0.0f, 0.5f, 0x50ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, 0.0f, 0.0f, 0.5f, 0x50ffffff,  1.0f, 0.0f );					

	*(pVerts2++) = TLVERTEX( 0.0f, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x20ffffff,  0.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f,   0.0f, 0.0f, 0.5f, 0x20ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x20ffffff,  1.0f, 1.0f );

	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x20ffffff,  1.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f, 0.0f, 0.0f, 0.5f, 0x20ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, 0.0f, 0.0f, 0.5f, 0x20ffffff,  1.0f, 0.0f );					

	*(pVerts2++) = TLVERTEX( 0.0f, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x10ffffff,  0.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f,   0.0f, 0.0f, 0.5f, 0x10ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x10ffffff,  1.0f, 1.0f );

	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, 0.0f, 0.5f, 0x10ffffff,  1.0f, 1.0f );
	*(pVerts2++) = TLVERTEX( 0.0f, 0.0f, 0.0f, 0.5f, 0x10ffffff,  0.0f, 0.0f );
	*(pVerts2++) = TLVERTEX( (FLOAT)d3dvp.Width, 0.0f, 0.0f, 0.5f, 0x10ffffff,  1.0f, 0.0f );					

	m_pvbBassPod->Unlock();

	m_bRenderBass = FALSE;

	DWORD					dwIndex = 0;	

	m_ppfSphere[dwIndex  ][0] = 0.0f;
	m_ppfSphere[dwIndex++][1] = 0.0f;

	m_ppfSphere[dwIndex  ][0] = 0.0f;
	m_ppfSphere[dwIndex++][1] = H_PI;

	for( i = 0 ; i < 16 ; i++ )
	{
		for( DWORD j = 1 ; j < 8 ; j++ )		
		{		
			m_ppfSphere[dwIndex  ][0] = (FLOAT)i*H_2PI/16.0f;
			m_ppfSphere[dwIndex++][1] = (FLOAT)j*H_PI/8.0f;
		}			
	}


	for( i = 0 ; i < 8*14 + 2 ; i++ )
		m_pdwSyncIndex[i] = 1 + rand()%5;

	m_pibSphere->Lock( 0, 0, (LPBYTE*)&pIndices, 0 );

	for( i = 0 ; i < 16 ; i++ )
	{
		*(pIndices++) = 0;
		*(pIndices++) = (WORD)(7*i + 2);

		for( DWORD j = 0 ; j < 6 ; j++ )
		{
			*(pIndices++) = (WORD)(7*i + j + 2);
			*(pIndices++) = (WORD)(7*i + j + 1 + 2);
		}

		*(pIndices++) = (WORD)(7*i + 6 + 2);
		*(pIndices++) = 1;
	}
		

	for( i = 0 ; i < 7 ; i++ )
	{
		for( DWORD j = 0 ; j < 15 ; j++ )
		{
			*(pIndices++) = (WORD)( 7*j + i + 2 );
			*(pIndices++) = (WORD)( 7*( j + 1 ) + i + 2 );
		}

		*(pIndices++) = (WORD)(7*15 + i + 2);
		*(pIndices++) = (WORD)(i + 2);
	}

	m_pibSphere->Unlock();

	m_pvbFxPlane->Lock( 0, 0, (LPBYTE*)&pVerts, 0 );

	for( i = 0 ; i < 50 ; i++ )
		for( DWORD j = 0 ; j < 50 ; j++ )		
			*(pVerts++) = LVERTEX( (FLOAT)j*1.5f, 70.0f - (FLOAT)i*1.5f, 0.0f, 0xff202020, 0.01f + (FLOAT)j/52.0f, (FLOAT)i/52.0f );

	m_pvbFxPlane->Unlock();		

	m_pibFxPlane->Lock( 0, 0, (LPBYTE*)&pIndices, 0 );

	for( i = 0 ; i < 50 ; i+=2 )
		for( DWORD j = 0 ; j < 48 ; j+=2 )
		{
			*(pIndices++) = (WORD)(50*i + j);
			*(pIndices++) = (WORD)(50*i + j + 2);
		}

	for( i = 0 ; i < 50 ; i+=2 )
		for( DWORD j = 0 ; j < 48 ; j+=2 )
		{
			*(pIndices++) = (WORD)(50*j + i);
			*(pIndices++) = (WORD)(50*(j+2) + i);
		}

	m_pibFxPlane->Unlock();

	for( i = 0 ; i < 2500 ; i++ )
	{
		m_ppiWater[0][i] = 0;
		m_ppiWater[1][i] = 0;
	}

	m_dwCurrentWaterPage = 0;

	//sync splines

	m_fSync[0][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[0][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[0][ 2] = FLOATKEY(  1.44f,  0.00f );
	m_fSync[0][ 3] = FLOATKEY(  1.64f,  1.00f );
	m_fSync[0][ 4] = FLOATKEY(  1.75f,  0.00f );
	m_fSync[0][ 5] = FLOATKEY(  1.85f,  1.00f );
	m_fSync[0][ 6] = FLOATKEY(  2.05f,  0.00f );
	m_fSync[0][ 7] = FLOATKEY(  2.10f,  0.00f );
	m_fSync[0][ 8] = FLOATKEY(  2.30f,  1.00f );
	m_fSync[0][ 9] = FLOATKEY(  2.50f,  0.00f );
	m_fSync[0][10] = FLOATKEY(  3.26f,  0.00f );
	m_fSync[0][11] = FLOATKEY(  3.46f,  1.00f );
	m_fSync[0][12] = FLOATKEY(  3.57f,  0.00f );
	m_fSync[0][13] = FLOATKEY(  3.68f,  1.00f );
	m_fSync[0][14] = FLOATKEY(  3.88f,  0.00f );
	m_fSync[0][15] = FLOATKEY(  3.91f,  0.00f );
	m_fSync[0][16] = FLOATKEY(  4.11f,  1.00f );
	m_fSync[0][17] = FLOATKEY(  4.31f,  0.00f );
	m_fSync[0][18] = FLOATKEY(  5.09f,  0.00f );
	m_fSync[0][19] = FLOATKEY(  5.28f,  1.00f );
	m_fSync[0][20] = FLOATKEY(  5.40f,  0.00f );
	m_fSync[0][21] = FLOATKEY(  5.51f,  1.00f );
	m_fSync[0][22] = FLOATKEY(  5.70f,  0.00f );
	m_fSync[0][23] = FLOATKEY(  5.89f,  1.00f );
	m_fSync[0][24] = FLOATKEY(  6.09f,  0.00f );
	m_fSync[0][25] = FLOATKEY(  6.84f,  0.00f );
	m_fSync[0][26] = FLOATKEY(  7.04f,  1.00f );
	m_fSync[0][27] = FLOATKEY(  7.24f,  0.00f );
	m_fSync[0][28] = FLOATKEY(  7.50f,  0.00f );
	m_fSync[0][29] = FLOATKEY(  7.70f,  1.00f );
	m_fSync[0][30] = FLOATKEY(  7.90f,  0.00f );
	m_fSync[0][31] = FLOATKEY( 10.02f,  0.00f );
	m_fSync[0][32] = FLOATKEY( 10.22f,  1.00f );
	m_fSync[0][33] = FLOATKEY( 10.42f,  0.00f );
	m_fSync[0][34] = FLOATKEY( 10.67f,  0.00f );
	m_fSync[0][35] = FLOATKEY( 10.87f,  1.00f );
	m_fSync[0][36] = FLOATKEY( 11.01f,  0.00f );
	m_fSync[0][37] = FLOATKEY( 11.15f,  1.00f );
	m_fSync[0][38] = FLOATKEY( 11.35f,  0.00f );
	m_fSync[0][39] = FLOATKEY( 11.40f,  0.00f );
	m_fSync[0][40] = FLOATKEY( 11.60f,  1.00f );
	m_fSync[0][41] = FLOATKEY( 11.71f,  0.00f );
	m_fSync[0][42] = FLOATKEY( 11.83f,  1.00f );
	m_fSync[0][43] = FLOATKEY( 12.03f,  0.00f );
	m_fSync[0][44] = FLOATKEY( 12.94f,  0.00f );
	m_fSync[0][45] = FLOATKEY( 13.14f,  1.00f );
	m_fSync[0][46] = FLOATKEY( 13.34f,  0.00f );
	m_fSync[0][47] = FLOATKEY( 16.30f,  0.00f );
	m_fSync[0][48] = FLOATKEY( 16.50f,  1.00f );
	m_fSync[0][49] = FLOATKEY( 16.70f,  0.00f );
	m_fSync[0][50] = FLOATKEY( 17.66f,  0.00f );
	m_fSync[0][51] = FLOATKEY( 17.86f,  1.00f );
	m_fSync[0][52] = FLOATKEY( 17.97f,  0.00f );
	m_fSync[0][53] = FLOATKEY( 18.07f,  1.00f );
	m_fSync[0][54] = FLOATKEY( 18.27f,  0.00f );
	m_fSync[0][55] = FLOATKEY( 19.18f,  0.00f );
	m_fSync[0][56] = FLOATKEY( 19.38f,  1.00f );
	m_fSync[0][57] = FLOATKEY( 19.58f,  0.00f );
	m_fSync[0][58] = FLOATKEY( 20.57f,  0.00f );
	m_fSync[0][59] = FLOATKEY( 20.77f,  1.00f );
	m_fSync[0][60] = FLOATKEY( 20.97f,  0.00f );
	m_fSync[0][61] = FLOATKEY( 23.08f,  0.00f );
	m_fSync[0][62] = FLOATKEY( 23.28f,  1.00f );
	m_fSync[0][63] = FLOATKEY( 23.37f,  0.00f );
	m_fSync[0][64] = FLOATKEY( 23.46f,  1.00f );
	m_fSync[0][65] = FLOATKEY( 23.66f,  0.00f );
	m_fSync[0][66] = FLOATKEY( 24.83f,  0.00f );
	m_fSync[0][67] = FLOATKEY( 25.03f,  1.00f );
	m_fSync[0][68] = FLOATKEY( 25.16f,  0.00f );
	m_fSync[0][69] = FLOATKEY( 25.30f,  1.00f );
	m_fSync[0][70] = FLOATKEY( 25.50f,  0.00f );
	m_fSync[0][71] = FLOATKEY( 25.58f,  0.00f );
	m_fSync[0][72] = FLOATKEY( 25.78f,  1.00f );
	m_fSync[0][73] = FLOATKEY( 25.98f,  0.00f );
	m_fSync[0][74] = FLOATKEY( 28.01f,  0.00f );
	m_fSync[0][75] = FLOATKEY( 28.21f,  1.00f );
	m_fSync[0][76] = FLOATKEY( 28.33f,  0.00f );
	m_fSync[0][77] = FLOATKEY( 28.44f,  1.00f );
	m_fSync[0][78] = FLOATKEY( 28.64f,  0.00f );
	m_fSync[0][79] = FLOATKEY( 29.59f,  0.00f );
	m_fSync[0][80] = FLOATKEY( 29.79f,  1.00f );
	m_fSync[0][81] = FLOATKEY( 29.99f,  0.00f );


	InitFloatSpline( 82, m_fSync[0] );

	m_fSync[1][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[1][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[1][ 2] = FLOATKEY(  3.02f,  0.00f );
	m_fSync[1][ 3] = FLOATKEY(  3.22f,  1.00f );
	m_fSync[1][ 4] = FLOATKEY(  3.42f,  0.00f );
	m_fSync[1][ 5] = FLOATKEY(  4.60f,  0.00f );
	m_fSync[1][ 6] = FLOATKEY(  4.80f,  1.00f );
	m_fSync[1][ 7] = FLOATKEY(  5.00f,  0.00f );
	m_fSync[1][ 8] = FLOATKEY(  8.66f,  0.00f );
	m_fSync[1][ 9] = FLOATKEY(  8.86f,  1.00f );
	m_fSync[1][10] = FLOATKEY(  8.96f,  0.00f );
	m_fSync[1][11] = FLOATKEY(  9.06f,  1.00f );
	m_fSync[1][12] = FLOATKEY(  9.26f,  0.00f );
	m_fSync[1][13] = FLOATKEY(  9.29f,  0.00f );
	m_fSync[1][14] = FLOATKEY(  9.49f,  1.00f );
	m_fSync[1][15] = FLOATKEY(  9.69f,  0.00f );
	m_fSync[1][16] = FLOATKEY( 13.59f,  0.00f );
	m_fSync[1][17] = FLOATKEY( 13.78f,  1.00f );
	m_fSync[1][18] = FLOATKEY( 13.98f,  0.00f );
	m_fSync[1][19] = FLOATKEY( 18.90f,  0.00f );
	m_fSync[1][20] = FLOATKEY( 19.10f,  1.00f );
	m_fSync[1][21] = FLOATKEY( 19.30f,  0.00f );
	m_fSync[1][22] = FLOATKEY( 19.68f,  0.00f );
	m_fSync[1][23] = FLOATKEY( 19.88f,  1.00f );
	m_fSync[1][24] = FLOATKEY( 20.08f,  0.00f );
	m_fSync[1][25] = FLOATKEY( 21.37f,  0.00f );
	m_fSync[1][26] = FLOATKEY( 21.57f,  1.00f );
	m_fSync[1][27] = FLOATKEY( 21.77f,  0.00f );
	m_fSync[1][28] = FLOATKEY( 21.88f,  0.00f );
	m_fSync[1][29] = FLOATKEY( 22.08f,  1.00f );
	m_fSync[1][30] = FLOATKEY( 22.28f,  0.00f );
	m_fSync[1][31] = FLOATKEY( 22.38f,  0.00f );
	m_fSync[1][32] = FLOATKEY( 22.58f,  1.00f );
	m_fSync[1][33] = FLOATKEY( 22.78f,  0.00f );
	m_fSync[1][34] = FLOATKEY( 26.69f,  0.00f );
	m_fSync[1][35] = FLOATKEY( 26.89f,  1.00f );
	m_fSync[1][36] = FLOATKEY( 26.99f,  0.00f );
	m_fSync[1][37] = FLOATKEY( 27.10f,  1.00f );
	m_fSync[1][38] = FLOATKEY( 27.30f,  0.00f );
	m_fSync[1][39] = FLOATKEY( 28.67f,  0.00f );
	m_fSync[1][40] = FLOATKEY( 28.88f,  1.00f );
	m_fSync[1][41] = FLOATKEY( 29.01f,  0.00f );
	m_fSync[1][42] = FLOATKEY( 29.14f,  1.00f );
	m_fSync[1][43] = FLOATKEY( 29.31f,  0.00f );
	m_fSync[1][44] = FLOATKEY( 29.47f,  1.00f );
	m_fSync[1][45] = FLOATKEY( 29.63f,  0.00f );
	m_fSync[1][46] = FLOATKEY( 29.79f,  1.00f );
	m_fSync[1][47] = FLOATKEY( 29.99f,  0.00f );


	InitFloatSpline( 48, m_fSync[1] );

	m_fSync[2][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[2][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[2][ 2] = FLOATKEY(  0.30f,  0.00f );
	m_fSync[2][ 3] = FLOATKEY(  0.50f,  1.00f );
	m_fSync[2][ 4] = FLOATKEY(  0.70f,  0.00f );
	m_fSync[2][ 5] = FLOATKEY(  1.04f,  0.00f );
	m_fSync[2][ 6] = FLOATKEY(  1.24f,  1.00f );
	m_fSync[2][ 7] = FLOATKEY(  1.44f,  0.00f );
	m_fSync[2][ 8] = FLOATKEY(  6.41f,  0.00f );
	m_fSync[2][ 9] = FLOATKEY(  6.61f,  1.00f );
	m_fSync[2][10] = FLOATKEY(  6.81f,  0.00f );
	m_fSync[2][11] = FLOATKEY(  8.20f,  0.00f );
	m_fSync[2][12] = FLOATKEY(  8.40f,  1.00f );
	m_fSync[2][13] = FLOATKEY(  8.60f,  0.00f );
	m_fSync[2][14] = FLOATKEY( 12.19f,  0.00f );
	m_fSync[2][15] = FLOATKEY( 12.39f,  1.00f );
	m_fSync[2][16] = FLOATKEY( 12.59f,  0.00f );
	m_fSync[2][17] = FLOATKEY( 14.49f,  0.00f );
	m_fSync[2][18] = FLOATKEY( 14.69f,  1.00f );
	m_fSync[2][19] = FLOATKEY( 14.89f,  0.00f );
	m_fSync[2][20] = FLOATKEY( 15.21f,  0.00f );
	m_fSync[2][21] = FLOATKEY( 15.41f,  1.00f );
	m_fSync[2][22] = FLOATKEY( 15.61f,  0.00f );
	m_fSync[2][23] = FLOATKEY( 15.74f,  0.00f );
	m_fSync[2][24] = FLOATKEY( 15.94f,  1.00f );
	m_fSync[2][25] = FLOATKEY( 16.14f,  0.00f );
	m_fSync[2][26] = FLOATKEY( 17.21f,  0.00f );
	m_fSync[2][27] = FLOATKEY( 17.41f,  1.00f );
	m_fSync[2][28] = FLOATKEY( 17.61f,  0.00f );
	m_fSync[2][29] = FLOATKEY( 18.34f,  0.00f );
	m_fSync[2][30] = FLOATKEY( 18.54f,  1.00f );
	m_fSync[2][31] = FLOATKEY( 18.74f,  0.00f );
	m_fSync[2][32] = FLOATKEY( 20.14f,  0.00f );
	m_fSync[2][33] = FLOATKEY( 20.34f,  1.00f );
	m_fSync[2][34] = FLOATKEY( 20.54f,  0.00f );
	m_fSync[2][35] = FLOATKEY( 20.99f,  0.00f );
	m_fSync[2][36] = FLOATKEY( 21.19f,  1.00f );
	m_fSync[2][37] = FLOATKEY( 21.39f,  0.00f );
	m_fSync[2][38] = FLOATKEY( 23.75f,  0.00f );
	m_fSync[2][39] = FLOATKEY( 23.95f,  1.00f );
	m_fSync[2][40] = FLOATKEY( 24.07f,  0.00f );
	m_fSync[2][41] = FLOATKEY( 24.19f,  1.00f );
	m_fSync[2][42] = FLOATKEY( 24.39f,  0.00f );
	m_fSync[2][43] = FLOATKEY( 24.45f,  0.00f );
	m_fSync[2][44] = FLOATKEY( 24.65f,  1.00f );
	m_fSync[2][45] = FLOATKEY( 24.85f,  0.00f );
	m_fSync[2][46] = FLOATKEY( 26.24f,  0.00f );
	m_fSync[2][47] = FLOATKEY( 26.44f,  1.00f );
	m_fSync[2][48] = FLOATKEY( 26.64f,  0.00f );
	m_fSync[2][49] = FLOATKEY( 27.38f,  0.00f );
	m_fSync[2][50] = FLOATKEY( 27.58f,  1.00f );
	m_fSync[2][51] = FLOATKEY( 27.78f,  0.00f );


	InitFloatSpline( 52, m_fSync[2] );

	m_fSync[3][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[3][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[3][ 2] = FLOATKEY(  0.56f,  0.00f );
	m_fSync[3][ 3] = FLOATKEY(  0.76f,  1.00f );
	m_fSync[3][ 4] = FLOATKEY(  0.86f,  0.00f );
	m_fSync[3][ 5] = FLOATKEY(  0.96f,  1.00f );
	m_fSync[3][ 6] = FLOATKEY(  1.16f,  0.00f );
	m_fSync[3][ 7] = FLOATKEY(  2.58f,  0.00f );
	m_fSync[3][ 8] = FLOATKEY(  2.78f,  1.00f );
	m_fSync[3][ 9] = FLOATKEY(  2.86f,  0.00f );
	m_fSync[3][10] = FLOATKEY(  2.93f,  1.00f );
	m_fSync[3][11] = FLOATKEY(  3.13f,  0.00f );
	m_fSync[3][12] = FLOATKEY(  4.40f,  0.00f );
	m_fSync[3][13] = FLOATKEY(  4.60f,  1.00f );
	m_fSync[3][14] = FLOATKEY(  4.80f,  0.00f );
	m_fSync[3][15] = FLOATKEY(  4.83f,  0.00f );
	m_fSync[3][16] = FLOATKEY(  5.03f,  1.00f );
	m_fSync[3][17] = FLOATKEY(  5.23f,  0.00f );
	m_fSync[3][18] = FLOATKEY(  6.59f,  0.00f );
	m_fSync[3][19] = FLOATKEY(  6.79f,  1.00f );
	m_fSync[3][20] = FLOATKEY(  6.99f,  0.00f );
	m_fSync[3][21] = FLOATKEY(  8.41f,  0.00f );
	m_fSync[3][22] = FLOATKEY(  8.61f,  1.00f );
	m_fSync[3][23] = FLOATKEY(  8.81f,  0.00f );
	m_fSync[3][24] = FLOATKEY(  9.54f,  0.00f );
	m_fSync[3][25] = FLOATKEY(  9.74f,  1.00f );
	m_fSync[3][26] = FLOATKEY(  9.84f,  0.00f );
	m_fSync[3][27] = FLOATKEY(  9.94f,  1.00f );
	m_fSync[3][28] = FLOATKEY( 10.14f,  0.00f );
	m_fSync[3][29] = FLOATKEY( 14.05f,  0.00f );
	m_fSync[3][30] = FLOATKEY( 14.25f,  1.00f );
	m_fSync[3][31] = FLOATKEY( 14.36f,  0.00f );
	m_fSync[3][32] = FLOATKEY( 14.48f,  1.00f );
	m_fSync[3][33] = FLOATKEY( 14.68f,  0.00f );
	m_fSync[3][34] = FLOATKEY( 14.71f,  0.00f );
	m_fSync[3][35] = FLOATKEY( 14.91f,  1.00f );
	m_fSync[3][36] = FLOATKEY( 15.04f,  0.00f );
	m_fSync[3][37] = FLOATKEY( 15.18f,  1.00f );
	m_fSync[3][38] = FLOATKEY( 15.38f,  0.00f );
	m_fSync[3][39] = FLOATKEY( 15.44f,  0.00f );
	m_fSync[3][40] = FLOATKEY( 15.64f,  1.00f );
	m_fSync[3][41] = FLOATKEY( 15.84f,  0.00f );
	m_fSync[3][42] = FLOATKEY( 17.44f,  0.00f );
	m_fSync[3][43] = FLOATKEY( 17.64f,  1.00f );
	m_fSync[3][44] = FLOATKEY( 17.84f,  0.00f );
	m_fSync[3][45] = FLOATKEY( 18.80f,  0.00f );
	m_fSync[3][46] = FLOATKEY( 19.00f,  1.00f );
	m_fSync[3][47] = FLOATKEY( 19.10f,  0.00f );
	m_fSync[3][48] = FLOATKEY( 19.21f,  1.00f );
	m_fSync[3][49] = FLOATKEY( 19.41f,  0.00f );
	m_fSync[3][50] = FLOATKEY( 19.90f,  0.00f );
	m_fSync[3][51] = FLOATKEY( 20.10f,  1.00f );
	m_fSync[3][52] = FLOATKEY( 20.30f,  0.00f );
	m_fSync[3][53] = FLOATKEY( 21.24f,  0.00f );
	m_fSync[3][54] = FLOATKEY( 21.44f,  1.00f );
	m_fSync[3][55] = FLOATKEY( 21.57f,  0.00f );
	m_fSync[3][56] = FLOATKEY( 21.70f,  1.00f );
	m_fSync[3][57] = FLOATKEY( 21.81f,  0.00f );
	m_fSync[3][58] = FLOATKEY( 21.92f,  1.00f );
	m_fSync[3][59] = FLOATKEY( 22.12f,  0.00f );
	m_fSync[3][60] = FLOATKEY( 26.42f,  0.00f );
	m_fSync[3][61] = FLOATKEY( 26.62f,  1.00f );
	m_fSync[3][62] = FLOATKEY( 26.82f,  0.00f );
	m_fSync[3][63] = FLOATKEY( 27.12f,  0.00f );
	m_fSync[3][64] = FLOATKEY( 27.32f,  1.00f );
	m_fSync[3][65] = FLOATKEY( 27.52f,  0.00f );


	InitFloatSpline( 66, m_fSync[3] );

	m_fSync[4][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[4][ 1] = FLOATKEY(  0.20f,  0.00f );
	m_fSync[4][ 2] = FLOATKEY(  1.89f,  0.00f );
	m_fSync[4][ 3] = FLOATKEY(  2.09f,  1.00f );
	m_fSync[4][ 4] = FLOATKEY(  2.29f,  0.00f );
	m_fSync[4][ 5] = FLOATKEY(  3.69f,  0.00f );
	m_fSync[4][ 6] = FLOATKEY(  3.89f,  1.00f );
	m_fSync[4][ 7] = FLOATKEY(  4.09f,  0.00f );
	m_fSync[4][ 8] = FLOATKEY(  5.52f,  0.00f );
	m_fSync[4][ 9] = FLOATKEY(  5.72f,  1.00f );
	m_fSync[4][10] = FLOATKEY(  5.91f,  0.00f );
	m_fSync[4][11] = FLOATKEY(  7.04f,  0.00f );
	m_fSync[4][12] = FLOATKEY(  7.24f,  1.00f );
	m_fSync[4][13] = FLOATKEY(  7.36f,  0.00f );
	m_fSync[4][14] = FLOATKEY(  7.49f,  1.00f );
	m_fSync[4][15] = FLOATKEY(  7.69f,  0.00f );
	m_fSync[4][16] = FLOATKEY(  9.08f,  0.00f );
	m_fSync[4][17] = FLOATKEY(  9.28f,  1.00f );
	m_fSync[4][18] = FLOATKEY(  9.48f,  0.00f );
	m_fSync[4][19] = FLOATKEY( 11.81f,  0.00f );
	m_fSync[4][20] = FLOATKEY( 12.01f,  1.00f );
	m_fSync[4][21] = FLOATKEY( 12.21f,  0.00f );
	m_fSync[4][22] = FLOATKEY( 13.09f,  0.00f );
	m_fSync[4][23] = FLOATKEY( 13.29f,  1.00f );
	m_fSync[4][24] = FLOATKEY( 13.42f,  0.00f );
	m_fSync[4][25] = FLOATKEY( 13.54f,  1.00f );
	m_fSync[4][26] = FLOATKEY( 13.74f,  0.00f );
	m_fSync[4][27] = FLOATKEY( 15.84f,  0.00f );
	m_fSync[4][28] = FLOATKEY( 16.04f,  1.00f );
	m_fSync[4][29] = FLOATKEY( 16.14f,  0.00f );
	m_fSync[4][30] = FLOATKEY( 16.23f,  1.00f );
	m_fSync[4][31] = FLOATKEY( 16.43f,  0.00f );
	m_fSync[4][32] = FLOATKEY( 18.09f,  0.00f );
	m_fSync[4][33] = FLOATKEY( 18.29f,  1.00f );
	m_fSync[4][34] = FLOATKEY( 18.49f,  0.00f );
	m_fSync[4][35] = FLOATKEY( 19.45f,  0.00f );
	m_fSync[4][36] = FLOATKEY( 19.65f,  1.00f );
	m_fSync[4][37] = FLOATKEY( 19.85f,  0.00f );
	m_fSync[4][38] = FLOATKEY( 23.54f,  0.00f );
	m_fSync[4][39] = FLOATKEY( 23.74f,  1.00f );
	m_fSync[4][40] = FLOATKEY( 23.94f,  0.00f );
	m_fSync[4][41] = FLOATKEY( 24.20f,  0.00f );
	m_fSync[4][42] = FLOATKEY( 24.40f,  1.00f );
	m_fSync[4][43] = FLOATKEY( 24.60f,  0.00f );
	m_fSync[4][44] = FLOATKEY( 24.65f,  0.00f );
	m_fSync[4][45] = FLOATKEY( 24.85f,  1.00f );
	m_fSync[4][46] = FLOATKEY( 25.05f,  0.00f );
	m_fSync[4][47] = FLOATKEY( 25.73f,  0.00f );
	m_fSync[4][48] = FLOATKEY( 25.93f,  1.00f );
	m_fSync[4][49] = FLOATKEY( 26.04f,  0.00f );
	m_fSync[4][50] = FLOATKEY( 26.16f,  1.00f );
	m_fSync[4][51] = FLOATKEY( 26.36f,  0.00f );
	m_fSync[4][52] = FLOATKEY( 27.68f,  0.00f );
	m_fSync[4][53] = FLOATKEY( 27.88f,  1.00f );
	m_fSync[4][54] = FLOATKEY( 27.94f,  0.00f );
	m_fSync[4][55] = FLOATKEY( 28.01f,  1.00f );
	m_fSync[4][56] = FLOATKEY( 28.21f,  0.00f );


	InitFloatSpline( 57, m_fSync[4] );

	m_fSync[5][ 0] = FLOATKEY(  0.00f,  0.00f );
	m_fSync[5][ 1] = FLOATKEY(  0.03f,  0.00f );
	m_fSync[5][ 2] = FLOATKEY(  0.06f,  1.00f );
	m_fSync[5][ 3] = FLOATKEY(  0.17f,  0.00f );
	m_fSync[5][ 4] = FLOATKEY(  0.28f,  1.00f );
	m_fSync[5][ 5] = FLOATKEY(  0.48f,  0.00f );
	m_fSync[5][ 6] = FLOATKEY(  6.14f,  0.00f );
	m_fSync[5][ 7] = FLOATKEY(  6.34f,  1.00f );
	m_fSync[5][ 8] = FLOATKEY(  6.54f,  0.00f );
	m_fSync[5][ 9] = FLOATKEY(  7.99f,  0.00f );
	m_fSync[5][10] = FLOATKEY(  8.19f,  1.00f );
	m_fSync[5][11] = FLOATKEY(  8.39f,  0.00f );
	m_fSync[5][12] = FLOATKEY( 10.67f,  0.00f );
	m_fSync[5][13] = FLOATKEY( 10.87f,  1.00f );
	m_fSync[5][14] = FLOATKEY( 11.07f,  0.00f );
	m_fSync[5][15] = FLOATKEY( 11.13f,  0.00f );
	m_fSync[5][16] = FLOATKEY( 11.33f,  1.00f );
	m_fSync[5][17] = FLOATKEY( 11.53f,  0.00f );
	m_fSync[5][18] = FLOATKEY( 12.46f,  0.00f );
	m_fSync[5][19] = FLOATKEY( 12.66f,  1.00f );
	m_fSync[5][20] = FLOATKEY( 12.79f,  0.00f );
	m_fSync[5][21] = FLOATKEY( 12.92f,  1.00f );
	m_fSync[5][22] = FLOATKEY( 13.12f,  0.00f );
	m_fSync[5][23] = FLOATKEY( 16.51f,  0.00f );
	m_fSync[5][24] = FLOATKEY( 16.72f,  1.00f );
	m_fSync[5][25] = FLOATKEY( 16.92f,  0.00f );
	m_fSync[5][26] = FLOATKEY( 17.01f,  0.00f );
	m_fSync[5][27] = FLOATKEY( 17.21f,  1.00f );
	m_fSync[5][28] = FLOATKEY( 17.41f,  0.00f );
	m_fSync[5][29] = FLOATKEY( 20.79f,  0.00f );
	m_fSync[5][30] = FLOATKEY( 20.99f,  1.00f );
	m_fSync[5][31] = FLOATKEY( 21.19f,  0.00f );
	m_fSync[5][32] = FLOATKEY( 22.61f,  0.00f );
	m_fSync[5][33] = FLOATKEY( 22.81f,  1.00f );
	m_fSync[5][34] = FLOATKEY( 23.01f,  0.00f );
	m_fSync[5][35] = FLOATKEY( 25.36f,  0.00f );
	m_fSync[5][36] = FLOATKEY( 25.56f,  1.00f );
	m_fSync[5][37] = FLOATKEY( 25.76f,  0.00f );
	m_fSync[5][38] = FLOATKEY( 28.46f,  0.00f );
	m_fSync[5][39] = FLOATKEY( 28.66f,  1.00f );
	m_fSync[5][40] = FLOATKEY( 28.86f,  0.00f );
	m_fSync[5][41] = FLOATKEY( 29.14f,  0.00f );
	m_fSync[5][42] = FLOATKEY( 29.34f,  1.00f );
	m_fSync[5][43] = FLOATKEY( 29.54f,  0.00f );

	InitFloatSpline( 44, m_fSync[5] );

	m_dwKeyCount[0] = 82;
	m_dwKeyCount[1] = 48;
	m_dwKeyCount[2] = 52;
	m_dwKeyCount[3] = 66;
	m_dwKeyCount[4] = 57;
	m_dwKeyCount[5] = 44;

	m_fBassSync[0] = FLOATKEY( 0.00f, 0.0f );
	m_fBassSync[1] = FLOATKEY( 0.15f, 1.0f );
	m_fBassSync[2] = FLOATKEY( 0.30f, 0.6f );
	m_fBassSync[3] = FLOATKEY( 0.45f, 1.4f );
	m_fBassSync[4] = FLOATKEY( 0.60f, 0.6f );
	m_fBassSync[5] = FLOATKEY( 0.75f, 1.2f );
	m_fBassSync[6] = FLOATKEY( 0.90f, 0.8f );
	m_fBassSync[7] = FLOATKEY( 1.05f, 0.4f );
	m_fBassSync[8] = FLOATKEY( 1.20f, 0.6f );
	m_fBassSync[9] = FLOATKEY( 1.35f, 0.0f );

	InitFloatSpline( 10, m_fBassSync );
}

CAccelerator::~CAccelerator()
{	
	SAFE_RELEASE( m_pvbSphere );
	SAFE_RELEASE( m_pvbParticle );
	SAFE_RELEASE( m_pvbFxPlane );
	SAFE_RELEASE( m_pvbFxPod );
	SAFE_RELEASE( m_pvbFxPod2 );
	SAFE_RELEASE( m_pvbWireframe );
	SAFE_RELEASE( m_pvbBassPod );
	SAFE_RELEASE( m_pibSphere );
	SAFE_RELEASE( m_pibFxPlane );	

	SAFE_DELETE( m_piqFade );
	SAFE_DELETE( m_piqHole );

	SAFE_DELETE( m_ptrBass );
	SAFE_DELETE( m_ptrSphere );
}


//=============================================================================================================
//=============================================================================================================

BOOL CAccelerator::UpdateFrame( FLOAT fTime )
{
	//standard setup

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 25.0f, 0.75f, 50.0f, 500.0f ) );
	m_pDevice->SetTransform( D3DTS_VIEW, CameraMtx( he3d_CVector( 0, 0, -180 ), he3d_CVector( 0, 0, 0 ), 0 ) );

	D3DMATERIAL8			d3dmat;
	
	d3dmat.Ambient.r = 0.2f;
	d3dmat.Ambient.g = 0.2f;
	d3dmat.Ambient.b = 0.2f;
	d3dmat.Diffuse.r = 0.4f;
	d3dmat.Diffuse.g = 0.4f;
	d3dmat.Diffuse.b = 0.4f;
	d3dmat.Emissive.r = 0.1f;
	d3dmat.Emissive.g = 0.1f;
	d3dmat.Emissive.b = 0.1f;
	d3dmat.Specular.r = 1.0f;
	d3dmat.Specular.g = 1.0f;
	d3dmat.Specular.b = 1.0f;
	d3dmat.Power = 100.0f;

	m_pDevice->SetMaterial( &d3dmat );

	D3DLIGHT8				d3dlit;
	
	ZeroMemory( &d3dlit, sizeof(D3DLIGHT8) );

	d3dlit.Type = D3DLIGHT_POINT;	
	d3dlit.Attenuation0 = 1.0f;
	d3dlit.Range = LIGHT_RANGE_MAX;

	d3dlit.Position.x = -150;
	d3dlit.Position.y = 70;
	d3dlit.Position.z = -100;

	d3dlit.Specular.r = 1.0f;
	d3dlit.Specular.g = 1.0f;
	d3dlit.Specular.b = 1.0f;
	d3dlit.Diffuse.r = 1.0f;
	d3dlit.Diffuse.g = 1.0f;
	d3dlit.Diffuse.b = 1.0f;

	m_pDevice->SetLight( 0, &d3dlit );

	d3dlit.Position.x = 100;
	d3dlit.Position.y = -50;
	d3dlit.Position.z = -100;

	m_pDevice->SetLight( 1, &d3dlit );	

	m_fRotation = 0.25f*fTime;

	DWORD					dwFrame = (DWORD)(fTime*25.0f);

	m_ptexHoles = m_ptextCaust[dwFrame%32];

	m_psAccelerator.Update( fTime + 20.0f );

	FLOAT					fAlpha;

	if( fTime < 2.0f )
	{
		m_bRenderFade = TRUE;
		
		fAlpha = ( 2.0f - fTime )*128.0f;

		if( fAlpha > 255.0f )
			fAlpha = 255.0f;
		else if( fAlpha < 0.0f )
			fAlpha = 0.0f;		

		m_piqFade->SetAlpha( (DWORD)fAlpha );
	}
	else if( fTime > 23.25f )
	{
		m_bRenderFade = TRUE;
		
		fAlpha = ( fTime - 23.25f )*120.0f;

		if( fAlpha > 255.0f )
			fAlpha = 255.0f;
		else if( fAlpha < 0.0f )
			fAlpha = 0.0f;		

		m_piqFade->SetAlpha( (DWORD)fAlpha );
	}
	else
		m_bRenderFade = FALSE;

	// water procceeding

	LPINT					piOldWater = m_ppiWater[m_dwCurrentWaterPage];
	LPINT					piNewWater = m_ppiWater[m_dwCurrentWaterPage^1];

	INT						iWater;	

	for( DWORD i = 1, off = 51 ; i < 49 ; i++, off += 2 )
		for( DWORD j = 1 ; j < 49 ; j++, off++ )
		{
			iWater = ( ( piOldWater[off-51]+
						 piOldWater[off-50]+
						 piOldWater[off-49]+
						 piOldWater[off+1 ]+
						 piOldWater[off+51]+
						 piOldWater[off+50]+
						 piOldWater[off+49]+
						 piOldWater[off-1 ] ) >> 2 ) - piNewWater[off];

			piNewWater[off] = iWater - ( iWater >> 4 );
		}

	m_dwCurrentWaterPage ^= 1;

	PLVERTEX				pVertices;
	DWORD					dwColor;

	fAlpha = 0.75f + 0.25f*sinf( fTime );
	dwColor = (DWORD)(fAlpha*255.0f);
	dwColor = ( dwColor << 24 ) | 0x202020;

	m_pvbFxPlane->Lock( 0, 0, (LPBYTE*)&pVertices, 0 );

	for( i = 0 ; i < 50 ; i++ )
		for( DWORD j = 0 ; j < 50 ; j++ )
		{
			pVertices[i + j*50].m_vPos.z = 0.2f*(FLOAT)m_ppiWater[m_dwCurrentWaterPage][i + j*50];
			pVertices[i + j*50].m_dwColor = dwColor;
		}

	m_pvbFxPlane->Unlock();

	DWORD					x = 2 + rand()%47;
	DWORD					y = 2 + rand()%47;

	m_ppiWater[m_dwCurrentWaterPage][x + y*50]	+= 50;
	m_ppiWater[m_dwCurrentWaterPage][x + (y+1)*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x + (y-1)*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x + 1 + y*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x - 1 + y*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x + 1 + (y+1)*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x + 1 + (y-1)*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x - 1 + (y+1)*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x - 1 + (y+1)*50] += 30;
	m_ppiWater[m_dwCurrentWaterPage][x + (y+2)*50] += 10;
	m_ppiWater[m_dwCurrentWaterPage][x + (y-2)*50] += 10;
	m_ppiWater[m_dwCurrentWaterPage][x + 2 + y*50] += 10;
	m_ppiWater[m_dwCurrentWaterPage][x - 2 + y*50] += 10;

	// sync sphere

	PSIMPLEVERTEX			pVerts;
	FLOAT					fSync[6];

	for( i = 0 ; i < 6 ; i++ )
		fSync[i] = GetFloatSplineValue( fTime, m_dwKeyCount[i], m_fSync[i] );

	m_pvbSphere->Lock( 0, 0, (LPBYTE*)&pVerts, 0 );

	for( i = 0 ; i < 8*14 + 2 ; i++ )	
		*(pVerts++) = SIMPLEVERTEX( Polar2Cartesian3d( BASERADIUS + 10.0f*fSync[m_pdwSyncIndex[i]] + fSync[0]*5.0f, m_ppfSphere[i][0], m_ppfSphere[i][1] ), SPHERECOLOR );	
	
	m_pvbSphere->Unlock();

//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// render texture
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	m_pDevice->SetRenderState( D3DRS_ZENABLE, D3DZB_FALSE );
	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );	

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );	

	m_ptrSphere->SetTarget( m_pDevice );

	m_pDevice->Clear( 0, NULL, D3DCLEAR_TARGET, 0xffffff, 0.0f, 0 );

	m_pDevice->SetVertexShader( FVF_SIMPLEVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbSphere, sizeof(SIMPLEVERTEX) );
	m_pDevice->SetIndices( m_pibSphere, 0 );

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 25.0f, 1.0f, 50.0f, 500.0f ) );
	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 0.65f )*RotationMtx( -0.75f*m_fRotation, -0.5f*m_fRotation, 1.5f*m_fRotation ) );	

	m_pDevice->BeginScene();	

	m_pDevice->SetRenderState( D3DRS_POINTSPRITEENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_POINTSCALEENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_POINTSIZE, FLT2DWORD( 6.0f ) );	

	m_pDevice->SetTexture( 0, GetTexture( "pblue.jpg" ) );
	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2 );
	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );

	m_pDevice->DrawPrimitive( D3DPT_POINTLIST, 0, 14*8 + 2 );

	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
	m_pDevice->SetRenderState( D3DRS_POINTSPRITEENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_POINTSCALEENABLE, FALSE );

	m_pDevice->SetTexture( 0, NULL );
	m_pDevice->DrawIndexedPrimitive( D3DPT_LINELIST, 0, 14*8 + 2, 0, 16*8 + 7*16 );

	m_pDevice->EndScene();

	m_ptrSphere->RestoreTarget( m_pDevice );

	//restore projection	

	//bass feedback!!!!!

	m_bRenderBass = FALSE;
	
	D3DVIEWPORT8			d3dvp;

	m_pDevice->GetViewport( &d3dvp );	

	if( fTime >= 0.5f && fTime <= 2.0f )
	{
		m_bRenderBass = TRUE;

		fAlpha = GetFloatSplineValue( fTime - 0.5f, 10, m_fBassSync );
		ApplyFeedback( m_pvbBassPod, (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, fAlpha );		
	}

	if( fTime >= 4.0f && fTime <= 5.5f )
	{
		m_bRenderBass = TRUE;

		fAlpha = GetFloatSplineValue( fTime - 4.0f, 10, m_fBassSync );
		ApplyFeedback( m_pvbBassPod, (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, fAlpha );				
	}

	if( fTime >= 7.5f && fTime <= 9.0f )
	{
		m_bRenderBass = TRUE;

		fAlpha = GetFloatSplineValue( fTime - 7.5f, 10, m_fBassSync );
		ApplyFeedback( m_pvbBassPod, (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, fAlpha );				
	}

	if( fTime >= 11.0f && fTime <= 12.5f )
	{
		m_bRenderBass = TRUE;

		fAlpha = GetFloatSplineValue( fTime - 11.0f, 10, m_fBassSync );
		ApplyFeedback( m_pvbBassPod, (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, fAlpha );			
	}

	if( fTime >= 14.5f && fTime <= 16.0f )
	{
		m_bRenderBass = TRUE;

		fAlpha = GetFloatSplineValue( fTime - 14.5f, 10, m_fBassSync );
		ApplyFeedback( m_pvbBassPod, (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, fAlpha );				
	}

	if( fTime >= 18.0f && fTime <= 19.5f )
	{
		m_bRenderBass = TRUE;

		fAlpha = GetFloatSplineValue( fTime - 18.0f, 10, m_fBassSync );
		ApplyFeedback( m_pvbBassPod, (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, fAlpha );				
	}

	if( fTime >= 21.5f && fTime <= 23.0f )
	{
		m_bRenderBass = TRUE;

		fAlpha = GetFloatSplineValue( fTime - 21.5f, 10, m_fBassSync );
		ApplyFeedback( m_pvbBassPod, (FLOAT)d3dvp.Width, (FLOAT)d3dvp.Height, fAlpha );				
	}	

	if( m_bRenderBass )
		m_piqHole->Resize( -40.0f, 106.66f, 320.0f, 586.66f );
	else
		m_piqHole->Resize( -50.0f, 100.0f, 400.0f, 550.0f );


	return TRUE;
}

BOOL CAccelerator::RenderEfx()
{	
	if( m_bRenderBass )
	{
		m_pDevice->Clear( 0, NULL, D3DCLEAR_TARGET, 0x0, 1.0f, 0 );
		m_ptrBass->SetTarget( m_pDevice );
		m_pDevice->Clear( 0, NULL, D3DCLEAR_TARGET, 0xffffff, 1.0f, 0 );		
	}
	else
		m_pDevice->Clear( 0, NULL, D3DCLEAR_TARGET, 0xffffff, 1.0f, 0 );

	m_pDevice->BeginScene();

	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	m_pDevice->SetRenderState( D3DRS_ZENABLE, D3DZB_FALSE );
	m_pDevice->SetRenderState( D3DRS_ZWRITEENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );	

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );	

	m_pDevice->SetTexture( 0, GetTexture( "fxtexture.bmp" ) );	

	m_pDevice->SetVertexShader( FVF_LVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbFxPod, sizeof(LVERTEX) );

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 25.0f, 0.35f, 50.0f, 500.0f ) );

	m_pDevice->SetTransform( D3DTS_WORLD, RotationMtx( 0.0f, m_fRotation + H_PI*0.0f, m_fRotation*1.0f )*TranslationMtx( 10, 20, 200 ) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

	m_pDevice->SetTransform( D3DTS_WORLD, RotationMtx( 0.0f, m_fRotation + H_PI*0.2f, m_fRotation*0.8f )*TranslationMtx( 10, 20, 200 ) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

	m_pDevice->SetTransform( D3DTS_WORLD, RotationMtx( 0.0f, m_fRotation + H_PI*0.4f, m_fRotation*0.6f )*TranslationMtx( 10, 20, 200 ) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

	m_pDevice->SetTransform( D3DTS_WORLD, RotationMtx( 0.0f, m_fRotation + H_PI*0.6f, m_fRotation*0.4f )*TranslationMtx( 10, 20, 200 ) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

	m_pDevice->SetTransform( D3DTS_WORLD, RotationMtx( 0.0f, m_fRotation + H_PI*0.8f, m_fRotation*0.2f )*TranslationMtx( 10, 20, 200 ) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );	

	m_pDevice->SetTexture( 0, GetTexture( "stain.bmp" ) );

	m_pDevice->SetTexture( 1, m_ptrSphere->GetTargetTexture() );
	m_pDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, 0 );
	m_pDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );

	m_piqHole->Render( m_pDevice );

	m_pDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, 1|D3DTSS_TCI_PASSTHRU );
	m_pDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );	

	m_pDevice->SetTexture( 1, NULL );	
			
	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 25.0f, 0.75f, 50.0f, 500.0f ) );

	//===================================

	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_FLAT );
	
	m_pDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );	
	
	m_pDevice->LightEnable( 0, TRUE );
	m_pDevice->LightEnable( 1, TRUE );

	m_pDevice->SetTexture( 0, m_ptexHoles );
	
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_CAMERASPACENORMAL );
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );	
		
	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, TRUE );	

	m_pDevice->SetTransform( D3DTS_TEXTURE0, RotationMtx( -m_fRotation, -0.75f*m_fRotation, 0.5f*m_fRotation )*ScaleMtx( 0.5f )*TranslationMtx( 0.5f, 0.5f, 0.5f ) );
	m_pDevice->SetTransform( D3DTS_WORLD, RotationMtx( 1.85f*m_fRotation, 1.25f*m_fRotation, -1.75f*m_fRotation )*TranslationMtx( -5, 2, 0 ) );

	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_CW );
	m_smAccelerator.Render( m_pDevice );	

	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE );

	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_GOURAUD );

	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );

	///=======================================================

	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );	

	m_psAccelerator.Render( m_pDevice );	

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );	

	m_pDevice->LightEnable( 0, FALSE );
	m_pDevice->LightEnable( 1, FALSE );
	
	m_pDevice->SetTexture( 0, NULL );

	m_pDevice->SetVertexShader( FVF_SIMPLEVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbWireframe, sizeof(SIMPLEVERTEX) );	

	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 0.99f )*RotationMtx( 1.85f*m_fRotation, 1.25f*m_fRotation, -1.75f*m_fRotation )*TranslationMtx( -5, 2, 0 ) );

	m_pDevice->DrawPrimitive( D3DPT_LINELIST, 0, 3*m_smAccelerator.GetFacesCount() );

	//=====================================================================


	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_FLAT );
	m_pDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );	
	
	m_pDevice->LightEnable( 0, TRUE );
	m_pDevice->LightEnable( 1, TRUE );

	m_pDevice->SetTexture( 0, m_ptexHoles );
	
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_CAMERASPACENORMAL );
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );	
		
	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, TRUE );	

	m_pDevice->SetTransform( D3DTS_TEXTURE0, RotationMtx( -m_fRotation, -0.75f*m_fRotation, 0.5f*m_fRotation )*ScaleMtx( 0.5f )*TranslationMtx( 0.5f, 0.5f, 0.5f ) );
	m_pDevice->SetTransform( D3DTS_WORLD, RotationMtx( 1.85f*m_fRotation, 1.25f*m_fRotation, -1.75f*m_fRotation )*TranslationMtx( -5, 2, 0 ) );

	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_CCW );
	m_smAccelerator.Render( m_pDevice );

	m_pDevice->SetRenderState( D3DRS_SHADEMODE, D3DSHADE_GOURAUD );

	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE );

	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );
	m_pDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
	
	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );	

	m_pDevice->SetTexture( 0, GetTexture( "alpha.bmp" ) );
	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG2 );
	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE2X );

	m_pDevice->SetTransform( D3DTS_WORLD, IdentMtx() );	

	m_pDevice->SetVertexShader( FVF_LVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbFxPlane, sizeof(LVERTEX) );
	m_pDevice->SetIndices( m_pibFxPlane, 0 );
	m_pDevice->DrawIndexedPrimitive( D3DPT_LINELIST, 0, 2500, 0, 2450 );

	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
	m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );

	m_pDevice->EndScene();

	if( m_bRenderBass )
	{		
		m_ptrBass->RestoreTarget( m_pDevice );

		m_pDevice->BeginScene();

		m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
		m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
		m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
		m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );	
		m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );

		m_pDevice->SetTexture( 0, m_ptrBass->GetTargetTexture() );
		m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
		m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2 );

		m_pDevice->SetVertexShader( FVF_TLVERTEX );
		m_pDevice->SetStreamSource( 0, m_pvbBassPod, sizeof(TLVERTEX) );
		m_pDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 4*2 );

		m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
		m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );

		m_pDevice->EndScene();
	}

	if( m_bRenderFade )
	{
		m_pDevice->BeginScene();

		m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
		m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
		m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
		m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );	

		m_pDevice->SetTexture( 0, NULL );

		m_piqFade->Render( m_pDevice );

		m_pDevice->EndScene();
	}

	return TRUE;
}
