// Pit.cpp: implementation of the CPit class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Pit.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPit::CPit( PDIRECT3DDEVICE8 pDevice ) : CEfx( pDevice )
{
	try
	{
		LoadTexture( "pit.bmp" );
	}
	catch( CTextureException )
	{
		throw CSystemException( "unable to load textures" );
	}

	if( !m_smPit.Load( m_pDevice, "data\\objects\\pit_base.smf" ) )
		throw CSystemException( "unable to load pit_base.smf" );

	if( FAILED( m_pDevice->CreateVertexBuffer( 6*4*sizeof(SIMPLEVERTEX), 0, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbInnerVolume ) ) )
		throw CSystemException( "unable to create inner volume vertex buffer" );

	if( FAILED( m_pDevice->CreateVertexBuffer( 6*50*sizeof(SIMPLEVERTEX), 0, FVF_SIMPLEVERTEX, D3DPOOL_DEFAULT, &m_pvbVolume ) ) )
		throw CSystemException( "unable to create volume vertex buffer" );

	he3d_CVector			vShiluette[50];

	vShiluette[0] = he3d_CVector( 2.0f*sinf( -H_PI/10.0f ), 0.0f, 2.0f*cosf( -H_PI/10.0f ) );
	vShiluette[1] = he3d_CVector( 5.0f*sinf( -H_PI/10.0f ), 0.0f, 5.0f*cosf( -H_PI/10.0f ) );
	vShiluette[2] = he3d_CVector( 5.0f*sinf(  H_PI/10.0f ), 0.0f, 5.0f*cosf(  H_PI/10.0f ) );
	vShiluette[3] = he3d_CVector( 2.0f*sinf(  H_PI/10.0f ), 0.0f, 2.0f*cosf(  H_PI/10.0f ) );

	PSIMPLEVERTEX			pV;

	m_pvbInnerVolume->Lock( 0, 0, (LPBYTE*)&pV, 0 );
	
	CreateVolumeFromShiluetteStrip( 4, vShiluette, he3d_CVector( 0, -100, 0 ), sizeof(SIMPLEVERTEX), (LPBYTE)pV );

	for( DWORD i = 0 ; i < 24 ; i++ )
		pV[i].m_dwColor = 0x10ffffff;

	m_pvbInnerVolume->Unlock();

	for( i = 0 ; i < 50 ; i++ )
		vShiluette[i] = he3d_CVector( 7.0f*cosf( (FLOAT)i*H_2PI/50.0f ), 0.0f, 7.0f*sinf( (FLOAT)i*H_2PI/50.0f ) );

	m_pvbVolume->Lock( 0, 0, (LPBYTE*)&pV, 0 );
	
	CreateVolumeFromShiluetteStrip( 50, vShiluette, he3d_CVector( 0, -100, 0 ), sizeof(SIMPLEVERTEX), (LPBYTE)pV );

	for( i = 0 ; i < 300 ; i++ )
		pV[i].m_dwColor = 0x10ffffff;

	m_pvbVolume->Unlock();

}

CPit::~CPit()
{
}

BOOL CPit::UpdateFrame( FLOAT fTime )
{
	// standard setup

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 72.0f, 0.75f, 0.1f, 100.0f ) );
	m_pDevice->SetTransform( D3DTS_VIEW, CameraMtx( he3d_CVector( 0, 30, -6.5 ), he3d_CVector( 0, 3, 0 ), 0 )  );

	D3DMATERIAL8			d3dmat;
	
	d3dmat.Ambient.r = 0.2f;
	d3dmat.Ambient.g = 0.2f;
	d3dmat.Ambient.b = 0.2f;
	d3dmat.Diffuse.r = 0.4f;
	d3dmat.Diffuse.g = 0.4f;
	d3dmat.Diffuse.b = 0.4f;
	d3dmat.Emissive.r = 0.1f;
	d3dmat.Emissive.g = 0.1f;
	d3dmat.Emissive.b = 0.1f;
	d3dmat.Specular.r = 1.0f;
	d3dmat.Specular.g = 1.0f;
	d3dmat.Specular.b = 1.0f;
	d3dmat.Power = 100.0f;

	m_pDevice->SetMaterial( &d3dmat );

	D3DLIGHT8				d3dlit;
	
	ZeroMemory( &d3dlit, sizeof(D3DLIGHT8) );

	d3dlit.Type = D3DLIGHT_POINT;	
	d3dlit.Attenuation0 = 1.0f;
	d3dlit.Range = LIGHT_RANGE_MAX;

	d3dlit.Position.x = -150;
	d3dlit.Position.y = 70;
	d3dlit.Position.z = -100;

	d3dlit.Specular.r = 1.0f;
	d3dlit.Specular.g = 1.0f;
	d3dlit.Specular.b = 1.0f;
	d3dlit.Diffuse.r = 1.0f;
	d3dlit.Diffuse.g = 1.0f;
	d3dlit.Diffuse.b = 1.0f;

	m_pDevice->SetLight( 0, &d3dlit );

	d3dlit.Position.x = 100;
	d3dlit.Position.y = -50;
	d3dlit.Position.z = -100;

	m_pDevice->SetLight( 1, &d3dlit );	

	m_fRotation = 0.25f*fTime;

	return TRUE;
}

BOOL CPit::RenderEfx()
{
	m_pDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xffffff, 1.0f, 0 );

	m_pDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	m_pDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );
	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_NORMALIZENORMALS, TRUE );
	m_pDevice->SetRenderState( D3DRS_WRAP0, D3DWRAP_U|D3DWRAP_V );

	m_pDevice->LightEnable( 0, TRUE );
	m_pDevice->LightEnable( 1, TRUE );		

	m_pDevice->SetTransform( D3DTS_WORLD, ScaleMtx( 6.0f, 3.0f, 6.0f ) );
	m_pDevice->SetTexture( 0, GetTexture( "tunnel.jpg" ) );
	
	m_smPit.Render( m_pDevice );	

	m_pDevice->SetTexture( 0, NULL );

	m_pDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
	m_pDevice->SetRenderState( D3DRS_ZENABLE, FALSE );	
	m_pDevice->SetRenderState( D3DRS_SPECULARENABLE, FALSE );
	m_pDevice->SetRenderState( D3DRS_NORMALIZENORMALS, FALSE );

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
	m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
	m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

	m_pDevice->SetTransform( D3DTS_WORLD, IdentMtx() );	

	m_pDevice->SetVertexShader( FVF_SIMPLEVERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbInnerVolume, sizeof(SIMPLEVERTEX) );

	for( DWORD i = 0 ; i < 6 ; i++ )
	{	
		m_pDevice->SetTransform( D3DTS_WORLD, YRotationMtx( (FLOAT)i*H_PI*0.333f + m_fRotation ) );
		m_pDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 8 );
	}

	m_pDevice->SetStreamSource( 0, m_pvbVolume, sizeof(SIMPLEVERTEX) );
	m_pDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 100 );

	m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

	return TRUE;
}
