// TitleSequence.cpp: implementation of the CTitleSequence class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TitleSequence.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#define	TITLE_INTRO		1
#define	TITLE_BLUR		2
#define	TITLE_NORMAL	3
#define	TITLE_EFX		4

CTitleSequence::CTitleSequence( PDIRECT3DDEVICE8 pDevice ) : CEfx( pDevice ), m_pvbCube( NULL )
{
	
	try
	{
		LoadAlphaTexture( "title.bmp" );		
		LoadAlphaTexture( "title2.bmp" );
		LoadAlphaTexture( "subtitle.bmp" );		
		LoadAlphaTexture( "back.bmp" );
	}
	catch( CTextureException )
	{		
		throw CSystemException( "unable to load textures" );
	}

	if( !CreateUnlitCube( m_pDevice, 1.0f, &m_pvbCube ) )	
		throw CSystemException( "unable to create cube vertex buffer" );	

	DWORD					i;

	for( i = 0 ; i < CUBESCOUNT ; i++ )
	{
		m_pvPosition[i] = he3d_CVector( 4.0f*SIGNEDRAND(), 3.5f*SIGNEDRAND(), 100.0f );

		FLOAT				fScale = 0.5f + 1.0f*RAND();

		m_pvScale[i] = he3d_CVector( fScale, fScale, 0.0f );		
	}	

	for( i = 0 ; i < 10 ; i++ )
	{
		m_piqSubTitle[i] = NULL;
		m_piqTitle[i] = NULL;
	}

	for( i = 0 ; i < 10 ; i++ )
	{
		m_piqSubTitle[i] = new CImageQuad( m_pDevice, 0, 0, 1, 1 );
		m_piqTitle[i] = new CImageQuad( m_pDevice );

		m_piqTitle[i]->SetColor( 0x0 );
		m_piqSubTitle[i]->SetColor( 0x0 );
	}

	// sync spline initialization

	m_fSpline[0][ 0] = FLOATKEY(  0.00f,  0.0f );
	m_fSpline[0][ 1] = FLOATKEY(  5.50f,  0.0f );
	m_fSpline[0][ 2] = FLOATKEY(  5.72f, 25.0f );
	m_fSpline[0][ 3] = FLOATKEY(  5.82f,  0.0f );
	m_fSpline[0][ 4] = FLOATKEY(  5.94f, 15.0f );
	m_fSpline[0][ 5] = FLOATKEY(  6.02f,  0.0f );
	m_fSpline[0][ 6] = FLOATKEY(  6.12f, 20.0f );
	m_fSpline[0][ 7] = FLOATKEY(  6.20f,  0.0f );
	m_fSpline[0][ 8] = FLOATKEY(  6.30f, 15.0f );
	m_fSpline[0][ 9] = FLOATKEY(  6.40f,  0.0f );
	m_fSpline[0][10] = FLOATKEY(  7.35f,  0.0f );
	m_fSpline[0][11] = FLOATKEY(  7.47f, 20.0f );
	m_fSpline[0][12] = FLOATKEY(  7.65f,  0.0f );
	m_fSpline[0][13] = FLOATKEY(  9.00f,  0.0f );
	m_fSpline[0][14] = FLOATKEY(  9.20f, 30.0f );
	m_fSpline[0][15] = FLOATKEY(  9.40f,  0.0f );
	m_fSpline[0][16] = FLOATKEY( 10.80f,  0.0f );
	m_fSpline[0][17] = FLOATKEY( 11.00f, 30.0f );
	m_fSpline[0][18] = FLOATKEY( 11.20f,  0.0f );
	m_fSpline[0][19] = FLOATKEY( 12.60f,  0.0f );
	m_fSpline[0][20] = FLOATKEY( 12.75f, 20.0f );
	m_fSpline[0][21] = FLOATKEY( 12.95f,  0.0f );
	m_fSpline[0][22] = FLOATKEY( 14.30f,  0.0f );
	m_fSpline[0][23] = FLOATKEY( 14.50f, 30.0f );
	m_fSpline[0][24] = FLOATKEY( 14.62f, 10.0f );
	m_fSpline[0][25] = FLOATKEY( 14.77f, 25.0f );
	m_fSpline[0][26] = FLOATKEY( 14.87f,  0.0f );
	m_fSpline[0][27] = FLOATKEY( 14.95f, 15.0f );
	m_fSpline[0][28] = FLOATKEY( 15.15f,  0.0f );
	m_fSpline[0][29] = FLOATKEY( 16.30f,  0.0f );
	m_fSpline[0][30] = FLOATKEY( 16.43f, 20.0f );
	m_fSpline[0][31] = FLOATKEY( 16.55f,  0.0f );
	m_fSpline[0][32] = FLOATKEY( 16.66f, 15.0f );
	m_fSpline[0][33] = FLOATKEY( 16.73f,  0.0f );
	m_fSpline[0][34] = FLOATKEY( 16.83f, 20.0f );
	m_fSpline[0][35] = FLOATKEY( 17.00f,  0.0f );
	m_fSpline[0][36] = FLOATKEY( 18.05f,  0.0f );
	m_fSpline[0][37] = FLOATKEY( 18.23f, 30.0f );
	m_fSpline[0][38] = FLOATKEY( 18.35f,  0.0f );
	m_fSpline[0][39] = FLOATKEY( 18.45f, 20.0f );
	m_fSpline[0][40] = FLOATKEY( 18.57f,  0.0f );
	m_fSpline[0][41] = FLOATKEY( 18.66f, 25.0f );
	m_fSpline[0][42] = FLOATKEY( 18.88f,  0.0f );
	m_fSpline[0][43] = FLOATKEY( 19.86f,  0.0f );
	m_fSpline[0][44] = FLOATKEY( 20.00f, 20.0f );
	m_fSpline[0][45] = FLOATKEY( 20.20f,  0.0f );
	m_fSpline[0][46] = FLOATKEY( 21.45f,  0.0f );
	m_fSpline[0][47] = FLOATKEY( 21.63f, 25.0f );
	m_fSpline[0][48] = FLOATKEY( 21.80f,  0.0f );
	m_fSpline[0][49] = FLOATKEY( 30.00f,  0.0f );

	InitFloatSpline( 50, m_fSpline[0] );

	m_fSpline[1][ 0] = FLOATKEY(  0.00f,  0.0f );
	m_fSpline[1][ 1] = FLOATKEY(  6.80f,  0.0f );
	m_fSpline[1][ 2] = FLOATKEY(  7.05f, 25.0f );
	m_fSpline[1][ 3] = FLOATKEY(  7.30f,  0.0f );
	m_fSpline[1][ 4] = FLOATKEY(  7.95f,  0.0f );
	m_fSpline[1][ 5] = FLOATKEY(  8.20f, 30.0f );
	m_fSpline[1][ 6] = FLOATKEY(  8.45f,  0.0f );
	m_fSpline[1][ 7] = FLOATKEY(  6.30f,  0.0f );
	m_fSpline[1][ 8] = FLOATKEY(  7.10f, 25.0f );
	m_fSpline[1][ 9] = FLOATKEY(  7.25f,  0.0f );
	m_fSpline[1][10] = FLOATKEY(  9.35f,  0.0f );
	m_fSpline[1][11] = FLOATKEY(  9.60f, 40.0f );
	m_fSpline[1][12] = FLOATKEY(  9.85f,  0.0f );
	m_fSpline[1][13] = FLOATKEY( 11.20f,  0.0f );
	m_fSpline[1][14] = FLOATKEY( 11.42f, 35.0f );
	m_fSpline[1][15] = FLOATKEY( 11.65f,  0.0f );
	m_fSpline[1][16] = FLOATKEY( 12.95f,  0.0f );
	m_fSpline[1][17] = FLOATKEY( 13.18f, 25.0f );
	m_fSpline[1][18] = FLOATKEY( 13.40f,  0.0f );	
	m_fSpline[1][19] = FLOATKEY( 15.10f,  0.0f );
	m_fSpline[1][20] = FLOATKEY( 15.38f, 30.0f );
	m_fSpline[1][21] = FLOATKEY( 15.60f,  0.0f );
	m_fSpline[1][22] = FLOATKEY( 17.02f,  0.0f );
	m_fSpline[1][23] = FLOATKEY( 17.27f, 35.0f );
	m_fSpline[1][24] = FLOATKEY( 17.50f,  0.0f );
	m_fSpline[1][25] = FLOATKEY( 19.10f,  0.0f );
	m_fSpline[1][26] = FLOATKEY( 19.31f, 25.0f );
	m_fSpline[1][27] = FLOATKEY( 19.40f, 15.0f );
	m_fSpline[1][28] = FLOATKEY( 19.49f, 40.0f );
	m_fSpline[1][29] = FLOATKEY( 19.60f,  0.0f );
	m_fSpline[1][30] = FLOATKEY( 20.50f,  0.0f );
	m_fSpline[1][31] = FLOATKEY( 20.72f, 20.0f );
	m_fSpline[1][32] = FLOATKEY( 20.95f,  0.0f );
	m_fSpline[1][33] = FLOATKEY( 22.00f,  0.0f );
	m_fSpline[1][34] = FLOATKEY( 22.25f, 30.0f );
	m_fSpline[1][35] = FLOATKEY( 22.50f,  0.0f );

	InitFloatSpline( 36, m_fSpline[1] );

	m_fSpline[2][ 0] = FLOATKEY(  0.00f,  0.0f );
	m_fSpline[2][ 1] = FLOATKEY(  9.80f,  0.0f );
	m_fSpline[2][ 2] = FLOATKEY( 10.00f, 35.0f );
	m_fSpline[2][ 3] = FLOATKEY( 10.20f,  0.0f );
	m_fSpline[2][ 4] = FLOATKEY( 13.20f,  0.0f );
	m_fSpline[2][ 5] = FLOATKEY( 13.40f, 25.0f );
	m_fSpline[2][ 6] = FLOATKEY( 13.60f,  0.0f );
	m_fSpline[2][ 7] = FLOATKEY( 13.87f, 15.0f );
	m_fSpline[2][ 8] = FLOATKEY( 13.92f,  0.0f );
	m_fSpline[2][ 9] = FLOATKEY( 14.06f, 30.0f );
	m_fSpline[2][10] = FLOATKEY( 14.15f,  0.0f );
	m_fSpline[2][11] = FLOATKEY( 14.25f, 20.0f );
	m_fSpline[2][12] = FLOATKEY( 14.50f,  0.0f );
	m_fSpline[2][13] = FLOATKEY( 30.00f,  0.0f );
	
	InitFloatSpline( 14, m_fSpline[2] );

	m_fSpline[3][ 0] = FLOATKEY(  0.00f,  0.0f );
	m_fSpline[3][ 1] = FLOATKEY(  6.55f,  0.0f );
	m_fSpline[3][ 2] = FLOATKEY(  6.72f, 25.0f );
	m_fSpline[3][ 3] = FLOATKEY(  6.83f,  0.0f );
	m_fSpline[3][ 4] = FLOATKEY(  6.93f, 20.0f );
	m_fSpline[3][ 5] = FLOATKEY(  7.10f,  0.0f );
	m_fSpline[3][ 6] = FLOATKEY(  7.50f,  0.0f );
	m_fSpline[3][ 7] = FLOATKEY(  7.71f, 30.0f );
	m_fSpline[3][ 8] = FLOATKEY(  7.82f, 15.0f );
	m_fSpline[3][ 9] = FLOATKEY(  7.95f, 35.0f );
	m_fSpline[3][10] = FLOATKEY(  8.20f,  0.0f );
	m_fSpline[3][11] = FLOATKEY(  8.40f,  0.0f );
	m_fSpline[3][12] = FLOATKEY(  8.57f, 40.0f );
	m_fSpline[3][13] = FLOATKEY(  8.68f,  0.0f );
	m_fSpline[3][14] = FLOATKEY(  8.79f, 25.0f );
	m_fSpline[3][15] = FLOATKEY(  8.87f, 15.0f );
	m_fSpline[3][16] = FLOATKEY(  8.99f, 35.0f );
	m_fSpline[3][17] = FLOATKEY(  9.20f,  0.0f );
	m_fSpline[3][18] = FLOATKEY(  9.58f,  0.0f );
	m_fSpline[3][19] = FLOATKEY(  9.78f, 25.0f );
	m_fSpline[3][20] = FLOATKEY(  9.90f,  0.0f );
	m_fSpline[3][21] = FLOATKEY( 11.00f,  0.0f );
	m_fSpline[3][22] = FLOATKEY( 11.19f, 30.0f );
	m_fSpline[3][23] = FLOATKEY( 11.40f,  0.0f );
	m_fSpline[3][23] = FLOATKEY( 11.50f,  0.0f );
	m_fSpline[3][24] = FLOATKEY( 11.64f, 35.0f );
	m_fSpline[3][25] = FLOATKEY( 11.80f,  0.0f );
	m_fSpline[3][26] = FLOATKEY( 11.95f,  0.0f );
	m_fSpline[3][27] = FLOATKEY( 12.10f, 15.0f );
	m_fSpline[3][28] = FLOATKEY( 12.19f,  0.0f );
	m_fSpline[3][29] = FLOATKEY( 12.28f, 20.0f );
	m_fSpline[3][30] = FLOATKEY( 12.39f,  0.0f );
	m_fSpline[3][31] = FLOATKEY( 12.52f, 15.0f );
	m_fSpline[3][32] = FLOATKEY( 12.70f,  0.0f );
	m_fSpline[3][33] = FLOATKEY( 15.65f,  0.0f );
	m_fSpline[3][34] = FLOATKEY( 15.83f, 25.0f );
	m_fSpline[3][35] = FLOATKEY( 15.59f,  0.0f );
	m_fSpline[3][36] = FLOATKEY( 16.05f, 20.0f );
	m_fSpline[3][37] = FLOATKEY( 16.20f,  0.0f );
	m_fSpline[3][38] = FLOATKEY( 17.45f,  0.0f );
	m_fSpline[3][39] = FLOATKEY( 17.62f, 20.0f );
	m_fSpline[3][40] = FLOATKEY( 17.74f,  0.0f );
	m_fSpline[3][41] = FLOATKEY( 17.87f, 25.0f );
	m_fSpline[3][42] = FLOATKEY( 18.00f,  0.0f );
	m_fSpline[3][43] = FLOATKEY( 18.65f,  0.0f );
	m_fSpline[3][44] = FLOATKEY( 18.90f, 40.0f );
	m_fSpline[3][45] = FLOATKEY( 19.10f,  0.0f );
	m_fSpline[3][46] = FLOATKEY( 20.00f,  0.0f );
	m_fSpline[3][47] = FLOATKEY( 20.23f, 25.0f );
	m_fSpline[3][48] = FLOATKEY( 20.35f,  0.0f );
	m_fSpline[3][49] = FLOATKEY( 20.47f, 20.0f );
	m_fSpline[3][50] = FLOATKEY( 20.60f,  0.0f );
	m_fSpline[3][51] = FLOATKEY( 21.65f,  0.0f );
	m_fSpline[3][52] = FLOATKEY( 21.88f, 40.0f );
	m_fSpline[3][53] = FLOATKEY( 22.05f,  0.0f );
	m_fSpline[3][54] = FLOATKEY( 22.35f,  0.0f );
	m_fSpline[3][55] = FLOATKEY( 22.50f, 30.0f );
	m_fSpline[3][56] = FLOATKEY( 22.65f,  0.0f );
	m_fSpline[3][57] = FLOATKEY( 30.00f,  0.0f );

	InitFloatSpline( 58, m_fSpline[3] );

	m_fSpline[4][ 0] = FLOATKEY(  0.00f,  0.0f );
	m_fSpline[4][ 1] = FLOATKEY(  7.15f,  0.0f );
	m_fSpline[4][ 2] = FLOATKEY(  7.33f, 25.0f );
	m_fSpline[4][ 3] = FLOATKEY(  9.20f,  0.0f );
	m_fSpline[4][ 4] = FLOATKEY(  9.43f, 30.0f );
	m_fSpline[4][ 5] = FLOATKEY(  9.60f,  0.0f );
	m_fSpline[4][ 6] = FLOATKEY( 10.20f,  0.0f );
	m_fSpline[4][ 7] = FLOATKEY( 10.36f, 25.0f );
	m_fSpline[4][ 8] = FLOATKEY( 10.46f,  0.0f );
	m_fSpline[4][ 9] = FLOATKEY( 10.56f, 40.0f );
	m_fSpline[4][10] = FLOATKEY( 10.68f, 10.0f );
	m_fSpline[4][11] = FLOATKEY( 10.80f, 30.0f );
	m_fSpline[4][12] = FLOATKEY( 11.00f,  0.0f );
	m_fSpline[4][13] = FLOATKEY( 12.80f,  0.0f );
	m_fSpline[4][14] = FLOATKEY( 12.98f, 35.0f );
	m_fSpline[4][15] = FLOATKEY( 13.15f,  0.0f );
	m_fSpline[4][16] = FLOATKEY( 15.00f,  0.0f );
	m_fSpline[4][17] = FLOATKEY( 15.18f, 25.0f );
	m_fSpline[4][18] = FLOATKEY( 15.35f,  0.0f );	
	m_fSpline[4][19] = FLOATKEY( 16.90f,  0.0f );
	m_fSpline[4][20] = FLOATKEY( 17.07f, 25.0f );
	m_fSpline[4][21] = FLOATKEY( 17.25f,  0.0f );
	m_fSpline[4][22] = FLOATKEY( 19.55f,  0.0f );
	m_fSpline[4][23] = FLOATKEY( 19.77f, 35.0f );
	m_fSpline[4][24] = FLOATKEY( 19.95f,  0.0f );
	m_fSpline[4][25] = FLOATKEY( 21.00f,  0.0f );
	m_fSpline[4][26] = FLOATKEY( 21.15f, 25.0f );
	m_fSpline[4][27] = FLOATKEY( 21.25f,  0.0f );
	m_fSpline[4][28] = FLOATKEY( 21.36f, 20.0f );
	m_fSpline[4][29] = FLOATKEY( 21.50f,  0.0f );
	
	InitFloatSpline( 30, m_fSpline[4] );

	m_dwRenderSubTitle = FALSE;
	m_dwTitleState = TITLE_NORMAL;

}

CTitleSequence::~CTitleSequence()
{
	SAFE_RELEASE( m_pvbCube );		

	for( DWORD i = 0 ; i < 10 ; i++ )
	{
		SAFE_DELETE( m_piqSubTitle[i] );
		SAFE_DELETE( m_piqTitle[i] );
	}
}

BOOL CTitleSequence::UpdateFrame( FLOAT fTime )
{	
	// standard setup

	m_pDevice->SetTransform( D3DTS_PROJECTION, ProjectionMtx( 5.0f, 0.75f, 1.0f, 1000.0f ) );
	m_pDevice->SetTransform( D3DTS_VIEW, CameraMtx( he3d_CVector( 0, 0, -3 ), he3d_CVector( 0, 0, 3 ), 0 ) );

	D3DMATERIAL8			d3dmat;	

	SetupMaterial( &d3dmat, 0x00ffffff, 0x0 );

	m_pDevice->SetMaterial( &d3dmat );
	m_pDevice->LightEnable( 0, TRUE );	

	DWORD					i;

	for( i = 0 ; i < 10 ; i++ )
		m_pfShift[i] = GetFloatSplineValue( fTime, 50, m_fSpline[0] );

	for( i = 10 ; i < 20 ; i++ )
		m_pfShift[i] = GetFloatSplineValue( fTime, 36, m_fSpline[1] );

	for( i = 20 ; i < 30 ; i++ )
		m_pfShift[i] = GetFloatSplineValue( fTime, 14, m_fSpline[2] );

	for( i = 30 ; i < 40 ; i++ )
		m_pfShift[i] = GetFloatSplineValue( fTime, 58, m_fSpline[3] );

	for( i = 40 ; i < 50 ; i++ )
		m_pfShift[i] = GetFloatSplineValue( fTime, 30, m_fSpline[4] );

	FLOAT					fCoeff;

	if( fTime < 5.5f )
	{	
		for( i = 0 ; i < 10 ; i++ )
		{	
			fCoeff = (5.5f - fTime)*(FLOAT)i/5.5f;

			m_piqTitle[i]->SetAlpha( 0x1f );		
			m_piqTitle[i]->Resize( 256.0f - 200.0f - fCoeff*10.0f, 256.0f - 50.0f - fCoeff*5.0f, 256.0f + 200.0f + fCoeff*10.0f, 256.0f + 50.0f + fCoeff*5.0f );
		}

		m_dwTitleState = TITLE_INTRO;
	}
	else
	{
		m_piqTitle[0]->Resize( 56.0f, 206.0f, 456.0f, 306.0f );
		
		fCoeff = 255.0f*sinf( (fTime - 5.5f)*H_PI*0.2f );

		if( fCoeff > 255.0f )
			fCoeff = 255.0f;
		else if( fCoeff < 0.0f )
			fCoeff = 0.0f;

		m_dwAlpha = (DWORD)fCoeff;

		m_dwTitleState = TITLE_BLUR;

		if( fTime > 11.0f )
			m_dwAlpha = 0x0;
	}

	if( fTime > 11.5f )
	{
		m_dwRenderSubTitle = TRUE;		

		for( i = 0 ; i < 10 ; i++ )
			m_piqSubTitle[i]->SetAlpha( 0x0 );

		if( fTime < 13.5f )
		{
			fCoeff = ( fTime - 11.5f )*0.5f;

			m_piqSubTitle[0]->Resize( 266.0f - 500 + 300*fCoeff, 306.0f, 266.0f + 500 - 300*fCoeff, 366.0f );
			m_piqSubTitle[0]->SetAlpha( (DWORD)( 255.0f*fCoeff ) );
		}				
		else
			m_piqSubTitle[0]->SetAlpha( 0xff );
			

		if( fTime < 12.25f )
		{
			fCoeff = (fTime - 11.5f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 500.0f - fCoeff*100.0f, 306.0f, 266.0f + 500.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 12.75f )
		{
			fCoeff = (fTime - 12.25f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 387.5f - fCoeff*100.0f, 306.0f, 266.0f + 387.5f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 13.25f )
		{
			fCoeff = (fTime - 12.75f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 312.5f - fCoeff*100.0f, 306.0f, 266.0f + 312.5f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 13.75f )
		{
			fCoeff = (fTime - 13.25f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 237.5f - fCoeff*100.0f, 306.0f, 266.0f + 237.5f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 14.25f )
		{
			fCoeff = (fTime - 13.75f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 14.75f )
		{
			fCoeff = (fTime - 14.25f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 15.25f )
		{
			fCoeff = (fTime - 14.75f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 15.75f )
		{
			fCoeff = (fTime - 15.25f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 16.25f )
		{
			fCoeff = (fTime - 15.75f)*2.0f;

			m_piqSubTitle[2]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[2]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}

		if( fTime < 12.0f )
		{
			fCoeff = (fTime - 11.5f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 500.0f - fCoeff*100.0f, 306.0f, 266.0f + 500.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 12.5f )
		{
			fCoeff = (fTime - 12.0f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 425.0f - fCoeff*100.0f, 306.0f, 266.0f + 425.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 13.0f )
		{
			fCoeff = (fTime - 12.5f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 350.0f - fCoeff*100.0f, 306.0f, 266.0f + 350.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 13.5f )
		{
			fCoeff = (fTime - 13.0f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 275.0f - fCoeff*100.0f, 306.0f, 266.0f + 275.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 14.0f )
		{
			fCoeff = (fTime - 13.5f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 14.5f )
		{
			fCoeff = (fTime - 14.0f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 15.0f )
		{
			fCoeff = (fTime - 14.5f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 15.5f )
		{
			fCoeff = (fTime - 15.0f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		else if( fTime < 16.0f )
		{
			fCoeff = (fTime - 15.5f)*2.0f;

			m_piqSubTitle[1]->Resize( 266.0f - 200.0f - fCoeff*100.0f, 306.0f, 266.0f + 200.0f + fCoeff*100.0f, 366.0f );
			m_piqSubTitle[1]->SetAlpha( (DWORD)( 255.0f*( 1.0f - fCoeff ) ) );
		}
		
	}	
	
	return TRUE;
}

BOOL CTitleSequence::RenderEfx()
{	
	FLOAT					pfPlane[4] = { 0.0f, 0.0f, -1.0f, 95.0f };

	m_pDevice->SetRenderState( D3DRS_ZENABLE, D3DZB_TRUE );
	m_pDevice->SetRenderState( D3DRS_LIGHTING, TRUE );
	m_pDevice->SetRenderState( D3DRS_CULLMODE, D3DCULL_NONE );	

	m_pDevice->Clear( 0, 0, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xffffff, 1.0f, 0 );			

	m_pDevice->SetRenderState( D3DRS_NORMALIZENORMALS, TRUE );
	m_pDevice->SetRenderState( D3DRS_CLIPPLANEENABLE, D3DCLIPPLANE0 );

	m_pDevice->SetClipPlane( 0, pfPlane );

	m_pDevice->SetVertexShader( FVF_VERTEX );
	m_pDevice->SetStreamSource( 0, m_pvbCube, sizeof(VERTEX) );	
	m_pDevice->SetTexture( 0, NULL );

	for( DWORD i = 0 ; i < CUBESCOUNT ; i++ )
	{
		m_pDevice->SetTransform( D3DTS_WORLD, TranslationMtx( 0.0f, 0.0f, -0.5f )*ScaleMtx( m_pvScale[i] + he3d_CVector( 0.0f, 0.0f, m_pfShift[i] ) )*TranslationMtx( m_pvPosition[i] ) );
		m_pDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, 12 );
	}
	
	m_pDevice->SetRenderState( D3DRS_NORMALIZENORMALS, FALSE );
	m_pDevice->SetRenderState( D3DRS_CLIPPLANEENABLE, FALSE );

	m_pDevice->SetTexture( 0, GetTexture( "title.bmp" ) );	
	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG2 );

	switch( m_dwTitleState )
	{
		case TITLE_INTRO:	
		{								
			m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );

			m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
			m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
			m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

			for( i = 0 ; i < 10 ; i++ )
				m_piqTitle[i]->Render( m_pDevice );			

			m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

			m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
		}
		break;

		case TITLE_BLUR:
		{
			m_pDevice->SetRenderState( D3DRS_TEXTUREFACTOR, m_dwAlpha << 24 );			

			m_pDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_SELECTARG2 );
			m_pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP, D3DTOP_BLENDFACTORALPHA );
			m_pDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, 0 );

			m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
			m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
			m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

			m_pDevice->SetTexture( 1, GetTexture( "title2.bmp" ) );

			m_piqTitle[0]->Render( m_pDevice );

			m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

			m_pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP, D3DTOP_DISABLE );
			m_pDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );

			m_pDevice->SetTexture( 1, NULL );
		}
		break;
	}	


	if( m_dwRenderSubTitle )
	{
		m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE );
		m_pDevice->SetTexture( 0, GetTexture( "subtitle.bmp" ) );	

		m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
		m_pDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
		m_pDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

		for( i = 0 ; i < 3 ; i++)
			m_piqSubTitle[i]->Render( m_pDevice );

		m_pDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );

		m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
	}

	m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );		

	return TRUE;
}
