// VertexTypes.h: interface for the VertexTypes class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VERTEXTYPES_H__8D0B5AA1_7133_11D5_AD0F_E06357C10000__INCLUDED_)
#define AFX_VERTEXTYPES_H__8D0B5AA1_7133_11D5_AD0F_E06357C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#pragma pack(4)
typedef struct _TLVERTEX
{	
	he3d_CVector		m_vPos;
	FLOAT				m_fRhw;
	DWORD				m_dwColor;
	FLOAT				m_fU;
	FLOAT				m_fV;

	_TLVERTEX( he3d_CVector& v, FLOAT fRhw, DWORD dwColor, FLOAT fU, FLOAT fV );
	_TLVERTEX( FLOAT x, FLOAT y, FLOAT z, FLOAT fRhw, DWORD dwColor, FLOAT fU, FLOAT fV );
} TLVERTEX, *PTLVERTEX;
#pragma pack()

#pragma pack(4)
typedef struct _TLMULTITEXVERTEX
{	
	he3d_CVector		m_vPos;
	FLOAT				m_fRhw;
	DWORD				m_dwColor;

	FLOAT				m_fU1;
	FLOAT				m_fV1;
	FLOAT				m_fU2;
	FLOAT				m_fV2;

	_TLMULTITEXVERTEX( he3d_CVector& v, FLOAT fRhw, DWORD dwColor, FLOAT fU1, FLOAT fV1, FLOAT fU2, FLOAT fV2 );
	_TLMULTITEXVERTEX( FLOAT x, FLOAT y, FLOAT z, FLOAT fRhw, DWORD dwColor, FLOAT fU1, FLOAT fV1, FLOAT fU2, FLOAT fV2 );
} TLMULTITEXVERTEX, *PTLMULTITEXVERTEX;
#pragma pack()

#pragma pack(4)
typedef struct _LVERTEX
{	
	he3d_CVector		m_vPos;	
	DWORD				m_dwColor;
	FLOAT				m_fU;
	FLOAT				m_fV;

	_LVERTEX::_LVERTEX( he3d_CVector& v, DWORD dwColor, FLOAT fU, FLOAT fV );
	_LVERTEX::_LVERTEX( FLOAT x, FLOAT y, FLOAT z, DWORD dwColor, FLOAT fU, FLOAT fV );

} LVERTEX, *PLVERTEX;
#pragma pack()

#pragma pack(4)
typedef struct _LMULTITEXVERTEX
{	
	he3d_CVector		m_vPos;	
	DWORD				m_dwColor;
	FLOAT				m_fU1;
	FLOAT				m_fV1;
	FLOAT				m_fU2;
	FLOAT				m_fV2;

	_LMULTITEXVERTEX::_LMULTITEXVERTEX( he3d_CVector& v, DWORD dwColor, FLOAT fU1, FLOAT fV1, FLOAT fU2, FLOAT fV2 );
	_LMULTITEXVERTEX::_LMULTITEXVERTEX( FLOAT x, FLOAT y, FLOAT z, DWORD dwColor, FLOAT fU1, FLOAT fV1, FLOAT fU2, FLOAT fV2 );

} LMULTITEXVERTEX, *PLMULTITEXVERTEX;
#pragma pack()


#pragma pack(4)
typedef struct _SIMPLEVERTEX
{	
	he3d_CVector		m_vPos;	
	DWORD				m_dwColor;	

	_SIMPLEVERTEX( he3d_CVector& v, DWORD dwColor  );
	_SIMPLEVERTEX( FLOAT x, FLOAT y, FLOAT z, DWORD dwColor );
} SIMPLEVERTEX, *PSIMPLEVERTEX;
#pragma pack()

#pragma pack(4)
typedef struct _VERTEX
{
	he3d_CVector		m_vPos;
	he3d_CVector		m_vN;
	FLOAT				m_fU;
	FLOAT				m_fV;

	_VERTEX( he3d_CVector& v, he3d_CVector& u, FLOAT fU, FLOAT fV );
	_VERTEX( FLOAT px, FLOAT py, FLOAT pz, FLOAT nx, FLOAT ny, FLOAT nz, FLOAT fU, FLOAT fV );
} VERTEX, *PVERTEX;
#pragma pack()

#pragma pack(4)
typedef struct _NPOSVERTEX
{
	he3d_CVector		m_vPos;
	he3d_CVector		m_vN;

	_NPOSVERTEX( he3d_CVector& v, he3d_CVector& n );
	_NPOSVERTEX( FLOAT px, FLOAT py, FLOAT pz, FLOAT nx, FLOAT ny, FLOAT nz );
} NPOSVERTEX, *PNPOSVERTX;

#define	FVF_TLVERTEX			D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX1
#define	FVF_TLMULTITEXVERTEX	D3DFVF_XYZRHW | D3DFVF_DIFFUSE | D3DFVF_TEX2
#define	FVF_LVERTEX				D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1
#define	FVF_LMULTITEXVERTEX		D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX2
#define	FVF_SIMPLEVERTEX		D3DFVF_XYZ | D3DFVF_DIFFUSE
#define	FVF_VERTEX				D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_TEX1
#define	FVF_NPOSVERTEX			D3DFVF_XYZ | D3DFVF_NORMAL

#endif // !defined(AFX_VERTEXTYPES_H__8D0B5AA1_7133_11D5_AD0F_E06357C10000__INCLUDED_)
