{
  bwread.pas views black and white animations
  (c) 1997 by florian haller/aeiou
  finished 19970721.1938.GRAZ.AT
}

program bwread;

uses crt, dos;

const cache_size = 32768;

var cache_readpos: word;
    cache_count: word;
    cache_read: array [1..cache_size] of byte;
    cache_status: boolean;
    inf: file;

function cachedopenread (filename: string): boolean;
begin
  assign (inf, filename);
  {$i-}
  reset (inf, 1);
  {$i+}
  if ioresult <> 0 then
    cachedopenread := false
  else
    cachedopenread := true;
  cache_readpos := cache_size + 1;
end;

procedure cachedcloseread;
begin
  close (inf);
end;

procedure cachedblockread (var data: byte);
begin
  if cache_readpos > cache_count then begin
    if eof (inf) then begin
      cache_status := false;
      exit;
    end else
      cache_status := true;
    blockread (inf, cache_read, cache_size, cache_count);
    cache_readpos := 1;
  end;
  data := cache_read [cache_readpos];
  inc (cache_readpos);
end;

procedure error (message: string);
begin
  writeln (message);
  halt;
end;

const frameraw = 1;
      framerle = 2;
      framediff = 3;
      frameclear = 0;
      animationend = 255;
      tempsize = 64000;

type temparray = array [1..tempsize] of byte;
     temppointer = ^temparray;

var x, y, c: word;
    a, b, d, f: byte;
    oldtimer: pointer;
    exitswitch: boolean;
    temp: temppointer;

procedure play;
begin
  cachedblockread (a);
  case a of
    animationend: exitswitch := true;
    frameraw: for x := 1 to 8000 do begin
                cachedblockread (d);
                y := d;
                for b := 1 to 8 do begin
                  y := y shl 1;
                  mem [$a000: (x * 8) + b - 9] := hi (y);
                  y := y and 255;
                end;
              end;
    framerle: begin
                x := 0;
                d := 0;
                repeat
                  cachedblockread (b);
                  if (b and 128) <> 0 then begin
                    y := (b and 127) shl 8;
                    cachedblockread (b);
                    y := y + b;
                  end else
                    y := b and 127;
                  for c := 1 to y do
                    mem [$a000: x + c - 1] := d;
                  inc (x, y - 1);
                  if d = 0 then d := 1 else d := 0;
                until x >= 64000;
              end;
    framediff: begin
                 x := 0;
                 d := 0;
                 repeat
                   cachedblockread (b);
                   if (b and 128) <> 0 then begin
                     y := (b and 127) shl 8;
                     cachedblockread (b);
                     y := y + b;
                   end else
                     y := b and 127;
                   for c := 1 to y do
                     temp^ [x + c] := d;
                   inc (x, y - 1);
                   if d = 0 then d := 1 else d := 0;
                 until x >= 64000;
                 for x := 1 to 64000 do
                   if temp^ [x] = 1 then
                     if mem [$a000: x - 1] = 1 then
                       mem [$a000: x - 1] := 0 else
                       mem [$a000: x - 1] := 1;
               end;
  end;
end;

procedure counter; interrupt;
begin
  asm
    mov al, exitswitch
    inc al
    and al, 1
    mov f, al
  end;
  port [$20] := $20;
end;

begin
  writeln ('bw.read v2, (c) 1997 florian haller');
  if paramcount < 1 then error ('syntax: BWREAD.EXE [bwfile]');
  if not cachedopenread (paramstr (1) + '.bw') then
    error ('file not found.');
  if memavail < 64000 then error ('not enough memory.');
  asm
    mov ax, 13h
    int 10h
    mov dx, 3c8h
    mov al, 1
    out dx, al
    inc dx
    mov al, 63
    out dx, al
    out dx, al
    out dx, al
  end;
  getmem (temp, tempsize);
  exitswitch := false;
  getintvec ($1c, oldtimer);
  setintvec ($1c, @counter);
  repeat
    if f = 1 then begin
      play;
      f := 0;
    end;
  until (exitswitch) or (keypressed);
  setintvec ($1c, oldtimer);
  freemem (temp, tempsize);
  cachedcloseread;
  readkey;
  asm
    mov ax, 3
    int 10h
  end;
end.