PROGRAM WeirDraw;

(**************************************************************************

Program:        WeirDraw
Version:        1.0 (25.5.1999)
Filename:       WDRAW.PAS
Description:    just another ansi paint program coded by shine and kyp/bm

***************************************************************************)

{$L header.obj} Procedure header;external;
{$L footer.OBJ} Procedure footer;external;


CONST BlockSize=3;      {size of the generated block...}
      vidModeLines=25;  {forces user to use 80x25 dos mode}
                        {needs an improvement of course}

      maxYLines=23;     {how large is the ansi?}
                        {variable size not supported
                         FIXED ANSI SIZE IS 80x23 !}

      ansichars:array[1..6] of char = (#219,#32,#223,#220,#221,#222);
                      {used to set a random brick}
      scancode:Char = #0;


TYPE BlockType= ARRAY [1..blocksize*2, 1..blocksize] OF CHAR;
     ScreenType= ARRAY [1..80,1..maxYLines] OF CHAR;


VAR under:Boolean;      {should the actual block be pasted
                        over or under the existing bricks? }

    edited: boolean;    {was the picture editied?}
    ExitProg:Boolean;   {exit program?}

    x,y:BYTE;
    myBlock: BlockType;
    myScreen: ScreenType;


{  SCREEN COMMANDS  }

procedure CursorOff;
begin Port[$3d4]:=$0a; Port[$3d5]:=Port[$3d5] OR 32; end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

procedure CursorOn;
begin Port[$3d4]:=$0a; Port[$3d5]:=Port[$3d5] AND 223; end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE SetChar (x, y, colour: BYTE; character: CHAR);
{sets an ascii character at a given colour at a screen position}
BEGIN
 mem[$b800:(x-1)*2+((y-1)*160)]:=ord(character);
 mem[$b800:(x-1)*2+((y-1)*160+1)]:=colour;
END; {SetChar}

(* ---- new PROCEDURE starts here --------------------------------------- *)

procedure Cls; Assembler;
Asm MOV AX,$B800;MOV ES,AX;XOR DI,DI;MOV CX,4000;MOV AX,0700h;REP STOSW; end;

procedure gotoXY(x,y:Byte);Assembler;
asm mov ah,2; xor bh, bh; mov dh,y; mov dl, x; int 10h end;

FUNCTION ReadKey:char; ASSEMBLER;
ASM XOR AL,AL; XCHG AL,SCANCODE; OR AL,AL; JNZ @EXIT; MOV AH,10h; INT 16h;
 CMP AL,0E0h; JNE @CHKSCAN; OR AH,AH; JZ @EXIT; XOR AL,AL; @CHKSCAN:
 OR AL,AL; JNZ @EXIT; MOV SCANCODE,AH; OR AH,AH; JNZ @EXIT; MOV AL,3; @EXIT:
END;


(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE WriteString (x, y, colour: BYTE; stri: STRING);
{writes a string at a given position}
VAR i: BYTE;
BEGIN
  IF (x+length(stri))>80 THEN {error checking}
    stri:=copy(stri, 1, 80-(x+length(stri)) )
  ELSE
  {otherwise it's regular}
  FOR i:=1 TO length(stri) DO SetChar(x+i-1,y,colour,stri[i]);
END; {WriteString}

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE WaitVert;assembler;
asm mov dx,3dah;@VR: in al,dx; test al,8; jz @VR end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE DrawMenu;
BEGIN
  cls;
  Move(Pointer(@header)^,ptr($B800,0)^,160);
  Move(Pointer(@footer)^,ptr($B800,3840)^,160);
END;


{  BLOCK COMMANDS  }

PROCEDURE CreateBlock(BlockSize: BYTE; VAR block: BlockType);
{creates a random block}
VAR x, y:Byte;
begin
  for y:=1 to BlockSize do
    for x:=1 to BlockSize*2 do
      block[x,y]:= ansichars[Random(6)+1];
end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE InvertBlock (VAR block: BlockType);
{inverts the current block}
VAR x, y:Byte;
begin
  for y:=1 to BlockSize do
    for x:=1 to BlockSize*2 do
      case block[x,y] of
        #219: block[x,y]:=#32;
         #32: block[x,y]:=#219;
        #223: block[x,y]:=#220;
        #220: block[x,y]:=#223;
        #221: block[x,y]:=#222;
        #222: block[x,y]:=#221;
      end;
end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

procedure flip_x (VAR block: Blocktype; sorted: Boolean);
var temp: BlockType;
    x,y: Byte;

begin
  for y:=1 to BlockSize do
    for x:=1 to BlockSize*2 do
      temp[x,y]:=block[x,BlockSize+1-y];

  if sorted then begin
    for y:=1 to BlockSize do
      for x:=1 to BlockSize*2 do
        case temp[x,y] of
          #223: temp[x,y]:=#220;
          #220: temp[x,y]:=#223;
        end;
  end;
  block:=temp;
end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

procedure flip_y (VAR block: Blocktype; sorted: Boolean);
var temp: BlockType;
    x,y: Byte;

begin
  for y:=1 to BlockSize do
    for x:=1 to BlockSize*2 do
      temp[x,y]:=block[BlockSize*2+1-x,y];

  if sorted then begin
    for y:=1 to BlockSize do
      for x:=1 to BlockSize*2 do
        case temp[x,y] of
          #221: temp[x,y]:=#222;
          #222: temp[x,y]:=#221;
        end;
  end;
  block:=temp;
end;


(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE showblock(x,y:BYTE; block: BlockType; screen: ScreenType; mode_under: Boolean);
VAR x0, y0:Byte;
begin
  if mode_under then begin
    for y0:=1 to BlockSize do
      for x0:=1 to BlockSize*2 do
        if ((x0+x < 81) and (y0+y < vidModeLines)) and
           ((screen[x0+x,y0+y] = #0) or (screen[x0+x,y0+y] = #32)) then
        begin
          SetChar(x0+x,y0+y,7,block[x0,y0]);
        end
  end else begin
    for y0:=1 to BlockSize do
      for x0:=1 to BlockSize*2 do
        if (x0+x < 81) and (y0+y < vidModeLines) then
        begin
          SetChar(x0+x,y0+y,7,block[x0,y0]);
        end;
  end;
end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE dropblock (x,y: BYTE; block: BlockType; VAR screen: ScreenType; mode_under:Boolean);
VAR x0,y0:Byte;
    test1, test2: string;

begin
  if mode_under then begin
    for y0:=1 to BlockSize do
      for x0:=1 to BlockSize*2 do
        if (screen[x+x0,y+y0]<>#0) OR (screen[x+x0,y+y0]<>#32) then
          screen[x+x0,y+y0]:=(block[x0,y0]);
  end else begin
    for y0:=1 to BlockSize do
      for x0:=1 to BlockSize*2 do begin
      {if (x0+x < 81) and (y0+y < maxy) then}
        screen[x+x0,y+y0]:=(block[x0,y0]);
    end;
  end;
end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE EditField(VAR st:String; x,y, maxpos:Byte);
var c:Char;pos:Byte;
raus:Boolean;

begin
raus:=false; pos:=length(st)+1;
if pos=0 then begin gotoxy(x,y); end else begin
gotoXY(x,y);Write(st);gotoxy(x+pos,y);end;
repeat
 c:=readkey;
 case Ord(c) of
    8: If Pos>1 then begin gotoxy(x+pos-1,y);Write(' ');
          Dec(Pos); Gotoxy(x+pos,y);end; {Backspace}
   13: Raus:=true;
   27: Raus:=true;
  else
    if pos>=maxpos then begin Writeln(#7);Gotoxy(x+maxpos,y); end else begin
    st[pos]:=c;write(c);Inc(pos);Gotoxy(x+pos,y);end;
 end;
until raus=true;
st[0]:=Chr(pos-1);
end;


{  DISPLAY  }


function LZ(w:Byte):String;
var s:String;
begin Str(w:0,s);if Length(s)=1 then s:=' '+s; LZ:=s; end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE UpdateDisplay (x,y: BYTE; VAR screen: ScreenType; VAR block: BlockType);
VAR x0,y0:Byte;

begin
  for x0:=1 to 80 do
    for y0:=2 to vidModeLines-1 do
        SetChar(x0,y0,7,screen[x0,y0]);

  SetChar(80,24,0,#32);  {if this is not done, the program displays the
                          first character of the block in the lower
                          right corner...}

  WriteString(75,1,23,lz(x)); {shows x/y-coordinates}
  WriteString(78,1,23,lz(y-1)); {attrib:32 = FG:7 BG:1}

  ShowBlock(x,y,block, screen, under);
end;


{  FILE ROUTINES  }

PROCEDURE save(screen: ScreenType; edited: BOOLEAN);
VAR f:text;
    name: string;
    x0,y0:Byte;

begin
  CursorOn;
  WriteString(1,25,23,'SAVE:                                              ');
  name:='';
  EditField(name, 5, 24, 35); {path limited to 35 chars}
  CursorOff;

  if name<>'' then begin
     Assign(f, name); {$I-} Rewrite(f); {$I+} {! files are overwritten !}

     if IOResult=0 then begin
        for y0:=1 to vidModeLines do begin
           for x0:=1 to 80 do
              write(f, screen[x0,y0]);
           writeln(f);
        end;
     close(f);
     edited:=false;
     end else Write(#7);
  end else Write(#7);
  Drawmenu;
end;

(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE load(VAR screen: ScreenType);
VAR f:text;
    name: string;
    x0,y0:Byte;

begin
  CursorOn;

  WriteString(1,25,23,'LOAD:                                              ');
  name:='';
  EditField(name, 5, 24, 35); {path limited to 35 chars}
  CursorOff;

  if name<>'' then begin
     Assign(f, name); {$I-} Reset(f); {$I+}

     if IOResult=0 then begin
        for y0:=1 to vidModeLines do begin
           for x0:=1 to 80 do
              read(f, screen[x0,y0]);
           readln(f);
        end;
        close(f);
     end else Write(#7);
  end else Write(#7);
  Drawmenu;
end;


(* ---- new PROCEDURE starts here --------------------------------------- *)

PROCEDURE keys(x,y: BYTE; block:BlockType; screen: ScreenType; edited:BOOLEAN);
VAR ch: char;
begin

repeat
  waitvert;
  updatedisplay(x,y,screen,block);

  ch:=readkey;

  case ch of
    #72: if y > 1 then dec(y); {up}
    #80: if y < (vidModeLines-1-BlockSize) then inc(y); {down}
    #75: if x > 0 then dec(x); {left}
    #77: if x < (80-BlockSize*2) then inc(x); {right}

    #13: begin DropBlock(x,y,block,screen, under); edited:=true; end;
    'n': begin CreateBlock(BlockSize, block);
               ShowBlock(x,y,block, screen, under);
         end;
    'i': begin InvertBlock(block);
               ShowBlock(x,y,block, screen, under);
         end;
    'u': begin under:=true;
               WriteString(34,1,26,'U');WriteString(41,1,20,'O');
               ShowBlock(x,y,block, screen, under);
         end;
    'o': begin under:=false;
               WriteString(41,1,26,'O');WriteString(34,1,20,'U');
               ShowBlock(x,y,block, screen, under);
         end;
    'x': begin flip_x(block, FALSE);
               ShowBlock(x,y,block, screen, under);
         end;
    'v': begin flip_x(block, TRUE);
               ShowBlock(x,y,block, screen, under);
         end;
    'y': begin flip_y(block, FALSE);
               ShowBlock(x,y,block, screen, under);
         end;
    'w': begin flip_y(block, TRUE);
               ShowBlock(x,y,block, screen, under);
         end;

    #46: fillchar(screen, sizeof(screen),#32); {clear: ALT-C}
    #31: save(screen,edited); {save: ALT-S}
    #38: begin {load: ALT-L}
           if edited then
             begin
               WriteString(1,25,23,'discard changes? (y/n)                              ');
               ch:=readkey;  if ch='n' then save(screen,edited);
             end;
           load(screen);

           CreateBlock(BlockSize, block);
           ShowBlock(x,y,block, screen, under);
           {if you don't create a new block, the old one won't be
            displayed correctly (i.e: first character is '' (#218) }
         end;
    #45: begin {exit: ALT-X}
           if edited then
             begin
               WriteString(1,25,23,'exit without saving? (y/n)                          ');
               ch:=readkey;  if ch='n' then save(screen,edited);
             end;
           ExitProg:=true;
         end;
  end;

until ExitProg;
end;



{  MAIN  }


BEGIN
  randomize; {used to create random blocks}

  CursorOff;
  DrawMenu;
  WriteString(41,1,26,'O'); {shows insert mode: 'over' activiated}

  edited:=false;
  under:=false;
  ExitProg:=false;
  x:=0; y:=1; {where is the fist block displayed? (menu: y=0 !) }

  CreateBlock(BlockSize,myBlock);

  keys(x,y,myblock,myscreen,edited);
  cls;gotoxy(0,0);
  CursorOn;
END. {WeirDraw}
