/*

tesla 2 efekt

return:
  0 - doslo k chybe
  1 - este nezacal
  2 - prebehol v poriadku
  3 - uz skoncil
*/

#include <iostream>
#include "api3ds.h"
#include "efekt.h"
#include "efekt_08.h"
#include "syncs.h"

extern int sync_id;
extern BOOL usefog;

int  efekt_08::init()
{
  cout << "Efekt 08 init ... ";
  start=TRUE;
  counter=ZACIATOK08*refresh;
  tex_x_counter=0;
  tex_y_counter=0.0;
  real_in=0.0;
  intens=0.0;
  cout << "ok!" << endl;
  return 1;
}

int  efekt_08::load()
{
    cout << "Loading efekt08 ... ";
    Vector3f o,i,j,k;
    FILE *stream;

    stream=fopen(CFGNAME08,"r");
    if (stream==NULL) return 0;

    fscanf(stream,"pocet ploch          %i\n",&plochy);
    fscanf(stream,"intenzita            %f\n",&intensr);
    fscanf(stream,"x-krok               %f\n",&txadd);
    fscanf(stream,"y-krok               %f\n",&tyadd);
    fscanf(stream,"roll speed           %f\n",&roll_speed);
    fscanf(stream,"podstava valca       %i\n",&podstava);
    fscanf(stream,"vyska valca          %i\n",&vyska);
    float cl_r,cl_g,cl_b;
    fscanf(stream,"background color     %f,%f,%f\n",&cl_r,&cl_g,&cl_b);
    fscanf(stream,"visibility           %f\n",&vis);
    fscanf(stream,"minvisibility        %f\n",&minvis);
    fscanf(stream,"Descent origin       (%f,%f,%f)\n",&o.x,&o.y,&o.z);
    fscanf(stream,"Descent right        (%f,%f,%f)\n",&i.x,&i.y,&i.z);
    fscanf(stream,"Descent up           (%f,%f,%f)\n",&j.x,&j.y,&j.z);
    fscanf(stream,"Descent forward      (%f,%f,%f)\n",&k.x,&k.y,&k.z);
    fclose(stream);

    camera.SetAll(o,i,j,k);
    camera.FarClipplane(vis);
    camera.NearClipplane(minvis);
    camera.HorizontalFOV(0.63);
    camera.VerticalFOV(0.47);
    texla=texture_library->GetOrCreate("NICETEXT.JPG");

    cout << "ok!"<<endl;
}

int  efekt_08::free()  //vrati 3 ako ok, 0 ak doslo k chybe
{
end=true;
return 3;
}

int  efekt_08::update()
{
id=Sync[GetSyncNum(float(counter)/float(refresh))].id;

tex_x_counter+=txadd;
tex_y_counter+=tyadd;
uhol_counter+=roll_speed;
if ((counter/refresh)<142)
  {
  if (intens<intensr) intens+=0.002;
             else intens=intensr;
  }
  else
  {
  if (intens>0.0) intens-=0.001;
             else intens=0.0;
  if (intens>0.5) intens-=0.003;   
  }

return 1;
}

int efekt_08::go(double t)
{
if (t<ZACIATOK08) return 1;
if (end) return 3;
if (counter>=KONIEC08*refresh) return free();

if (!start) if (!init()) return 0;
int cur_frm=(int)(t*refresh);
if (cur_frm>KONIEC08*refresh) cur_frm=int(KONIEC08*refresh);
if (cur_frm>counter)
  while (counter<cur_frm)
    {
    counter++;
    if (counter<KONIEC08*refresh) update();
    }
if (counter>=KONIEC08*refresh) return free();

//tu sa kresli->
  
  glEnable(GL_TEXTURE_2D);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glDisable(GL_CULL_FACE);
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_ONE);
  glDisable(GL_FOG);

  texla->GL();
  camera.GL();

  if (intens>0.0)
   glBegin(GL_QUADS);

     for (int i=plochy;i;i--)
       {
       float y=podstava*cos(uhol_counter+i*2*PI/plochy);
       float z=podstava*sin(uhol_counter+i*2*PI/plochy);

       glColor3f(0.0,0.0,0.0);
       glTexCoord2f( tex_x_counter, tex_y_counter);
       glVertex3f(-vyska, y, z);

       glColor3f(intens,intens,intens);
       glTexCoord2f( tex_x_counter, tex_y_counter+1.0);
       glVertex3f(-vyska, 0, 0);

       glTexCoord2f( tex_x_counter+1.0, tex_y_counter+1.0);
       glVertex3f( vyska, 0, 0);

       glColor3f(0.0,0.0,0.0);
       glTexCoord2f( tex_x_counter+1.0, tex_y_counter);
       glVertex3f( vyska, y, z);

       }
   glEnd();
//<-
return 2;
}