#ifndef __PTIMER__
#define __PTIMER__
#include <windows.h>

class PTIMER
{
  __int64 freq;
  double resolution;
  __int64 start;
  __int64 t;
public:
  PTIMER()
    {
      QueryPerformanceFrequency((LARGE_INTEGER*)&freq);
      QueryPerformanceCounter((LARGE_INTEGER*)&start);
      resolution = 1.0/(double)freq;
    }

  double time()
    {
      QueryPerformanceCounter((LARGE_INTEGER*)&t);
      t = t-start;
      return t*resolution;
    }

  void reset(double te=0.0)
    {
      QueryPerformanceFrequency((LARGE_INTEGER*)&freq);
      QueryPerformanceCounter((LARGE_INTEGER*)&start);
      resolution = 1.0/(double)freq;
      start-=(__int64)(te*freq);
    }


  __int64 frequency()
    { return freq;}

};

#endif
