#ifdef WIN32
#include <windows.h>
#endif

#ifndef WIN32
#define APIENTRY
#define CALLBACK
#endif

#include <GL/gl.h>
#include <string.h>
#include <iostream>

/* GL_EXT_compiled_vertex_array */
typedef void APIENTRY ( * PFNGLLOCKARRAYSEXTPROC) (GLint first, GLsizei count);
typedef void APIENTRY ( * PFNGLUNLOCKARRAYSEXTPROC) (void);

void APIENTRY glLockArraysOGL2 (GLint first, GLsizei count) {
  return;
}
void APIENTRY glUnlockArraysOGL2 (void) {
  return;
}

PFNGLLOCKARRAYSEXTPROC glLockArraysEXT = &glLockArraysOGL2;
PFNGLUNLOCKARRAYSEXTPROC glUnlockArraysEXT = &glUnlockArraysOGL2;

int isExtensionSupported(const char *extension)
{
  const GLubyte *extensions = NULL;
  const GLubyte *start;
  GLubyte *where, *terminator;

  /* Extension names should not have spaces. */
  where = (GLubyte *) strchr(extension, ' ');
  if (where || *extension == '\0')
    return 0;
  extensions = glGetString(GL_EXTENSIONS);
  /* It takes a bit of care to be fool-proof about parsing the
     OpenGL extensions string. Don't be fooled by sub-strings,
     etc. */
  start = extensions;
  for (;;) {
    where = (GLubyte *) strstr((const char *) start, extension);
    if (!where)
      break;
    terminator = where + strlen(extension);
    if (where == start || *(where - 1) == ' ')
      if (*terminator == ' ' || *terminator == '\0')
        return 1;
    start = terminator;
  }
  return 0;
}
 
void InitOpenGLExtensions()
{
  if(isExtensionSupported("GL_EXT_compiled_vertex_array")) {
//    cout << "Using extension: GL_EXT_compiled_vertex_array" << endl;

    glLockArraysEXT = (PFNGLLOCKARRAYSEXTPROC)
      wglGetProcAddress("glLockArraysEXT");
    glUnlockArraysEXT = (PFNGLUNLOCKARRAYSEXTPROC)
      wglGetProcAddress("glUnlockArraysEXT");
  }
  else {
    if(isExtensionSupported("GL_SGI_compiled_vertex_array")) {
      cout << "Using extension: GL_SGI_compiled_vertex_array" << endl;
  
      glLockArraysEXT = (PFNGLLOCKARRAYSEXTPROC)
        wglGetProcAddress("glLockArraysSGI");
      glUnlockArraysEXT = (PFNGLUNLOCKARRAYSEXTPROC)
        wglGetProcAddress("glUnlockArraysSGI");
    }
  }
}
