#ifndef __OGL2_IMAGE__
#define __OGL2_IMAGE__

#include <png.h>
#include <jpeglib.h>

extern "C++" {

#define BMP_RGB 0
#define BMP_RLE8 1
#define BMP_RLE4 2

#define OGL_IMAGE_NULL        0
#define OGL_IMAGE_RGBA8888    1
#define OGL_IMAGE_ARGB8888    2
#define OGL_IMAGE_RGB888      3
#define OGL_IMAGE_INDEX8      4
#define OGL_IMAGE_LUMINANCE8  5

class Image
{
  struct BMPHEADER {
    short  bfType;          // "BM"
    long   bfSize;          // BMP size (in bytes)
    short  bfReserved1;     // always zero
    short  bfReserved2;     // zero
    long   bfOffBits;       // relative offset of actual bitmap data

    long   biSize;          // size of the header from this point
    long   biWidth;         // bitmap width (pixels)
    long   biHeight;        // bitmap height (pixels)
    short  biPlanes;        // 1
    short  biBitCount;      // bpp (1,4,8,24)
    long   biCompression;   // plain: RGB, compressed: RLE8, RLE4
    long   biSizeImage;     // 0
    long   biXPelsPerMeter; // horiz resolution for the target device
    long   biYPelsPerMeter; // vertical resolution...
    long   biClrUsed;       // palette size, if zero then full bpp
    long   biClrImportant;  // if 0 then all colors are important
                            // follows palette in bgr0 &bisize+bisize
  } header;

  unsigned long* paleta;
  unsigned char* bitmap;
  int h, w;
  int bpp;
  int form;

public:
  Image ();
  Image (const char* filename);
  ~Image ();

  unsigned long* palette() { return paleta; }
  unsigned char* data() { return bitmap; }
  int format() { return form; }
  int width() { return w; }
  int height() { return h; }

  int Load(const char* filename);
  int LoadBMP(const char* filename);
  int LoadPNG(const char* filename);
  int LoadJPG(const char* filename);

  void FlipVertical();  
  void Scale(int sirka, int vyska);
};

} // extern "C++"

#endif
