#ifndef __OGL2_LIGHT__
#define __OGL2_LIGHT__

#include "types.h"
#include "entity.h"

extern "C++" {

class Light : public Entity {
public:
  virtual ~Light () {}
  virtual void GL (GLenum light, double time = 0.0) = 0;
};

class Lights : public EntityList<Light> {
public:
  void GL (double time = 0.0);
};

class LightGL : public Light
{
  GLfloat ambient[4];
  GLfloat diffuse[4];
  GLfloat specular[4];
  GLfloat position[4];
  GLfloat spot_direction[3];

  GLfloat spot_exponent;
  GLfloat spot_cutoff;
  GLfloat constant_attenuation;
  GLfloat linear_attenuation;
  GLfloat quadratic_attenuation;

public:  

  LightGL ();

  void Reset ();

  void GL (GLenum light, double time = 0.0);

  void Ambient (GLfloat r, GLfloat g, GLfloat b, GLfloat a = 1.0F),
       Diffuse (GLfloat r, GLfloat g, GLfloat b, GLfloat a = 1.0F),
       Specular (GLfloat r, GLfloat g, GLfloat b, GLfloat a = 1.0F),
       Ambient (GLfloat* v),
       Diffuse (GLfloat* v),
       Specular (GLfloat* v);

  void Position (GLfloat x, GLfloat y, GLfloat z, GLfloat w = 1.0F),
       Position (GLfloat* v),
       SpotDirection (GLfloat i, GLfloat j, GLfloat k),
       SpotDirection (GLfloat* v);

  void SpotExponent (GLfloat f),
       SpotCutoff (GLfloat f),
       ConstantAttenuation (GLfloat f),
       LinearAttenuation (GLfloat f),
       QuadraticAttenuation (GLfloat f);


  // Feedback

  const GLfloat* Ambient ();
  const GLfloat* Diffuse ();
  const GLfloat* Specular ();
  const GLfloat* Position ();
  const GLfloat* SpotDirection ();

  GLfloat SpotExponent (),
       SpotCutoff (),
       ConstantAttenuation (),
       LinearAttenuation (),
       QuadraticAttenuation ();
};

} // extern "C++"

#endif

