; bits 16 ;;; nasm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_detectvideo:  ; int detectvideo();      0/1/2/3 = mda/cga/ega/vga

        push bx
        push cx
        push dx
        push si
        push di
        push bp
        push es
        push ds

        mov ax,01a00
        int 010
        cmp al,01a
        je dvc3          ; vga

        mov ax,01200
        mov bl,010
        int 010
        cmp bl,010
        jne dvc2         ; ega

        int 011
        test al,030
        jne dvc1         ; cga

        mov ax,0        ; mda
        jmp dvo0
   dvc1:mov ax,1
        jmp dvo0
   dvc2:mov ax,2
        jmp dvo0
   dvc3:mov ax,3
   dvo0:
        pop ds
        pop es
        pop bp
        pop di
        pop si
        pop dx
        pop cx
        pop bx
        retf

_adlib:         ; int adlib(regno,value);

        push bp
        mov bp,sp
        push ax
        push cx
        push dx

        mov ax,[bp+6]
        mov dx,[bp+8]
        mov ah,dl

        mov dx,0388

        out dx,al
           mov cx,6
           adt1:in al,dx
           loop adt1

        mov al,ah

         inc dx
          out dx,al
         dec dx
           mov cl,35
           adt2:in al,dx
           loop adt2

        pop dx
        pop cx
        pop ax
        pop bp
        retf

_setvideo:	; void setvideo(ax);
	push bp
	mov bp,sp
	push bx
	mov ax,[bp+6]
	xor bx,bx
        int 010
	pop bx
	pop bp
	retf

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

_dump80501616:	; (char*srcbuf)

	push ds
	push si
	push cx
	push ax
	push di
	push es

	xor di,di
        mov ax,0b800
	mov es,ax

	lds si,[bp+6]
	mov cx,(80*50)/4
	mov ah,176
	
dul0:   lodsb
	stosw
	lodsb
	stosw
	lodsb
	stosw
	lodsb
	stosw
        loop dul0

	pop es
	pop di
	pop ax
	pop cx
	pop si
	pop ds
	retf

; _dump8025816		classic: use 220-blocks
; _dumpmono		ascii convtab:  lodsw; mov bx,ax; mov al,[bx]; stosb; inc di; ...
;			or: as in classic + xlat
