#!/usr/bin/perl

#   color=>grayscale palettes:
#
#   0x00,0x08,0x80,0x88,0x87,0x78,0x77,0x7f,0xf7,0xff

###########################

$spritz="sprite*allbmps[]={";

$wrct=0;
sub wr
{
   printf("0x%x,",$_[0]);
   $wrct+=5;
   if($wrct>=70){printf("\n");$wrct=0;}
}

sub wrrle
{
   my ($ch,$cnt)=($_[0],$_[1]);

   if($cnt==0){return;}
   
   $z=-1;
   for($i=0;$i<7;$i++){if($cpal[$i] eq $ch){$z=$i;}}

   if($z==-1)
   {
      $cpal[$cpalidx]=$ch;
      $cpalidx++;
      if($cpalidx==7){$cpalidx=0;}
      wr((7<<5)|$cnt);
      if($pal{ord($ch)} eq '') { print "/* ERROR - $ch */"; }
      print $pal{ord($ch)}.",";
      $sz+=3;
   }
    else
   {
      wr(($z<<5)|$cnt);
      $sz++;
   }
}

sub bitmap
{
   $bmpname=$_[0];
   $sz=0;

   @colors=split('/',$_[1]);
   foreach(@colors)
   {
      ($ch,$col,$msk)=split(':',$_);
      $pal{ord($ch)}="0x".$col.",0x".$msk;
   }

   @lines=split("\n",$_[2]);
   $xdim=0;$ydim=0;

   foreach(@lines)
   {
      if(length($_)>$xdim) { $xdim=length($_); }
   }

   print "u8*".$bmpname."_pict,".$bmpname."_mask;\n";
   print "u8 ".$bmpname."_cmpr[]={\n";
   $ydim=0;

   @cpal=('','','','','','','');$cpalidx=0;
   $repch="";$repcnt=0;
   foreach(@lines)
   {
      for($x=0;$x<$xdim;$x++)
      {
         $ch=substr($_,$x,1);
         if($ch eq "") { $ch=" "; }

         if($ch eq $repch)
         {
            $repcnt++;
            if($repcnt==31){$repcnt=0;wrrle($repch,31);}
         }
          else
         {
            wrrle($repch,$repcnt);
            $repch=$ch;$repcnt=1;
         }
      }
      $ydim++;
   }
   wrrle($repch,$repcnt);
   print "};\n";
   print "sprite $bmpname ={ $xdim,$ydim,(char*)$sz,$bmpname"."_cmpr};\n\n";

   $spritz .= '&'.$bmpname.',';
}

&bitmap('pwp_sf','x:7f:00/ =:00:ff',<<EOD);
     xxxxxxxxxxx
    xxxxxxxxxxxxx
   xx           xx
  xx             xx
 xx xxx x   x xxx xx
xx  x x x   x x x  xx
xx  x x x x x x x  xx
xx  xxx x x x xxx  xx
xx  x   x x x x    xx
xx  x   x x x x    xx
 xx x   xxxxx x   xx
  xx             xx
   xx           xx
    xxxxxxxxxxxxx
     xxxxxxxxxxx
EOD

&bitmap('esittaa','x:7f:00/ =:00:ff',<<EOD);
                        x  x  x  x  
                x   x               
 xxx   xxx   x xxx xxx  xxxx  xxxx  
x   x x         x   x  x   x x   x  
xxxx   xxx   x  x   x  x   x x   x 
x         x  x  x   x  x   x x   x  
 xxx xxxxx  x  x  xx    xxx   xxx x
EOD

&bitmap('forevisar','x:7f:00/ =:00:ff',<<EOD);
      x  x
      
   xx  xx  x xx  xx  x  x  x  xxx   xxxx  x xx
  x   x  x xx   x  x x  x    x     x   x  xx
  x   x  x x    xxx   x x  x  xxx  x   x  x
xxxxx x  x x    x     x x  x     x x   x  x
  x    xx  x     xxxx  xx x  xxxx   xxx  x
  x
  x                                      
EOD

&bitmap('pelu','n:44:00/-:00:ff/ :00:ff/@:87:00/.:11:82/x:44:00/Z:e6:00/o:ff:00',<<EOD);
--------------------------------
-
-
-
-
          nnnnnnnnnnn
              nn
              nn
     xxxxxxxxxxxxx
         xxxxxxxxxx
         ....ZZZZZZ
         .....@@@@@
         .o...@@@@@
         ....@@@@@@@
         @@@@@@@@@@@
       @@@@@@@@@@@@@
     @@@@@@@@@@@@@@@
              @@@@
     xx    @@@@@@@
     @@@@@@@@@@@@@
       @@@@@@@@@@@
         @@@@@@@@@
         @@@@@@@@@
           @@@@@@
            @@@@@
             @@@@
-
-
-
-
-
-
EOD

&bitmap('piimae','-:00:ff/k:ee:00/ :00:ff/!:66:00/=:7f:00/x:00:00/;:6e:88',<<EOD);
--------------------------------
-
-                 
-
             kkkk
             !!!!
             !!!!         
            !!!;!!        
          !!!!!;!!!!      
         !!!!!!!!!!!!     
        !!!!!!!!!;;;!!    
       !!!!!!!!!!!;;!!!   
       !!!!!!!!!!!!;!!!  
       !!!!!!!!!!!!!!!!
       !!!!!!!!!!!!!!!!
       ================
       =xxxxx==x==x==x=
       =x===x==x==x==xx
       =xxxxx==x==x==x=
       =x======x==x==x=
       =x======x==x==x=
       =x======x==x==x=
       ================
       !!!!!!!!!!!!!!!!
       !!!!!!!!!!!!!!!!
       !!!!!!!!!!!!!!!!
       !!!!!!!!!!!!!!!!
-
-
-
-
-
EOD

&bitmap('taehti','-:44:00/ :44:00/*:6e:00',<<EOD);
--------------------------------
-
-
-          *   *   *
-          ** *** **
-           *******
-           *******
-         ***********
-           *******
-           *******
-          ** *** **
-          *   *   *
-
- 
-   ***   ****  **  ****   ****
-  ** ** **  ** ** **  ** **  **
-  **    **  ** *****  **    **
-  ** ** **  ** ** **  ** **  **
-   ***   ****  **  ****   ****
-
-
-   * * *  * * *  * * *  * * *
-    ***    ***    ***    ***
-   * * *  * * *  * * *  * * *
-         
- 
-    
-   
-       
-          
-
EOD

&bitmap('tankki','z:77:00/ :00:ff/0:00:00/x:88:00',<<EOD);
                   zzzz
                zzzzzzzzzzzzzzzzzzzzzzzzzzz
     zzz zzzz  xxxxxxxxxxx
 zxzxzzzxzzxzxzzzzzzzzzzzzzxzzzxzzzxz
zzxxxxzxxxxzxxxxzxxxxzxxxxzxxxxzxxxxzz
zzx000zx000zx000zx000zx000zx000zx000zz
zzx000zx000zx000zx000zx000zx000zx000zz
EOD

&bitmap('tumpsa','x:88:00/ :00:ff',<<EOD);
   x
   xx
  xxxx
EOD

&bitmap('isanta',' :00:ff/x:44:00/z:02:00/;:77:00/0:00:00/b:19:00/y:6e:00',<<EOD);
                 zzzz
              zzzzzzz    ;;;
                ;;;;;;  ;;;
   xxxxxxx      ;0;;0; ;;;yy
  ;0;;0;        ;;;;;;   bbyy
  ;;;;;;         ;00;  bbbb yy
  yyyyyy      bbbbbbbbbbb
yyyyyyyyyy   bbbbbbbbbbb  
y yyyyyyyyyyy;bbbbbbbbb   
yyyyyyyyyy    bbbbbbbbb   
 yyyyyyyyyy     bbbbbb    
 yyyyyyyyyy     00  00
 yyyyyyyyyy   0000  0000
  000  000    0000  0000
EOD

print <<JOOH;
void decompress_bitmap(u8*dpic,u8*dmask,u8*s,int count)
{
   u8 pal[7],palm[7],palidx=0;
   u8 col,msk,rep,*s1=s+count;

   while(s<s1)
   {
      u8 a=*s++;

      rep=a&31;
      col=a>>5;
      
      if(col==7){pal[palidx]=col=*s++;palm[palidx]=msk=*s++;palidx++;if(palidx==7)palidx=0;}
            else{msk=palm[col];col=pal[col];}

      if(rep)
      for(;rep;rep--){*dpic++=col;*dmask++=msk;}
   }
}
JOOH

print $spritz,"NULL };\n";

print <<JOOH2
void decompress_allbmp()
{
   u8*d,*d2;
   sprite**s=allbmps;
   while(*s)
   {
      d=malloc((*s)->width*(*s)->height*sizeof(u8));
      d2=malloc((*s)->width*(*s)->height*sizeof(u8));
      decompress_bitmap(d,d2,(*s)->mask,(int)((*s)->pict));
      (*s)->pict=d;
      (*s)->mask=d2;
      s++;
   }
}
JOOH2

