// Camera.cpp: implementation of the CCamera class.
// coded by keus mai / juin 2000
//////////////////////////////////////////////////////////////////////

#include "Camera.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCamera::CCamera()
{

}

CCamera::~CCamera()
{

}

void CCamera::Init(char *filename)
{
	hFile = fopen(filename,"r");
	if (!hFile) 
	{
		sprintf(debug,"foirage de l'ouverture de %s",filename);
		MessageBox(NULL,debug,"z",MB_OK);
	}
	rewind (hFile);

	if (GetCamera(hFile))
	{
		Flyto(hFile,"Camera");
		char name[50];
		fscanf(hFile,"%s",&name);
		LoadCamera(name);
	}
	else MessageBox(NULL,"no camera to load !!","z",MB_OK);
	fclose(hFile);
}


void CCamera::MoveCamera(LPDIRECT3DDEVICE7 pd3dDevice,FLOAT fTimeKey)
{
	float deltaKey = fTimeKey - OldTimeKey;
	Frame += int (deltaKey * 71);
	if (Frame >= NbCameraPos) Frame = 0;

	D3DVECTOR vEyePt = Camera[Frame].Position;
	D3DVECTOR vLookatPt = Camera[Frame].Target;
	D3DVECTOR vUpVec    = D3DVECTOR(0.0f, 1.0f, 0.0f);
	D3DMATRIX matView;
	SetViewMatrix( matView, vEyePt, vLookatPt, vUpVec );
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );

	OldTimeKey = fTimeKey;
}

void CCamera::MoveCamera2(LPDIRECT3DDEVICE7 pd3dDevice,FLOAT fTimeKey)
{
	float deltaKey = fTimeKey - fFirstTimeKey;
	Frame = int (deltaKey * 33);
	if (Frame >= NbCameraPos) 
		fFirstTimeKey = timeGetTime() * 0.001f;

	if ((Frame > NbCameraPos) && (Frame < 0))
		Frame = 0;
	D3DVECTOR vEyePt = Camera[Frame].Position;
	D3DVECTOR vLookatPt = Camera[Frame].Target;
	D3DVECTOR vUpVec    = D3DVECTOR(0.0f, 1.0f, 0.0f);
	D3DMATRIX matView;
	SetViewMatrix( matView, vEyePt, vLookatPt, vUpVec );
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );

	CurrentPx = Camera[Frame].Position.dvX;
	CurrentPy = Camera[Frame].Position.dvY;
	CurrentPz = Camera[Frame].Position.dvZ;
}

//////////////////////////////////////////////////////
// LoadCamera(char *name)
// loads a camera whitin a opened TLD file
//////////////////////////////////////////////////////
void CCamera::LoadCamera(char *name)
{
	char temp[50];
	int NbKeyPos;
	float px,py,pz,tx,ty,tz;

	// go to camera called "name"
	Flyto(hFile,name);
	// scan camera FOV 
	fscanf(hFile,"%s",&temp);
	//scan number of key pos
	fscanf(hFile,"%d",&NbKeyPos);
	Camera = new CameraBuffer[NbKeyPos];
	NbCameraPos = NbKeyPos;
	for (int i=0;i<NbKeyPos;i++)
	{
		fscanf(hFile,"%f",&px);
		fscanf(hFile,"%f",&py);
		fscanf(hFile,"%f",&pz);
		fscanf(hFile,"%f",&tx);
		fscanf(hFile,"%f",&ty);
		fscanf(hFile,"%f",&tz);
		Camera[i].Position = D3DVECTOR(px,py,pz);
		Camera[i].Target = D3DVECTOR(tx,ty,tz);
	}
	for(i=0;i<NbKeyPos;i++)
	{
		D3DVECTOR vTempT = Camera[i].Target;
		D3DVECTOR vTempP = Camera[i].Position;
		D3DMath_VectorBugCorrect(Camera[i].Target,vTempT);
		D3DMath_VectorBugCorrect(Camera[i].Position,vTempP);
	}
		
}	



//////////////////////////////////////////////////////
// SLoadCamera(char *name)
// special load a camera whitin a opened TLD file
// no more "flyto" , speeded up , bin implementation possible
//////////////////////////////////////////////////////
void CCamera::SLoadCamera(char *name,FILE *phFile)
{
	char temp[50];
	int NbKeyPos;
	float px,py,pz,tx,ty,tz;

	// scan camera's name 
	fscanf(phFile,"%s",&temp);

	// scan camera FOV 
	fscanf(phFile,"%s",&temp);
	//scan number of key pos
	fscanf(phFile,"%d",&NbKeyPos);
	Camera = new CameraBuffer[NbKeyPos];
	NbCameraPos = NbKeyPos;

	//char c;
	//fscanf(phFile,"%c",&c);
	for (int i=0;i<NbKeyPos;i++)
	{
		fscanf(phFile,"%f",&px);
		fscanf(phFile,"%f",&py);
		fscanf(phFile,"%f",&pz);
		fscanf(phFile,"%f",&tx);
		fscanf(phFile,"%f",&ty);
		fscanf(phFile,"%f",&tz);

		Camera[i].Position = D3DVECTOR(px,py,pz);
		Camera[i].Target = D3DVECTOR(tx,ty,tz);
	}
	for(i=0;i<NbKeyPos;i++)
	{
		D3DVECTOR vTempT = Camera[i].Target;
		D3DVECTOR vTempP = Camera[i].Position;
		D3DMath_VectorBugCorrect(Camera[i].Target,vTempT);
		D3DMath_VectorBugCorrect(Camera[i].Position,vTempP);
	}
		
}	