/*-------------------------------------------------------------------------------------------*\
|                                                                                             |
|    Copyright (C) 1999 by Punk Productions Electronic Entertainment. All Rights Reserved.    | 
|                                                                                             |
|    Purpose.....: Shows how to load JPEG files into a DDsurface                              |
|    Programmer..: Nikolaus Brennig, 19, (Nikolaus.Brennig@nol.at)                            |
|	 Contact.....: virtalnik@nol.at || ICQ: 20345533										  |
|	 Internet....: http://cust.nol.at/ppee													  |
|    Help........: Joine the PPEE-GamesDev MailingList			                              |
|    Day created.: February 17th, 1999                                                        |
|    Update......: March, 30th, 1999                                                          |
|				   Can't remember anymore what i've changed :)								  |
|				   October, 3rd, 1999:														  |
|				   Completely rewritten, Faster Loading/Saving, C++ Interface                 |
|				   now the original JPEGLib 6.2 is used, also Support for                     |
|				   loading PPM/PGM files. Written for DirectX7		                          |
|				   October, 29th, 1999:	      												  |
|				   Fixed a small memorybug in LoadJPEG. Thanks to Fabien Pigre.              |
|				   Also converted the PseudoJPGClass into a NameSpace. Much better here          |
|                                                                                             |
\*-------------------------------------------------------------------------------------------*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>

#define WIDTHBYTES(bits)    (((bits) + 31) / 32 << 2)

namespace JPEG
{
		/*
			Loading:
			~~~~~~~~
		*/
			BYTE *LoadJPEG( 
				LPSTR fileName, 
				UINT *width, 
				UINT *height, 
				INT *Bits  
			); 

			BYTE *LoadPPM(
				LPSTR fileName, 
				UINT *width, 
				UINT *height, 
				INT *Bits
			);

			BYTE *MakeDWORDAligned( 
				BYTE *dataBuf, 
				UINT widthPix, 
				UINT height, 
				UINT *uiOutWidthBytes 
			); 

			BOOL FlipVertically( 
				BYTE *inbuf, 
				UINT widthbytes, 
				UINT height 
			);

			BOOL BGRFromRGB( 
				BYTE *buf, 
				UINT widthPix, 
				UINT height 
			);

		/*
			Saving:
			~~~~~~~
		*/
			BOOL SaveJPEG( 
				LPSTR fileName, 
				BYTE *dataBuf, 
				UINT width, 
				UINT height, 
				BOOL color, 
				int quality 
			);

			BYTE *MakeRGBAligned( 
				BYTE *inBuf, 
				UINT widthPix, 
				UINT widthBytes, 
				UINT height 
			);

			BOOL RGBFromBGR( 
				BYTE *buf, 
				UINT widthPix, 
				UINT height
			);

		/*
			Internal Functions:
			~~~~~~~~~~~~~~~~~~~
		*/
			VOID WriteRGBScanline( 
				BYTE *jpegline, 
				int widthPix, 
				BYTE *outBuf, 
				int row 
			);

			VOID WriteGRAYScanline( 
				BYTE *jpegline, 
				int widthPix, 
				BYTE *outBuf, 
				int row 
			);
};


