/*-------------------------------------------------------------------------------------------*\
|                                                                                             |
|    Copyright (C) 1999 by Punk Productions Electronic Entertainment. All Rights Reserved.    | 
|                                                                                             |
|    Purpose.....: Shows how to load JPEG files into a DDsurface                              |
|    Programmer..: Nikolaus Brennig, 19, (Nikolaus.Brennig@nol.at)                            |
|	 Contact.....: virtalnik@nol.at || ICQ: 20345533										  |
|	 Internet....: http://cust.nol.at/ppee													  |
|    Help........: Joine the PPEE-GamesDev MailingList			                              |
|    Day created.: February 17th, 1999                                                        |
|    Update......: March, 30th, 1999                                                          |
|				   Can't remember anymore what i've changed :)								  |
|				   October, 3rd, 1999:														  |
|				   Completely rewritten, Faster Loading/Saving, C++ Interface                 |
|				   now the original JPEGLib 6.2 is used, also Support for                     |
|				   loading PPM/PGM files. Written for DirectX7		                          |
|				   October, 29th, 1999:	      												  |
|				   Fixed a small memorybug in LoadJPEG. Thanks to Fabien Pigre.              |
|				   Also converted the PseudoJPGClass into a NameSpace. Much better here          |
|                                                                                             |
\*-------------------------------------------------------------------------------------------*/
#define WIN32_LEAN_AND_MEAN
#include "JpgLoader.h"
#include "export.h"


//---------------------------------------------------------------------------------------------
// Local ProtoTypes:
//---------------------------------------------------------------------------------------------
LPDIRECTDRAWSURFACE7 LoadJPG( LPDIRECTDRAW7 lpDD, LPSTR Filename );
LPDIRECTDRAWSURFACE7 LoadPPM( LPDIRECTDRAW7 lpDD, LPSTR Filename );



//---------------------------------------------------------------------------------------------
// A small Wrapper for easier ImageLoading...
// Note: Make sure the "Filename" extension is for JPEGFormat *.jpg, for PPMFormat *.ppm
// and for PGMFormat *.pgm.
//---------------------------------------------------------------------------------------------
LPDIRECTDRAWSURFACE7 GetImage( LPSTR Filename,LPDIRECTDRAW7 lpDD )
{
    LPDIRECTDRAWSURFACE7 Surf = NULL;
    int len = lstrlen( Filename );

	// Load the correct FileType from the extension...
    if( lstrcmpi( Filename+(len-3), "jpg" ) == 0 )
		Surf = LoadJPG( lpDD, Filename );
    else // PGM/PPM
		Surf = LoadPPM( lpDD, Filename );

	// Now do an automatical errorcheck...
    if( Surf == NULL ) 
	{ 
		CHAR *errstr = new CHAR[512];
		sprintf( errstr, "Couldn't load \"%s\"! Check the Directory/Filename.", Filename ); 
		MessageBox(NULL, errstr,"error",MB_OK ); 
		delete errstr;
		return NULL;
	}

	// Yahoo...
	return Surf;
}


//---------------------------------------------------------------------------------------------
// Write a JPEG File...
//---------------------------------------------------------------------------------------------
VOID SaveJPG( LPSTR Filename, LPDIRECTDRAWSURFACE7 lpSurf, INT Quality, BOOL Color )
{
	PBITMAPINFO		pbmi;
	BITMAP			bmp; 
	HBITMAP			hBmp;
	HDC				hdc;
	HDC				MemDC;
	DDSURFACEDESC2	ddsd;
	INT				W, H;
	BYTE			*tmpBuffer = NULL;
	BYTE			*destbuffer = NULL;


	// First get the size of the surface...
	ZeroMemory( &ddsd, sizeof(ddsd) );
	ddsd.dwSize  = sizeof(ddsd);
	ddsd.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;
	lpSurf->GetSurfaceDesc(&ddsd);
	W = ddsd.dwWidth; H = ddsd.dwHeight;

	// Then get the content of the surface into a DC...
	if( SUCCEEDED(lpSurf->GetDC(&hdc)) )
	{
		MemDC = CreateCompatibleDC( NULL );
		hBmp = CreateCompatibleBitmap( hdc, W, H );
		SelectObject( MemDC, hBmp );
		BitBlt( MemDC, 0, 0, W, H, hdc, 0, 0, SRCCOPY );
		lpSurf->ReleaseDC(hdc);
	} 
	else return;

	// Get the important WidthBytes...
	INT			WidthBytes = W*3;
	if(WidthBytes & 0x003) WidthBytes = (WidthBytes | 3) + 1;

	// Bitmapstruct init...
	GetObject( hBmp, sizeof(BITMAP), (LPSTR)&bmp );
	pbmi = (PBITMAPINFO) LocalAlloc(LPTR, sizeof(BITMAPINFOHEADER));
   
	// Initialize the fields in the BITMAPINFO structure.
	pbmi->bmiHeader.biSize                        = sizeof(BITMAPINFOHEADER); 
	pbmi->bmiHeader.biWidth                       = bmp.bmWidth; 
	pbmi->bmiHeader.biHeight                      = bmp.bmHeight; 
	pbmi->bmiHeader.biPlanes                      = bmp.bmPlanes; 
	pbmi->bmiHeader.biBitCount                    = 24; 
	pbmi->bmiHeader.biCompression                 = BI_RGB; 
	pbmi->bmiHeader.biSizeImage                   = WidthBytes * H; 
	pbmi->bmiHeader.biClrImportant                = 0; 

	// Alloc Memory...
	destbuffer = new BYTE[pbmi->bmiHeader.biSizeImage];

	// Get the bits from the DC to save it to disk...
	GetDIBits( MemDC, hBmp, 0, (unsigned int) bmp.bmHeight, destbuffer, pbmi, 0 );

	// un-DWORD-align
	tmpBuffer = JPEG::MakeRGBAligned( destbuffer, bmp.bmWidth, WidthBytes, bmp.bmHeight );

	// vertical flip
	JPEG::FlipVertically( tmpBuffer, WidthBytes, bmp.bmHeight );

	// reverse BGR
	JPEG::RGBFromBGR( tmpBuffer, bmp.bmWidth, bmp.bmHeight );

	// write it
	if( !JPEG::SaveJPEG( Filename, tmpBuffer, bmp.bmWidth, bmp.bmHeight, Color, Quality ) )
		MessageBox(NULL, "Write Error during JPEGWrite!","z",MB_OK );

	// Free the stuff...
	delete tmpBuffer;
	delete destbuffer;
	DeleteObject( hBmp );
	DeleteDC( MemDC );
	LocalFree((PBITMAPINFO)pbmi);

	// Yeah!
	return;
}


//---------------------------------------------------------------------------------------------
// Load a JPG into a DC...
//---------------------------------------------------------------------------------------------
LPDIRECTDRAWSURFACE7 LoadJPG( LPDIRECTDRAW7 lpDD, LPSTR Filename )
{
	UINT				 height;
	UINT				 width;
	BYTE				 *dataBuf;
	PBITMAPINFO			 bmpi;
	HDC					 hDC;
	DDSURFACEDESC2		 ddsd;
	LPDIRECTDRAWSURFACE7 surf;
	INT					 W, H, Bits;

	// Read JPEGData into a buffer...
	dataBuf = JPEG::LoadJPEG( Filename, &width, &height, &Bits );
	if( dataBuf == NULL ) return NULL;

	// Transfer Variables...
	W = width; H = height; Bits = 24;
	INT lineWidth = W * 3;
    if(lineWidth & 0x003) lineWidth = (lineWidth | 3) + 1;

	// Create the DirectDraw Surface...
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize          = sizeof(ddsd);
	ddsd.dwFlags         = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH;//|DDSD_TEXTURESTAGE;
                           //DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps  = DDSCAPS_OFFSCREENPLAIN ;//| DDSCAPS_TEXTURE ;
	ddsd.dwWidth         = W;
	ddsd.dwHeight        = H;
	//ddsd.ddpfPixelFormat.dwRGBBitCount = 24;
	if( FAILED(lpDD->CreateSurface( &ddsd, &surf, NULL )) )
	{
		return NULL;
		MessageBox(NULL,"create surf JPG foir","z",MB_OK);
	}
	    
       
	// Init the Bitmapstruct...
    bmpi = (PBITMAPINFO) LocalAlloc(LPTR, sizeof(BITMAPINFOHEADER) + (256 * sizeof(RGBQUAD)));
	bmpi->bmiHeader.biSize				= sizeof(BITMAPINFOHEADER);
	bmpi->bmiHeader.biWidth				= W;
	bmpi->bmiHeader.biHeight			= H;
	bmpi->bmiHeader.biPlanes			= 1;
	bmpi->bmiHeader.biCompression       = BI_RGB; 
	bmpi->bmiHeader.biBitCount			= Bits;
	bmpi->bmiHeader.biSizeImage			= 0;
	bmpi->bmiHeader.biClrUsed			= 0; 
	bmpi->bmiHeader.biClrImportant		= 0; 

	// Blt the stuff now...
	if( SUCCEEDED(surf->GetDC(&hDC)) )
	{
		StretchDIBits( hDC, 0, 0, W, H, 0, 0, W, H, dataBuf, bmpi, 0, SRCCOPY );
		surf->ReleaseDC(hDC);
	}

	// free the stuff...
	delete dataBuf;
	LocalFree((PBITMAPINFO)bmpi);

	// Yahoo...
	return surf;
}

static HRESULT CALLBACK TextureSearchCallback32( DDPIXELFORMAT* pddpf,
                                               VOID* param )
{
    // Note: Return with DDENUMRET_OK to continue enumerating more formats.

    // Skip any funky modes
    if( pddpf->dwFlags & (DDPF_LUMINANCE|DDPF_BUMPLUMINANCE|DDPF_BUMPDUDV) )
        return DDENUMRET_OK;
    
    // Skip any FourCC formats
    if( pddpf->dwFourCC != 0 )
        return DDENUMRET_OK;

    // Skip alpha modes
    if( pddpf->dwFlags&DDPF_ALPHAPIXELS )
        return DDENUMRET_OK;

    // We only want 32-bit formats, so skip all others
    if( pddpf->dwRGBBitCount != 32 )
        return DDENUMRET_OK;

    // We found a good match. Copy the current pixel format to our output
    // parameter
    memcpy( (DDPIXELFORMAT*)param, pddpf, sizeof(DDPIXELFORMAT) );

    // Return with DDENUMRET_CANCEL to end enumeration.
    return DDENUMRET_CANCEL;
}


static HRESULT CALLBACK TextureSearchCallback16( DDPIXELFORMAT* pddpf,
                                               VOID* param )
{
    // Note: Return with DDENUMRET_OK to continue enumerating more formats.

    // Skip any funky modes
    if( pddpf->dwFlags & (DDPF_LUMINANCE|DDPF_BUMPLUMINANCE|DDPF_BUMPDUDV) )
        return DDENUMRET_OK;
    
    // Skip any FourCC formats
    if( pddpf->dwFourCC != 0 )
        return DDENUMRET_OK;

    // Skip alpha modes
    if( pddpf->dwFlags&DDPF_ALPHAPIXELS )
        return DDENUMRET_OK;

    // We only want 16-bit formats, so skip all others
    if( pddpf->dwRGBBitCount != 16 )
        return DDENUMRET_OK;

    // We found a good match. Copy the current pixel format to our output
    // parameter
    memcpy( (DDPIXELFORMAT*)param, pddpf, sizeof(DDPIXELFORMAT) );

    // Return with DDENUMRET_CANCEL to end enumeration.
    return DDENUMRET_CANCEL;
}


static LPDIRECTDRAWSURFACE7 CreateSurfaceTexture( LPDIRECT3DDEVICE7 pd3dDevice,
												DWORD dwWidth, 
												DWORD dwHeight)
{
    LPDIRECTDRAWSURFACE7 pddsTexture;
    HRESULT hr;

    // Get the device caps so we can check if the device has any constraints
    // when using textures
    D3DDEVICEDESC7 ddDesc;
    if( FAILED( pd3dDevice->GetCaps( &ddDesc ) ) )
        return NULL;

    // Get the bitmap structure (to extract width, height, and bpp)
//    BITMAP bm;
//  GetObject( hbm, sizeof(BITMAP), &bm );
//    DWORD dwWidth  = (DWORD)bm.bmWidth;
//    DWORD dwHeight = (DWORD)bm.bmHeight;

    // Setup the new surface desc for the texture. Note how we are using the
    // texture manage attribute, so Direct3D does alot of dirty work for us
    DDSURFACEDESC2 ddsd;
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
    ddsd.dwSize          = sizeof(DDSURFACEDESC2);
    ddsd.dwFlags         = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH|
                           DDSD_PIXELFORMAT|DDSD_TEXTURESTAGE;
    ddsd.ddsCaps.dwCaps  = DDSCAPS_TEXTURE;
    ddsd.dwWidth         = dwWidth;
    ddsd.dwHeight        = dwHeight;

    // Turn on texture management for hardware devices
    if( ddDesc.deviceGUID == IID_IDirect3DHALDevice )
        ddsd.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    else if( ddDesc.deviceGUID == IID_IDirect3DTnLHalDevice )
        ddsd.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    else
        ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

    // Adjust width and height, if the driver requires it
    if( ddDesc.dpcTriCaps.dwTextureCaps & D3DPTEXTURECAPS_POW2 )
    {
        for( ddsd.dwWidth=1;  dwWidth>ddsd.dwWidth;   ddsd.dwWidth<<=1 );
        for( ddsd.dwHeight=1; dwHeight>ddsd.dwHeight; ddsd.dwHeight<<=1 );
    }
    if( ddDesc.dpcTriCaps.dwTextureCaps & D3DPTEXTURECAPS_SQUAREONLY )
    {
        if( ddsd.dwWidth > ddsd.dwHeight ) ddsd.dwHeight = ddsd.dwWidth;
        else                               ddsd.dwWidth  = ddsd.dwHeight;
    }

	// enumerate texture caps,first try 32bits texture
	// then 16bits if failed
	pd3dDevice->EnumTextureFormats( TextureSearchCallback32, &ddsd.ddpfPixelFormat );
	if( 0L == ddsd.ddpfPixelFormat.dwRGBBitCount )
	{
		pd3dDevice->EnumTextureFormats( TextureSearchCallback16, &ddsd.ddpfPixelFormat );
		if( 0L == ddsd.ddpfPixelFormat.dwRGBBitCount )
			return NULL;
	}

    // Get the device's render target, so we can then use the render target to
    // get a ptr to a DDraw object. We need the DirectDraw interface for
    // creating surfaces.
    LPDIRECTDRAWSURFACE7 pddsRender;
    LPDIRECTDRAW7        pDD;
    pd3dDevice->GetRenderTarget( &pddsRender );
    pddsRender->GetDDInterface( (VOID**)&pDD );
    pddsRender->Release();

    // Create a new surface for the texture
    if( FAILED( hr = pDD->CreateSurface( &ddsd, &pddsTexture, NULL ) ) )
    {
        pDD->Release();
        return NULL;
    }

    // Done with DDraw
    pDD->Release();

    // Now, copy the bitmap to the texture surface. To do this, we are creating
    // a DC for the bitmap and a DC for the surface, so we can use the BitBlt()
    // call to copy the actual bits.

    // Get a DC for the bitmap
    HDC hdcBitmap = CreateCompatibleDC( NULL );
    if( NULL == hdcBitmap )
    {
        pddsTexture->Release();
        return NULL;
    }
    /*SelectObject( hdcBitmap, hbm );

    // Get a DC for the surface
    HDC hdcTexture;
    if( SUCCEEDED( pddsTexture->GetDC( &hdcTexture ) ) )
    {
        // Copy the bitmap image to the surface.
        BitBlt( hdcTexture, 0, 0, bm.bmWidth, bm.bmHeight, hdcBitmap,
                0, 0, SRCCOPY );
        pddsTexture->ReleaseDC( hdcTexture );
    }*/
    DeleteDC( hdcBitmap );

    // Return the newly created texture
    return pddsTexture;
}


////////////////////////////////////////////////////////
//---------------------------------------------------------------------------------------------
LPDIRECTDRAWSURFACE7 LoadJPGTexture( LPDIRECT3DDEVICE7 pd3dDevice, LPSTR Filename )
{
	LPDIRECTDRAWSURFACE7 surf;
	DDSURFACEDESC2 ddsd;
	DWORD DestWidth,DestHeight;

	LPDIRECTDRAWSURFACE7 TempSurf;
	LPDIRECTDRAWSURFACE7 pddsRender;
	LPDIRECTDRAW7 pDD;
    pd3dDevice->GetRenderTarget( &pddsRender );
    pddsRender->GetDDInterface( (VOID**)&pDD );
    pddsRender->Release();

	TempSurf = LoadJPG(pDD,Filename);
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
    ddsd.dwSize = sizeof(DDSURFACEDESC2);
	TempSurf->GetSurfaceDesc(&ddsd);

    D3DDEVICEDESC7 ddDesc;
    if( FAILED( pd3dDevice->GetCaps( &ddDesc ) ) )
        return NULL;
	// check texture size 
	if (ddsd.dwWidth > ddDesc.dwMaxTextureWidth )
		DestWidth = ddDesc.dwMaxTextureWidth;
	else DestWidth = ddsd.dwWidth;

	if (ddsd.dwHeight > ddDesc.dwMaxTextureHeight )
		DestHeight = ddDesc.dwMaxTextureHeight;
	else DestHeight = ddsd.dwHeight;

	// Create the D3D Texture
	surf = CreateSurfaceTexture(pd3dDevice,DestWidth,DestHeight);

	surf->Blt(NULL,TempSurf,NULL,DDBLT_WAIT ,NULL);
       
	TempSurf->Release();
	// Yahoo...
	return surf;
}

//---------------------------------------------------------------------------------------------
// Load a PPM/PGM into a DC...
//---------------------------------------------------------------------------------------------
LPDIRECTDRAWSURFACE7 LoadPPM( LPDIRECTDRAW7 lpDD, LPSTR Filename )
{
	UINT				 height;
	UINT				 width;
	BYTE				 *dataBuf;
	PBITMAPINFO			 bmpi;
	HDC					 hDC;
	DDSURFACEDESC2		 ddsd;
	LPDIRECTDRAWSURFACE7 surf;
	INT					 W, H, Bits;

	// Read the PPM/PGM Data into our Buffer...
	dataBuf = JPEG::LoadPPM( Filename, &width, &height, &Bits );
	if( dataBuf == NULL ) return NULL;

	// Transfer Variables...
	W = width; H = height; Bits = 24;
	INT lineWidth = W * 3;
    if(lineWidth & 0x003) lineWidth = (lineWidth | 3) + 1;

	// Create the DirectDraw Surface...
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize          = sizeof(ddsd);
	ddsd.dwFlags         = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps  = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth         = W;
	ddsd.dwHeight        = H;
	if( FAILED(lpDD->CreateSurface( &ddsd, &surf, NULL )) ) return NULL;
       
	// Init the Bitmapstruct...
    bmpi = (PBITMAPINFO) LocalAlloc(LPTR, sizeof(BITMAPINFOHEADER) + (256 * sizeof(RGBQUAD)));
	bmpi->bmiHeader.biSize				= sizeof(BITMAPINFOHEADER);
	bmpi->bmiHeader.biWidth				= W;
	bmpi->bmiHeader.biHeight			= H;
	bmpi->bmiHeader.biPlanes			= 1;
	bmpi->bmiHeader.biCompression       = BI_RGB; 
	bmpi->bmiHeader.biBitCount			= Bits;
	bmpi->bmiHeader.biSizeImage			= 0;
	bmpi->bmiHeader.biClrUsed			= 0; 
	bmpi->bmiHeader.biClrImportant		= 0; 

	// Blt the stuff now...
	if( SUCCEEDED(surf->GetDC(&hDC)) )
	{
		StretchDIBits( hDC, 0, 0, W, H, 0, 0, W, H, dataBuf, bmpi, 0, SRCCOPY );
		surf->ReleaseDC(hDC);
	}

	// free the stuff...
	delete dataBuf;
	LocalFree((PBITMAPINFO)bmpi);

	// Yahoo...
	return surf;
}
