// Implementation of a class that allow you to manage 3D Objects
// coded by keus juin 2000
//////////////////////////////////////////////////////////////////////
#define D3D_OVERLOADS

#include "TLDutils.h"
//#include "TLDImport.h"
#include "D3DUtil.h"
#include "AlphaLayer.h"

struct VertexBuffer1
{
	float vx;
	float vy;
	float vz;
	float nx;
	float ny;
	float nz;
};

struct TVertexBuffer1
{
	float tx;
	float ty;
};

/*struct CameraBuffer
{
	D3DVECTOR Target;
	D3DVECTOR Position;
};*/


///////////////////////////////////////////////////////////////////////
// load OBJ
///////////////////////////////////////////////////////////////////////
void CAlphaLayer::LoadObject(char *name)
{
	VertexBuffer1* VertexBuffer;
	TVertexBuffer1* TVertexBuffer;
	char temp[30];
	bool mapped;
	float vx,vy,vz,u,v,nx,ny,nz;
	int Vertex1,Vertex2,Vertex3,NbObjVertex,NbObjFaces,NbObjTVerts;
	int TVertex1,TVertex2,TVertex3;

	Flyto(hFile,name);

	fscanf(hFile,"%s",&temp);
	if (strcmp(temp,"noUV") == 0) mapped = FALSE;
	if (strcmp(temp,"UV") == 0)    mapped = TRUE;


	//sprintf(temp,"%sVertexList",name);
	//Flyto(hFile,temp);
	fscanf(hFile,"%s",&temp);
	fscanf(hFile,"%d",&NbObjVertex);
	VertexBuffer = new VertexBuffer1[NbObjVertex];
	for(int i=0;i<NbObjVertex;i++)
	{

		fscanf(hFile,"%f",&vx);
		fscanf(hFile,"%f",&vy);
		fscanf(hFile,"%f",&vz);
		fscanf(hFile,"%f",&nx);
		fscanf(hFile,"%f",&ny);
		fscanf(hFile,"%f",&nz);
		VertexBuffer[i].vx = vx;
		VertexBuffer[i].vy = vy;
		VertexBuffer[i].vz = vz;
		VertexBuffer[i].nx = nx;
		VertexBuffer[i].ny = ny;
		VertexBuffer[i].nz = nz;
	}

	if (mapped == TRUE)
	{
		//sprintf(temp,"%sTVertslist",name);
		//Flyto(hFile,temp);
		fscanf(hFile,"%s",&temp);
		fscanf(hFile,"%d",&NbObjTVerts);
		TVertexBuffer = new TVertexBuffer1[NbObjTVerts];
		float tx,ty;
		for (i=0;i<NbObjTVerts;i++)
		{
			fscanf(hFile,"%f",&tx);
			fscanf(hFile,"%f",&ty);
			//fscanf(hFile,"%f",&tz);
			TVertexBuffer[i].tx = tx;
			TVertexBuffer[i].ty = ty;
		}
	}
	

	//sprintf(temp,"%sFacelist",name);
	//Flyto(hFile,temp);	
	fscanf(hFile,"%s",&temp);
	fscanf(hFile,"%d",&NbObjFaces);
	Obj = new D3DVERTEX[(NbObjFaces * 3)];
	m_NbObjVertex = (NbObjFaces * 3);
	m_NbObjFaces = NbObjFaces;
	for (i=0;i<NbObjFaces;i++)
	{
		
		fscanf(hFile,"%d",&Vertex1);
		fscanf(hFile,"%d",&Vertex2);
		fscanf(hFile,"%d",&Vertex3);
		if (mapped == TRUE)
		{
			fscanf(hFile,"%d",&TVertex1);
			fscanf(hFile,"%d",&TVertex2);
			fscanf(hFile,"%d",&TVertex3);
		}

		vx = VertexBuffer[Vertex1].vx;
		vy = VertexBuffer[Vertex1].vy;
		vz = VertexBuffer[Vertex1].vz;
		if (mapped == TRUE)
		{
			u = TVertexBuffer[TVertex1].tx;
			v = TVertexBuffer[TVertex1].ty;
		}
		if (mapped == FALSE ) 
		{
			u = 0.0f;
			v = 0.0f;
		}
		nx = VertexBuffer[Vertex1].nx;
		ny = VertexBuffer[Vertex1].ny;
		nz = VertexBuffer[Vertex1].nz;
		D3DVECTOR Ver1 =  D3DVECTOR (vx,vy,vz);
		Obj[i*3]=D3DVERTEX(Ver1,D3DVECTOR(nx,ny,nz), u, v);


		vx = VertexBuffer[Vertex2].vx;
		vy = VertexBuffer[Vertex2].vy;
		vz = VertexBuffer[Vertex2].vz;
		if (mapped == TRUE)
		{
			u = TVertexBuffer[TVertex2].tx;
			v = TVertexBuffer[TVertex2].ty;
		}
		if (mapped == FALSE ) 
		{
			u = 0.0f;
			v = 0.0f;
		}
		nx = VertexBuffer[Vertex2].nx;
		ny = VertexBuffer[Vertex2].ny;
		nz = VertexBuffer[Vertex2].nz;
		D3DVECTOR Ver2 =  D3DVECTOR (vx,vy,vz);
		Obj[i*3+1]=D3DVERTEX(Ver2,D3DVECTOR(nx,ny,nz), u, v);


		vx = VertexBuffer[Vertex3].vx;
		vy = VertexBuffer[Vertex3].vy;
		vz = VertexBuffer[Vertex3].vz;
		if (mapped == TRUE)
		{
			u = TVertexBuffer[TVertex3].tx;
			v = TVertexBuffer[TVertex3].ty;
		}
		if (mapped == FALSE ) 
		{
			u = 0.0f;
			v = 0.0f;
		}
		nx = VertexBuffer[Vertex3].nx;
		ny = VertexBuffer[Vertex3].ny;
		nz = VertexBuffer[Vertex3].nz;
		D3DVECTOR Ver3 =  D3DVECTOR (vx,vy,vz);
		Obj[i*3+2]=D3DVERTEX(Ver3,D3DVECTOR(nx,ny,nz), u, v);

	}

	for (i=0;i<(NbObjFaces * 3);i++) 
	{
		D3DVERTEX Vtemp = Obj[i];
		D3DMath_VertexBugCorrect(Obj[i],Vtemp);
	}

	//delete [] Obj;
}

void CAlphaLayer::LoadObjectO(LPDIRECT3DDEVICE7 pd3dDevice,FILE* phFile, char *name)
{
	VertexBuffer1* VertexBuffer;
	TVertexBuffer1* TVertexBuffer;
	char temp[30];
	bool mapped;
	float vx,vy,vz,u,v,nx,ny,nz;
	int Vertex1,Vertex2,Vertex3,NbObjVertex,NbObjFaces,NbObjTVerts;
	int TVertex1,TVertex2,TVertex3;

	//Flyto(phFile,name);

	fscanf(phFile,"%s",&temp);
	if (strcmp(temp,"noUV") == 0) mapped = FALSE;
	if (strcmp(temp,"UV") == 0)    mapped = TRUE;


	//sprintf(temp,"%sVertexList",name);
	//Flyto(hFile,temp);
	fscanf(phFile,"%s",&temp);
	fscanf(phFile,"%d",&NbObjVertex);
	VertexBuffer = new VertexBuffer1[NbObjVertex];
	for(int i=0;i<NbObjVertex;i++)
	{

		fscanf(phFile,"%f",&vx);
		fscanf(phFile,"%f",&vy);
		fscanf(phFile,"%f",&vz);
		fscanf(phFile,"%f",&nx);
		fscanf(phFile,"%f",&ny);
		fscanf(phFile,"%f",&nz);
		VertexBuffer[i].vx = vx;
		VertexBuffer[i].vy = vy;
		VertexBuffer[i].vz = vz;
		VertexBuffer[i].nx = nx;
		VertexBuffer[i].ny = ny;
		VertexBuffer[i].nz = nz;
	}

	if (mapped == TRUE)
	{
		//sprintf(temp,"%sTVertslist",name);
		//Flyto(hFile,temp);
		fscanf(phFile,"%s",&temp);
		fscanf(phFile,"%d",&NbObjTVerts);
		TVertexBuffer = new TVertexBuffer1[NbObjTVerts];
		float tx,ty;
		for (i=0;i<NbObjTVerts;i++)
		{
			/*fread(&tx,sizeof(float),1,phFile);
			fread(&ty,sizeof(float),1,phFile);
			char debug[360];
			sprintf(debug,"tvert n%d tx=%f ty=%f",i,tx,ty);
			MessageBox(NULL,debug,"z",MB_OK);*/

			fscanf(phFile,"%f",&tx);
			fscanf(phFile,"%f",&ty);

			/*float btx,bty;
			char c;
			fscanf(phFile,"%c",&c);
			fread(&btx,sizeof(float),1,phFile);
			fread(&bty,sizeof(float),1,phFile);
			char debug[360];
			sprintf(debug,"tvert n%d tx=%f ty=%f\nbtx=%f bty=%f",i,tx,ty,btx,bty);
			MessageBox(NULL,debug,"z",MB_OK);*/

			TVertexBuffer[i].tx = tx;
			TVertexBuffer[i].ty = ty;
		}
	}
	
	//sprintf(temp,"%sFacelist",name);
	//Flyto(phFile,temp);	
	fscanf(phFile,"%s",&temp);
	fscanf(phFile,"%d",&NbObjFaces);
	Obj = new D3DVERTEX[(NbObjFaces * 3)];
	m_NbObjVertex = (NbObjFaces * 3);
	m_NbObjFaces = NbObjFaces;
	for (i=0;i<NbObjFaces;i++)
	{
		fscanf(phFile,"%d",&Vertex1);
		fscanf(phFile,"%d",&Vertex2);
		fscanf(phFile,"%d",&Vertex3);
		if (mapped == TRUE)
		{
			fscanf(phFile,"%d",&TVertex1);
			fscanf(phFile,"%d",&TVertex2);
			fscanf(phFile,"%d",&TVertex3);
		}

		vx = VertexBuffer[Vertex1].vx;
		vy = VertexBuffer[Vertex1].vy;
		vz = VertexBuffer[Vertex1].vz;
		if (mapped == TRUE)
		{
			u = TVertexBuffer[TVertex1].tx;
			v = TVertexBuffer[TVertex1].ty;
		}
		if (mapped == FALSE ) 
		{
			u = 0.0f;
			v = 0.0f;
		}
		nx = VertexBuffer[Vertex1].nx;
		ny = VertexBuffer[Vertex1].ny;
		nz = VertexBuffer[Vertex1].nz;
		D3DVECTOR Ver1 =  D3DVECTOR (vx,vy,vz);
		Obj[i*3]=D3DVERTEX(Ver1,D3DVECTOR(nx,ny,nz), u, v);


		vx = VertexBuffer[Vertex2].vx;
		vy = VertexBuffer[Vertex2].vy;
		vz = VertexBuffer[Vertex2].vz;
		if (mapped == TRUE)
		{
			u = TVertexBuffer[TVertex2].tx;
			v = TVertexBuffer[TVertex2].ty;
		}
		if (mapped == FALSE ) 
		{
			u = 0.0f;
			v = 0.0f;
		}
		nx = VertexBuffer[Vertex2].nx;
		ny = VertexBuffer[Vertex2].ny;
		nz = VertexBuffer[Vertex2].nz;
		D3DVECTOR Ver2 =  D3DVECTOR (vx,vy,vz);
		Obj[i*3+1]=D3DVERTEX(Ver2,D3DVECTOR(nx,ny,nz), u, v);


		vx = VertexBuffer[Vertex3].vx;
		vy = VertexBuffer[Vertex3].vy;
		vz = VertexBuffer[Vertex3].vz;
		if (mapped == TRUE)
		{
			u = TVertexBuffer[TVertex3].tx;
			v = TVertexBuffer[TVertex3].ty;
		}
		if (mapped == FALSE ) 
		{
			u = 0.0f;
			v = 0.0f;
		}
		nx = VertexBuffer[Vertex3].nx;
		ny = VertexBuffer[Vertex3].ny;
		nz = VertexBuffer[Vertex3].nz;
		D3DVECTOR Ver3 =  D3DVECTOR (vx,vy,vz);
		Obj[i*3+2]=D3DVERTEX(Ver3,D3DVECTOR(nx,ny,nz), u, v);

	}

	for (i=0;i<(NbObjFaces * 3);i++) 
	{
		D3DVERTEX Vtemp = Obj[i];
		D3DMath_VertexBugCorrect(Obj[i],Vtemp);
	}

	FakeVertexBuffer = new D3DVERTEX[m_NbObjVertex];
	UpdateFVB(Obj);
	//delete [] Obj;
}


///////////////////////////////////////////////////////////////////////
// create VB
///////////////////////////////////////////////////////////////////////
HRESULT CAlphaLayer::CreateVertexBuffer(LPDIRECT3DDEVICE7 pd3dDevice)
{
    if( NULL == VertexBuffer )
    {
        // Create the vertex buffer.
        D3DVERTEXBUFFERDESC vbdesc;
        ZeroMemory( &vbdesc, sizeof(D3DVERTEXBUFFERDESC) );
        vbdesc.dwSize        = sizeof(D3DVERTEXBUFFERDESC);
        vbdesc.dwCaps        = 0L;
        vbdesc.dwFVF         = D3DFVF_VERTEX;
        vbdesc.dwNumVertices = m_NbObjVertex;

        // If the device does not support transform and lighting in hardware,
        // make sure the vertex buffers end up in system memory.
        //if( IID_IDirect3DTnLHalDevice != (*m_pDeviceInfo->pDeviceGUID) )
		// TODO : check TnL if present load in VRAM
	    D3DDEVICEDESC7 ddDesc;
	    if( FAILED( pd3dDevice->GetCaps( &ddDesc ) ) )
		    return NULL;
		if( ddDesc.deviceGUID != IID_IDirect3DTnLHalDevice )
	        vbdesc.dwCaps |= D3DVBCAPS_SYSTEMMEMORY;

		LPDIRECT3D7 pD3D = NULL;
		pd3dDevice->GetDirect3D( &pD3D);

        if( FAILED( pD3D->CreateVertexBuffer( &vbdesc, &VertexBuffer, 0L ) ) )
            return E_FAIL;
    }
    return S_OK;
}


////////////////////////////////////////////////////////////////////
// release vB
////////////////////////////////////////////////////////////////////
void CAlphaLayer::Release()
{
	if (VertexBuffer)	VertexBuffer->Release();
}
