/*===========================================================================================*\
|                                                                                             |
|    Copyright (C) 1999 by Punk Productions Electronic Entertainment. All Rights Reserved.    | 
|                                                                                             |
|    Purpose.....: Shows how to load and save PNG files with DD                               |
|    Programmer..: Nikolaus Brennig, 18, (Nikolaus.Brennig@nol.at)                            |
|    Help........: Join the PPEE-GamesDev Mailinglist!										  |
|    Internet....: http://cust.nol.at/ppee													  |
|    Day created.: August 07th, 1999                                                          |
|    Update......: October 3rd, 1999														  |
|				   Thanks to Tobias Lensing for finding a PNGSaveing Bug. It got fixed.		  |
|				   September 27th, 1999                                                       |
|				   Fixed small bug with 8bit PNGs containing Alpha.							  |
|				   August 11th, 1999                                                          |
|				   PNGLoading should now work fully correct on NT too.		                  |
|				   August 08th, 1999                                                          |
|				   32Bit PNG's are now loaded correct.		                                  |
|                                                                                             |
\*===========================================================================================*/
#define WIN32_LEAN_AND_MEAN
//#include "PNGTest.h"
#include <png.h>
#include <ddraw.h>
#include <d3d.h>

//---------------------------------------------------------------------------------------------
// Load a PNG File with PNGLib v1.03...
// Note: This Loader is only useful for displaying the content in a PNG file.
// For Example it doesn't handle Alpha. If Alpha is present in a PNG, it simply gets 
// ignored (or not :)), but never used. Furthermore, it doesn't use predefined BackgroundColors, 
// that may be found in a PNG file, indeed, it uses the default background (normally black).
//---------------------------------------------------------------------------------------------
LPDIRECTDRAWSURFACE7 LoadPNG( LPDIRECTDRAW7 pdd, LPSTR Filename )
{
	png_structp				png_ptr;
	png_infop				info_ptr;
	png_uint_32				width, height;
	FILE					*fp;
	INT						bit_depth, color_type, interlace_type;
	INT						W, H;
	INT						row;
	BITMAPINFO				bmpi;
	DDSURFACEDESC2			ddsd;
	HDC						hDC;
	LPDIRECTDRAWSURFACE7	pdds;
	INT						BltBits;


	// Open the file...
	if( (fp = fopen(Filename, "rb")) == NULL )
		return NULL;

	// Allocate/initialize the memory for image readpointerstruct...
	png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	if (png_ptr == NULL)
	{
		fclose(fp);
		return NULL;
	}

	// Allocate/initialize the memory for image information...
	info_ptr = png_create_info_struct(png_ptr);
	if( info_ptr == NULL )
	{
		fclose(fp);
		png_destroy_read_struct(&png_ptr, (png_infopp)NULL, (png_infopp)NULL);
		return NULL;
	}

	// Set error handling if you are using the setjmp/longjmp method (this is
	// the normal method of doing things with libpng).  REQUIRED unless you
    // set up your own error handlers in the png_create_read_struct() earlier.
	if( setjmp(png_ptr->jmpbuf) )
	{
		png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
		fclose(fp);
		return NULL;
	}

	// Set up the input control if you are using standard C streams...
	png_init_io(png_ptr, fp);

	// The call to png_read_info() gives us all of the information from the
	// PNG file before the first IDAT (image data chunk).
	png_read_info(png_ptr, info_ptr);

	// Get the Headerinfo...
	png_get_IHDR(png_ptr, info_ptr, &width, &height, &bit_depth, &color_type,
		&interlace_type, NULL, NULL);
	W = width; H = height;

	// Check the format...
	switch( color_type )
    {
		case PNG_COLOR_TYPE_RGB:
			BltBits = 24;
			break;
      
		case PNG_COLOR_TYPE_RGB_ALPHA:
			BltBits = 32;
			break;
      
		case PNG_COLOR_TYPE_GRAY:
			png_set_gray_to_rgb(png_ptr);
			png_set_expand(png_ptr);
			BltBits = 24;
			break;
      
		case PNG_COLOR_TYPE_GRAY_ALPHA:
			png_set_gray_to_rgb(png_ptr);
			png_set_expand(png_ptr);
			BltBits = 32;
			break;
		
		case PNG_COLOR_TYPE_PALETTE:
			png_set_expand(png_ptr);
			png_set_strip_alpha(png_ptr);
			BltBits = 24;
			break;
	}

	// flip the RGB pixels to BGR Order...
    png_set_bgr(png_ptr);

	// Tell LibPNG to hanlde 16bit planes as normal 8bit planes...
    if( bit_depth == 16 ) png_set_strip_16(png_ptr);

	// shit, forgot what this does, but its useful...
    if( bit_depth < 8 )	png_set_packing(png_ptr);

	// Update the PNGLibLoader...
	png_read_update_info(png_ptr, info_ptr);

	// Allocate the memory to hold the image using the fields of info_ptr...
	png_bytep *row_pointers = new png_bytep[H];
	for( row = 0; row < H; row++)
		row_pointers[row] = new BYTE[png_get_rowbytes(png_ptr, info_ptr)];

	// The easiest way to read the image...
	png_read_image(png_ptr, row_pointers);

	// Create the DirectDraw Surface...
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize          = sizeof(ddsd);
	ddsd.dwFlags         = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	ddsd.ddsCaps.dwCaps  = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth         = W;
	ddsd.dwHeight        = H;
	if( FAILED(pdd->CreateSurface( &ddsd, &pdds, NULL )) ) return NULL;

	// Init our Bitmapstruct for one row...
	ZeroMemory( &bmpi, sizeof(bmpi) );
	bmpi.bmiHeader.biSize        = sizeof(bmpi.bmiHeader);
	bmpi.bmiHeader.biWidth       = W;
	bmpi.bmiHeader.biHeight      = 1;
	bmpi.bmiHeader.biPlanes      = 1;
	bmpi.bmiHeader.biBitCount    = BltBits;
	bmpi.bmiHeader.biCompression = BI_RGB;

	// Now blt row by row and vertically flip it...
	row = 0;
	if( SUCCEEDED(pdds->GetDC(&hDC)) )
	{
		do
		{
			StretchDIBits( hDC, 0, row, W, 1, 0, 0, W, 1, row_pointers[row], &bmpi, 0, SRCCOPY );
		}
		while( ++row < H );
		
		pdds->ReleaseDC(hDC);
	}

	// read rest of file, and get additional chunks in info_ptr...
	png_read_end(png_ptr, info_ptr);

	// clean up after the read, and free any memory allocated...
	png_destroy_read_struct(&png_ptr, &info_ptr, (png_infopp)NULL);
	for( row = 0; row < H; row++) delete row_pointers[row];
	delete row_pointers;
	fclose(fp);

	// Return the surface...
	return pdds;
}




////////////////////////////////////////
// D3D TEXTURE loading utility ////////
// added by keus : 30/06/2000  ///////
/////////////////////////////////////

static HRESULT CALLBACK TextureSearchCallback16( DDPIXELFORMAT* pddpf,
                                               VOID* param )
{
    // Note: Return with DDENUMRET_OK to continue enumerating more formats.

    // Skip any funky modes
    if( pddpf->dwFlags & (DDPF_LUMINANCE|DDPF_BUMPLUMINANCE|DDPF_BUMPDUDV) )
        return DDENUMRET_OK;
    
    // Skip any FourCC formats
    if( pddpf->dwFourCC != 0 )
        return DDENUMRET_OK;

    // Skip alpha modes
    if( pddpf->dwFlags&DDPF_ALPHAPIXELS )
        return DDENUMRET_OK;

    // We only want 16-bit formats, so skip all others
    if( pddpf->dwRGBBitCount != 16 )
        return DDENUMRET_OK;

    // We found a good match. Copy the current pixel format to our output
    // parameter
    memcpy( (DDPIXELFORMAT*)param, pddpf, sizeof(DDPIXELFORMAT) );

    // Return with DDENUMRET_CANCEL to end enumeration.
    return DDENUMRET_CANCEL;
}


static LPDIRECTDRAWSURFACE7 CreateSurfaceTexture( LPDIRECT3DDEVICE7 pd3dDevice,
												DWORD dwWidth, 
												DWORD dwHeight)
{
    LPDIRECTDRAWSURFACE7 pddsTexture;
    HRESULT hr;

    // Get the device caps so we can check if the device has any constraints
    // when using textures
    D3DDEVICEDESC7 ddDesc;
    if( FAILED( pd3dDevice->GetCaps( &ddDesc ) ) )
        return NULL;

    // Get the bitmap structure (to extract width, height, and bpp)
//    BITMAP bm;
//  GetObject( hbm, sizeof(BITMAP), &bm );
//    DWORD dwWidth  = (DWORD)bm.bmWidth;
//    DWORD dwHeight = (DWORD)bm.bmHeight;

    // Setup the new surface desc for the texture. Note how we are using the
    // texture manage attribute, so Direct3D does alot of dirty work for us
    DDSURFACEDESC2 ddsd;
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
    ddsd.dwSize          = sizeof(DDSURFACEDESC2);
    ddsd.dwFlags         = DDSD_CAPS|DDSD_HEIGHT|DDSD_WIDTH|
                           DDSD_PIXELFORMAT|DDSD_TEXTURESTAGE;
    ddsd.ddsCaps.dwCaps  = DDSCAPS_TEXTURE;
    ddsd.dwWidth         = dwWidth;
    ddsd.dwHeight        = dwHeight;

    // Turn on texture management for hardware devices
    if( ddDesc.deviceGUID == IID_IDirect3DHALDevice )
        ddsd.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    else if( ddDesc.deviceGUID == IID_IDirect3DTnLHalDevice )
        ddsd.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
    else
        ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

    // Adjust width and height, if the driver requires it
    if( ddDesc.dpcTriCaps.dwTextureCaps & D3DPTEXTURECAPS_POW2 )
    {
        for( ddsd.dwWidth=1;  dwWidth>ddsd.dwWidth;   ddsd.dwWidth<<=1 );
        for( ddsd.dwHeight=1; dwHeight>ddsd.dwHeight; ddsd.dwHeight<<=1 );
    }
    if( ddDesc.dpcTriCaps.dwTextureCaps & D3DPTEXTURECAPS_SQUAREONLY )
    {
        if( ddsd.dwWidth > ddsd.dwHeight ) ddsd.dwHeight = ddsd.dwWidth;
        else                               ddsd.dwWidth  = ddsd.dwHeight;
    }

	// enumerate texture caps,first try 32bits texture
	// then 16bits if failed
	//pd3dDevice->EnumTextureFormats( TextureSearchCallback32, &ddsd.ddpfPixelFormat );
	//if( 0L == ddsd.ddpfPixelFormat.dwRGBBitCount )
	//{
		pd3dDevice->EnumTextureFormats( TextureSearchCallback16, &ddsd.ddpfPixelFormat );
		if( 0L == ddsd.ddpfPixelFormat.dwRGBBitCount )
			return NULL;
	//}

    // Get the device's render target, so we can then use the render target to
    // get a ptr to a DDraw object. We need the DirectDraw interface for
    // creating surfaces.
    LPDIRECTDRAWSURFACE7 pddsRender;
    LPDIRECTDRAW7        pDD;
    pd3dDevice->GetRenderTarget( &pddsRender );
    pddsRender->GetDDInterface( (VOID**)&pDD );
    pddsRender->Release();

    // Create a new surface for the texture
    if( FAILED( hr = pDD->CreateSurface( &ddsd, &pddsTexture, NULL ) ) )
    {
        pDD->Release();
        return NULL;
    }

    // Done with DDraw
    pDD->Release();

    // Now, copy the bitmap to the texture surface. To do this, we are creating
    // a DC for the bitmap and a DC for the surface, so we can use the BitBlt()
    // call to copy the actual bits.

    // Get a DC for the bitmap
    HDC hdcBitmap = CreateCompatibleDC( NULL );
    if( NULL == hdcBitmap )
    {
        pddsTexture->Release();
        return NULL;
    }
    /*SelectObject( hdcBitmap, hbm );

    // Get a DC for the surface
    HDC hdcTexture;
    if( SUCCEEDED( pddsTexture->GetDC( &hdcTexture ) ) )
    {
        // Copy the bitmap image to the surface.
        BitBlt( hdcTexture, 0, 0, bm.bmWidth, bm.bmHeight, hdcBitmap,
                0, 0, SRCCOPY );
        pddsTexture->ReleaseDC( hdcTexture );
    }*/
    DeleteDC( hdcBitmap );

    // Return the newly created texture
    return pddsTexture;
}


LPDIRECTDRAWSURFACE7 LoadPNGTexture( LPDIRECT3DDEVICE7 pd3dDevice, LPSTR Filename )
{
	LPDIRECTDRAWSURFACE7 lpSurfTemp = NULL;
	LPDIRECTDRAWSURFACE7 lpTexture  = NULL;
	LPDIRECTDRAWSURFACE7 pddsRender = NULL;
	LPDIRECTDRAW7        lpDD       = NULL;
	DWORD                dwWidth;
	DWORD                dwHeight;

    pd3dDevice->GetRenderTarget( &pddsRender );
    pddsRender->GetDDInterface( (VOID**)&lpDD );
    pddsRender->Release();
	lpSurfTemp = LoadPNG( lpDD, Filename);
	lpDD->Release();

	DDSURFACEDESC2 ddsd;
    ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
    ddsd.dwSize = sizeof(DDSURFACEDESC2);
	lpSurfTemp->GetSurfaceDesc(&ddsd);

    D3DDEVICEDESC7 ddDesc;
    if( FAILED( pd3dDevice->GetCaps( &ddDesc ) ) )
        return NULL;
	// check texture size 
	if (ddsd.dwWidth > ddDesc.dwMaxTextureWidth )
		dwWidth = ddDesc.dwMaxTextureWidth;
	else dwWidth = ddsd.dwWidth;

	if (ddsd.dwHeight > ddDesc.dwMaxTextureHeight )
		dwHeight = ddDesc.dwMaxTextureHeight;
	else dwHeight = ddsd.dwHeight;

	// Create the D3D Texture
	lpTexture = CreateSurfaceTexture(pd3dDevice,dwWidth,dwHeight);

	lpTexture->Blt(NULL,lpSurfTemp,NULL,DDBLT_WAIT ,NULL);
       
	lpSurfTemp->Release();

	return lpTexture;
}