/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Random;

public class StarSystemFloatApp
extends Window
implements Runnable {
    private static final float MAX_STAR_SPEED = 4.0f;
    private int starCount;
    private static Random random;
    private static final int W = 400;
    private static final int H = 400;
    private int sW;
    private int sH;
    private IndexColorModel colorModel;
    private byte[] pixel;
    private MemoryImageSource miSource;
    private Image offscreenImage;
    private float[] size;
    private float[] px;
    private float[] py;
    private float[] sx;
    private float[] sy;
    private float dx;
    private float dy;
    private float deltaSq;
    private float buf;
    private long loopCountBeginning = 0L;
    private Image offscreenBuffer;
    private Graphics offscreenG;
    private int ppX;
    private int ppY;
    private static final int fpX = -200;
    private static final int fpY = 11;
    private Font f = new Font("Helvetica", 1, 40);

    public StarSystemFloatApp() {
        super(new Frame());
        long l = 994501485670L;
        random = new Random(l);
        ((Component)this).setBackground(Color.black);
        this.setForeground(Color.orange);
        Dimension dimension = this.getToolkit().getScreenSize();
        this.sW = dimension.width;
        this.sH = dimension.height;
        ((Component)this).setBounds(0, 0, this.sW, this.sH);
        this.ppX = (this.sW - 400) / 2;
        this.ppY = (this.sH - 400) / 2;
        this.enableEvents(8L);
        ((Component)this).setVisible(true);
        this.toFront();
        this.requestFocus();
        this.init();
        this.offscreenBuffer = this.createImage(400, 400);
        this.offscreenG = this.offscreenBuffer.getGraphics();
        this.offscreenG.setColor(Color.orange);
        this.offscreenG.setFont(this.f);
        new Thread(this).start();
    }

    public static final void main(String[] stringArray) {
        new StarSystemFloatApp();
    }

    private final void init() {
        this.starCount = 2 + (int)(random.nextDouble() * 6.0);
        this.size = new float[this.starCount];
        this.px = new float[this.starCount];
        this.py = new float[this.starCount];
        this.sx = new float[this.starCount];
        this.sy = new float[this.starCount];
        this.initStars();
        this.initImage();
    }

    private final void ensureRange(float[] fArray, float[] fArray2, int n, float f, float f2) {
        if (fArray[n] < f) {
            fArray[n] = f;
            int n2 = n;
            fArray2[n2] = fArray2[n2] * -1.0f;
            return;
        }
        if (fArray[n] > f2) {
            fArray[n] = f2;
            int n3 = n;
            fArray2[n3] = fArray2[n3] * -1.0f;
            return;
        }
    }

    public final void run() {
        Thread thread = Thread.currentThread();
        thread.setPriority(1);
        this.loopCountBeginning = System.currentTimeMillis();
        long l = 0L;
        float f = 1.0f;
        while (System.currentTimeMillis() - this.loopCountBeginning < 90000L) {
            if ((l = (long)((float)l + (f = (float)((double)f * 1.002)))) > 60L) {
                l -= 60L;
                this.init();
            }
            this.increaseTValue();
            this.renderOffscreenImg();
            this.miSource.newPixels();
            this.offscreenG.drawImage(this.offscreenImage, 0, 0, this);
            this.offscreenG.drawString("\u00a9oded 2001 by infugax of existS - it's Java", -200, 11);
            this.repaint();
        }
        System.exit(0);
    }

    private final void setPixel(int n, int n2, int n3) {
        this.pixel[n + n2 * 400] = (byte)n3;
    }

    private final void initImage() {
        this.initColorModel();
        this.pixel = new byte[160000];
        this.miSource = new MemoryImageSource(400, 400, (ColorModel)this.colorModel, this.pixel, 0, 400);
        this.miSource.setAnimated(true);
        this.offscreenImage = this.createImage(this.miSource);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        this.loopCountBeginning = 0L;
    }

    public final void update(Graphics graphics) {
        if (this.offscreenBuffer != null) {
            graphics.drawImage(this.offscreenBuffer, this.ppX, this.ppY, null);
        }
        graphics.setFont(this.f);
        graphics.drawString("\u00a9oded 2001 by infugax of existS - it's Java", this.ppX + -200, this.ppY + 11);
    }

    private final void increaseTValue() {
        int n = 0;
        while (n < this.starCount) {
            int n2 = n;
            this.px[n2] = this.px[n2] + this.sx[n];
            int n3 = n;
            this.py[n3] = this.py[n3] + this.sy[n];
            this.ensureRange(this.px, this.sx, n, 0.0f, 400.0f);
            this.ensureRange(this.py, this.sy, n, 0.0f, 400.0f);
            int n4 = 0;
            while (n4 < this.starCount) {
                if (n != n4) {
                    this.dx = this.px[n] - this.px[n4];
                    this.dy = this.py[n] - this.py[n4];
                    this.deltaSq = this.dx * this.dx + this.dy * this.dy;
                    this.buf = this.size[n] / 20.0f / this.deltaSq;
                    int n5 = n;
                    this.sx[n5] = this.sx[n5] + this.buf * this.dx;
                    int n6 = n;
                    this.sy[n6] = this.sy[n6] + this.buf * this.dy;
                }
                ++n4;
            }
            int n7 = n;
            this.sx[n7] = this.sx[n7] * 0.995f;
            int n8 = n++;
            this.sy[n8] = this.sy[n8] * 0.995f;
        }
    }

    private final void calculateLightIntensity(float f, float f2) {
        this.buf = 0.0f;
        int n = 0;
        while (n < this.starCount) {
            this.dx = this.px[n] - f;
            this.dy = this.py[n] - f2;
            this.deltaSq = this.dx * this.dx + this.dy * this.dy;
            if (this.deltaSq == 0.0f) {
                this.buf = 1.0f;
                return;
            }
            this.buf += this.size[n] / this.deltaSq;
            ++n;
        }
        if (this.buf > 1.0f) {
            this.buf = this.buf <= 2.0f ? 2.0f - this.buf : 0.0f;
        } else if (this.buf < -1.0f) {
            this.buf = this.buf >= -2.0f ? -1.0f - this.buf : 1.0f;
        }
    }

    private final void renderOffscreenImg() {
        int n = 0;
        while (n < 400) {
            int n2 = 0;
            while (n2 < 400) {
                this.calculateLightIntensity(n, n2);
                this.setPixel(n, n2, (int)(this.buf * 255.0f));
                ++n2;
            }
            ++n;
        }
    }

    private void initColorModel() {
        double d;
        byte[][] byArray = new byte[3][256];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = (int)(random.nextDouble() * 3.0);
        if (n4 != 0) {
            d = random.nextDouble();
            n = (int)((1.0 - d * d) * 256.0);
        }
        if (n4 != 1) {
            d = random.nextDouble();
            n2 = (int)((1.0 - d * d) * 256.0);
        }
        if (n4 != 2) {
            d = random.nextDouble();
            n3 = (int)((1.0 - d * d) * 256.0);
        }
        int n5 = 0;
        while (n5 < 128) {
            byArray[0][n5] = (byte)StarSystemFloatApp.fade(0, n, 2 * n5);
            byArray[1][n5] = (byte)StarSystemFloatApp.fade(0, n2, 2 * n5);
            byArray[2][n5] = (byte)StarSystemFloatApp.fade(0, n3, 2 * n5);
            byArray[0][128 + n5] = (byte)StarSystemFloatApp.fade(n, 255, 2 * n5);
            byArray[1][128 + n5] = (byte)StarSystemFloatApp.fade(n2, 255, 2 * n5);
            byArray[2][128 + n5] = (byte)StarSystemFloatApp.fade(n3, 255, 2 * n5);
            ++n5;
        }
        this.colorModel = new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]);
    }

    public static final double fade(int n, int n2, int n3) {
        return n + (n2 - n) * n3 / 255;
    }

    private void initStars() {
        float f = 3.0f;
        float f2 = f + (float)Math.sqrt(160000.0) / 60.0f;
        int n = 0;
        while (n < this.starCount) {
            this.size[n] = StarSystemFloatApp.getRandom(f, f2);
            this.px[n] = StarSystemFloatApp.getRandom(this.size[n], 400.0f - 2.0f * this.size[n]);
            this.py[n] = StarSystemFloatApp.getRandom(this.size[n], 400.0f - 2.0f * this.size[n]);
            this.size[n] = this.size[n] * this.size[n] * 20.0f;
            if (random.nextDouble() < 0.5) {
                this.size[n] = -this.size[n];
            }
            this.sx[n] = StarSystemFloatApp.getRandom(-4.0f, 4.0f);
            this.sy[n] = StarSystemFloatApp.getRandom(-4.0f, 4.0f);
            ++n;
        }
    }

    public static final float getRandom(float f, float f2) {
        return f + (float)(random.nextDouble() * (double)(f2 - f));
    }
}

