/*
    "console.h"   - SDL/C++ Console class

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_CONSOLE_H
#define _DDS_CONSOLE_H

#include "sdlbase.h"
#include "sound.h"
#include "linklist.h"

namespace dds {

    /*  Console class  */

class Console: public BaseConsole {
    /* todo:
        - a proper timer implmementation (Timer class?)
        - "video2D+opengl" mode is _slow_ !!! (two doublebuffer swaps; look into this)
        - report to Renderer on video mode change (=> probably needs texture re-uploading)
        - maybe Console::clear(..) should clear the renderer too?
  */
public:
    // setup initialization flags
    enum setupFlags {
        video = 0x000001,
        sound = 0x000002,
        timer = 0x000004,
        opengl = 0x000008,
        fullscreen = 0x000010
    };

    // setup
    Console(const int32 init = Console::video /* setupFlags */);
    ~Console();

    // data access
    inline const char* name() const { char *cap,*ico; SDL_WM_GetCaption(&cap,&ico); return(cap); }

    // info
    inline const int32 flags() const { return(m_flags); }

    // screen management
    void open(const char title[],const int32 width,const int32 height,const int32 depth);
    void close();
    void update();

    // window management
    void caption(const char *title, const char *iconname=NULL) { SDL_WM_SetCaption(title,iconname); }
    void icon(BaseSurface *icon,char8 *mask=NULL) { SDL_WM_SetIcon(icon->SDLSurface(),mask); }
    void cursor(const bool show) { SDL_ShowCursor((int)show); }

private:
    // variables
    int32 m_init;   // setup init flags

    // stored SDL info
    const SDL_VideoInfo *m_videoinfo;
    bool m_video_open;
    int32 m_flags;
    int32 m_what_buf;

    // OpenGL context info
    int m_gl_doublebuffer;
    int m_gl_bpp;
    int m_gl_zbits;
    int m_gl_stencilbits;
};


}   // namespace dds

#endif  // _DDS_CONSOLE_H