;   "cpu.asm"   - CPU detection routines
;
;   DDS - Dureks DemoSystem
;   Copyright (C)2001 dureks
;
;   This source code is licensed under the GNU GPL.
;   See the GNU General Public License for more details.

GLOBAL _x86_get_cpuinfo

; cpu flags
%define _cpuflags_align     $40000      ;alignment check flag
%define _cpuflags_cpuid     $200000     ;cpuid (instruction)
%define _cpuid_FPU          $1          ;fpu
%define _cpuid_TSC          $8          ;time stamp counter
%define _cpuid_MSR          $20         ;rdmsr/wrmsr support
%define _cpuid_CX8          $80         ;cmpxchg8b (instruction)
%define _cpuid_MTRR         $1000       ;memory type range register
%define _cpuid_CMOV         $4000       ;cmovcc (instructions)
%define _cpuid_MMX          $800000     ;mmx
%define _msw_FPU            $2          ;generic fpu

; cpuinfo structure
%define t_Family 0
%define t_FPU 1
%define t_MMX 2
%define t_Dual 3
%define t_TSC 4
%define t_CX8 5
%define t_CMOV 6
%define t_MTRR 7
%define t_MSR 8

[SECTION .text]

_x86_get_cpuinfo:
	push	ebp
%ifdef REGISTER_CALLING
    mov     ebp,    eax
%else
	mov	ebp,	[esp+8]
%endif
	pushad

    ; check if cpu is a 386
    pushfd
    pop  eax
    or   eax,  _cpuflags_align    ; set the alignment check flag
    push eax
    popfd
    pushfd
    pop  eax
    and  eax,  _cpuflags_align    ; if this is off, cpu is a 386
    jnz  .check486
    jmp  .checkFPU

    ; detect whether `cpuid' is supported or not
  .check486:
    inc  byte [ebp+t_Family]
    pushfd
    pop  eax
    or   eax,  _cpuflags_cpuid    ; set the cpuid flag
    push eax
    popfd
    pushfd
    pop  eax
    and  eax,  _cpuflags_cpuid    ; if turned off, cpu is an old-type 486
    jnz  .cpuid
    jmp  .checkFPU

    ; get cpu information with the `cpuid' instruction
  .cpuid:
    xor  eax,  eax
    cpuid
    cmp  eax,  1
    jb   .checkFPU

    mov  eax,  1
    cpuid

    push eax
    shr  eax,  8            ; bits 8-11 holds the cpu family
    and  eax,  $0F
    mov  [ebp+t_Family],  BYTE al ; get cpu family (486+)
    pop  eax

    shr  eax,  12           ; bits 12-15 holds some "reserved" information
    and  eax,  $0F
    cmp  eax,  2
    setz byte  [ebp+t_Dual]  ; is this a dual CPU board? (PPro/P2)

    test edx,  _cpuid_FPU
    setnz byte [ebp+t_FPU]   ; is an FPU present? (486DX,Pentium,PPro,P2)
    test edx,  _cpuid_TSC
    setnz byte [ebp+t_TSC]   ; is `rdtsc' supported? (Pentium+)
    test edx,  _cpuid_MSR
    setnz byte [ebp+t_MSR]   ; is `rdmsr' and `wrmsr' supported (Pentium+)
    test edx,  _cpuid_CX8
    setnz byte [ebp+t_CX8]   ; is `cmpxchg8b' supported? (Pentium+)
    test edx,  _cpuid_MTRR

    setnz byte [ebp+t_MTRR]  ; is memory type range register supported (PentiumPro+)
    test edx,  _cpuid_CMOV
    setnz byte [ebp+t_CMOV]  ; is conditional move supported (PPro/P2)
    test edx,  _cpuid_MMX
    setnz byte [ebp+t_MMX]   ; is MMX instructions supported (P-MMX,P2)
    jmp  .done

    ; generic FPU detection routine
  .checkFPU:
    smsw ax     ; load the machine status word in ax
    test ax,   _msw_FPU
    setnz byte [ebp+t_FPU]

  .done:
	popad
	pop	ebp
	ret
