/*
    "cpuinfo.cpp"   - CPU information

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include "cpuinfo.h"

namespace dds {

cpuinfo::cpuinfo()
{
  // Set all info to default values
  m_arch = ARCH_UNKNOWN;
  m_family = CPU_UNKNOWN;
  m_vendor = NULL;
  m_fpu = 0;
  m_mmx = 0;
  m_cx8 = 0;
  m_cmov = 0;
  m_tsc = 0;
  m_mtrr = 0;

  #ifdef __GNUC__
    getinfo_linux();
  #endif

  #ifdef WIN32
    getinfo_x86();
  #endif
}

cpuinfo::~cpuinfo()
{
  delete []m_vendor;
}

#ifdef __GNUC__
void cpuinfo::getinfo_linux()
{
	// try to open "/proc/cpuinfo" to aquire characteristics
  ifstream is("/proc/cpuinfo",ios::in);
  if ( !is ) {
    cout << "(cpuinfo) Unable to open '/proc/cpuinfo', using defaults...\n";
    getchar();

    return;
  }

  char buffer[256], *param;
  while ( is.getline(buffer,256) ) {

	// read vendor identification string
    if ( strstr(buffer,"vendor_id\x9") ) {
      param = (char*)rdprcpu(buffer);
      m_vendor = new char[strlen(param)+1]; // (+1) Remember the null-terminator
      strcpy(m_vendor,param);

      continue;
    }

	// get cpu family identification
    if ( strstr(buffer,"cpu family\x9") ) {
      param = (char*)rdprcpu(buffer);
      m_family = (CPU_FAMILY)atoi(param);

      continue;
    }

	// get some feature flags
    if ( strstr(buffer, "flags\x9") ) {
      
      if ( strstr(buffer, " fpu") )	// floating-point unit
        m_fpu = 1;

      if ( strstr(buffer, " mmx") )	// MMX capabilities
        m_mmx = 1;
     
      if ( strstr(buffer, " cx8") )	// compare and exchange 8byte
        m_cx8 = 1;
 
      if ( strstr(buffer, " cmov") )	// conditional move (CMOVcc)
        m_cmov = 1;
 
      if ( strstr(buffer, " tsc") ) 	// time stamp counter
        m_tsc = 1;

      if ( strstr(buffer, " mtrr") ) 	// memory type range registers
        m_mtrr = 1;

      continue;
    }
  }
}

	/* Used specially for "/proc/cpuinfo", returns the value
           located behind the colon of each field */

const char* cpuinfo::rdprcpu(const char *buffer) const
{
  while( *(buffer-2) != ':') buffer++;
  return(buffer);
}
#endif

#ifdef WIN32
void cpuinfo::getinfo_x86()
{
  cpuinfoT info;
  x86_get_cpuinfo(&info);

  m_family = (CPU_FAMILY)info.Family;
  m_fpu = info.FPU;
  m_mmx = info.MMX;
  m_cx8 = info.CX8;
  m_cmov = info.CMOV;
  m_tsc = info.TSC;
  m_mtrr = info.MTRR;
/*  m_vendor = new char[12+1];
  strncpy(m_vendor,,12);
  m_vendor[12] = '\0';*/
}
#endif

CPU_ARCH cpuinfo::architechture() const
{
  return(ARCH_INTEL);
}

char* cpuinfo::vendor_id() const
{
  return(m_vendor);
}


CPU_FAMILY cpuinfo::family() const
{
  return(m_family);
}


int cpuinfo::fpu() const
{
  return(m_fpu);
}

int cpuinfo::mmx() const
{
  return(m_mmx);
}

char cpuinfo::cx8() const
{
  return(m_cx8);
}

char cpuinfo::cmov() const
{
  return(m_cmov);
}


char cpuinfo::tsc() const
{
  return(m_tsc);
}


char cpuinfo::mtrr() const
{
  return(m_mtrr);
}


}   // namespace dds