/*
    "cpuinfo.h"   - CPU information

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_CPUINFO_H
#define _DDS_CPUINFO_H

namespace dds {

enum CPU_ARCH {
  ARCH_UNKNOWN = -1,
  ARCH_INTEL = 0
};

enum CPU_FAMILY {
  CPU_UNKNOWN = -1,
  CPU_386 = 3,
  CPU_486 = 4,
  CPU_586 = 5,
  CPU_686 = 6,
};

class cpuinfo {

public:
    cpuinfo();
    ~cpuinfo();

    CPU_ARCH architechture() const;
    CPU_FAMILY family() const;
    char* vendor_id() const;
    int fpu() const;
    int mmx() const;
    char cx8() const;
    char cmov() const;
    char tsc() const;
    char mtrr() const;

private:

#ifdef __GNUC__
    const char* rdprcpu(const char *buffer) const;
    void getinfo_linux();
#endif

#ifdef WIN32
    void getinfo_x86();
#endif


    CPU_ARCH m_arch;
    char* m_vendor;
    CPU_FAMILY m_family;
    int m_fpu;
    int m_mmx;
    char m_cx8;
    char m_cmov;
    char m_tsc;
    char m_mtrr;
};

struct cpuinfoT {
  char Family;
  char FPU;
  char MMX;
  char Dual;
  char TSC;
  char CX8;
  char CMOV;
  char MTRR;
  char MSR;
};


/* External code interface
   --------------------------- */
#ifdef WIN32

extern "C"
{
    void x86_get_cpuinfo(cpuinfoT *);
}
#endif


}   // namespace dds

#endif  // _DDS_CPUINFO_H
