/*
    "demo.h"   - Demo class

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_DEMO_H
#define _DDS_DEMO_H

#include <fstream.h>
#include <SDL/SDL.h>

#include "sdlbase.h"
#include "console.h"

namespace dds {

    /* Demo class */

class Demo {
public:
    // setup
    Demo();
    virtual ~Demo();

    // execute
    void run();

    // threads
    enum threadfunc {
        update_func = 1,
    };

    struct DemoThread {
        threadfunc func;
        SDL_TimerID id;
    };

    void thread(threadfunc func, int32 msec);

protected:
    BaseConsole *console;

    // unthread
    void delete_threads();
    virtual void eod() {};
    // keyboard events
    virtual void key_pressed(SDLKey key, SDLMod mod);
    virtual void key_released(SDLKey key, SDLMod mod) {};
    // mouse events
    virtual void mouse_button_pressed(char8 button, int16 x, int16 y) {};
    virtual void mouse_button_released(char8 button, int16 x, int16 y) {};
    virtual void mouse_button_is_pressed(char8 button, int16 x, int16 y) {};
    virtual void mouse_motion(int16 x, int16 y, int xrel, int yrel) {};
    // windowmanager events
    virtual void window_resize(int32 w, int32 h) {};
    virtual void window_focus_gain(char8 state) {};
    virtual void window_focus_lost(char8 state) {};

    // update functions
    virtual void display() {};
        /* Demo::display() is called whenever the program should update the screen.
            It is currently called from the event polling function; Demo::run().
        */
    virtual void update() {};
        /* Demo::update() should be used to update variables that need timing, because
            the function is run from a separate thread at a selectable rate (msec)
        */

    enum req_func {
        redraw = 1,
        quit = 2,
        event = 4
    };
    void request(int32 flags /* req_func */);

private:
    static int32 update_thread(int32 interval, void *param);

	bool m_display_update;
    SDL_Event poll_event;
	SDL_Event mouse;

    bool m_event_quit;
    LinkedList<DemoThread> m_threads;
};



}   // namespace dds

#endif  // _DDS_DEMO_H
