/*
    "demo.h"   - Demo class

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _M_EMITTER_H
#define _M_EMITTER_H

#include <memory.h>
#include "types.h"
#include "vector.h"
#include "sdlbase.h"
#include "sprite.h"

namespace dds {

struct Particle {
    bool active;      // active (draw/update)

    Vector2 position;   // current position
    Vector2 direction;  // direction (normalized)
    Vector2 accel;      // acceleration
    float speed;        // speed

    float color[3];     // RGB values (texture overlay color)

    float life;         // life left
    float fade;         // life fade
};

const float M_PARTICLE_LIFE         = 1.0f;
const float M_PARTICLE_LIFE_RAND    = 0.2f;
const float M_PARTICLE_FADE         = 0.01f;
const float M_PARTICLE_SPEED        = 0.01f;

class Emitter {
    /* todo:
        - DONE: litt annen layout p initializer; kanskje bare count+direction, resten settes senere
        - standardiser strrelsene p faktorene litt
  */
public:
    // setup
    Emitter(int32 count, Vector2 pos);
    ~Emitter();

    // change initial settings
    void position(Vector2 pos) { m_position = pos; }
    void direction(Vector2 dir, Vector2 rnd) { m_direction=dir/*.normalize()*/; m_random=rnd/*.normalize()*/; }
    void acceleration(Vector2 acc) { m_accel = acc; }
    void speed(float spd, float rnd) { m_speed=spd; m_speed_rand=rnd; }
    void life(float lfe, float rnd, float fde) { m_life=lfe; m_life_rand=rnd; m_fade=fde; }
    void color(float col[4]) { memcpy(m_color,col,sizeof(float[3])); }
    void fade(float fade) { m_fade = fade; }
    void life_rand(float life_rnd) { m_life_rand = life_rnd; }

    // particle handling
    void update();          // update particle positions
    void revive(int32 n);   // bring #particles to life
    void draw(BaseSurface *sprite, BaseSurface *surface);

    // data access
    Particle* particle(int32 n);
    int32 particles() { return(m_particles); }

    Vector2 direction() { return(m_direction); }
    Vector2 direction_rand() { return(m_random); }
    float speed() { return(m_speed); }
    float speed_rand() { return(m_speed_rand); }

private:
    // initial settings
    Vector2 m_position;     // position
    Vector2 m_direction;    // direction
    Vector2 m_random;       // direction randomization
    Vector2 m_accel;        // acceleration
    float m_speed;          // speed
    float m_speed_rand;     // speed randomization
    float m_life;           // life
    float m_life_rand;      // life randomization
    float m_fade;           // fade speed
    float m_color[4];       // color

    // particles
    Particle *m_particle;   // particle list
    int32   m_particles;    // #particles

    // blitter
    Blitter blit;
};



    /* particle physics systems (pre)
       ------------------------------ */

    // particle physics base class
class Physics {
public:
    virtual ~Physics() {};

    // particles modification
    virtual void update() {};
    virtual void apply(Emitter *emitter) = 0;
    virtual void position(Vector2 pos) {};
};

class Gravity: public Physics {
public:
    Gravity(float g);
    ~Gravity() {};

    void apply(Emitter *emitter);

private:
    float m_gravity;
};

class Attractor: public Physics {
public:
    Attractor(Vector2 position, float attraction);
    ~Attractor() {};

    void apply(Emitter *emitter);
    void position(Vector2 pos);

private:
    Vector2 m_position;
    float m_attraction;
};

}   // namespace dds

#endif  // _M_EMITTER_H
