/*
    "error.cpp"   - Error class
     
    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifdef WIN32
#include <windows.h>
#endif

#include <stdio.h>
#include <string.h>
#include <SDL/SDL.h>
#include "error.h"

namespace dds {

    /*  Error class
        ----------- */

Error::Error(const char trace[], const char message[])
{
    m_message = new char[strlen(message)+1];
    m_trace = new char[strlen(trace)+1];

    sprintf(m_message,"%s",message);
    sprintf(m_trace,"%s",trace);
}

Error::Error(const char trace[], const char message[], const char data[])
{
    m_message = new char[strlen(message)+strlen(data)+strlen(" \"\" ")+1];
    m_trace = new char[strlen(trace)+1];

    sprintf(m_message,"%s \"%s\"",message,data);
    sprintf(m_trace,"%s",trace);
}

Error::Error(const char trace[], const char message[], int data)
{
    char temp[100];
    sprintf(temp," %i",data);
    m_message = new char[strlen(message)+strlen(temp)+1];
    m_trace = new char[strlen(trace)+1];

    sprintf(m_message,"%s %i",message,data);
    sprintf(m_trace,"%s",trace);
}

Error::Error(const char trace[], const char message[], double data)
{
    char temp[100];
    sprintf(temp," %f",data);
    m_message = new char[strlen(message)+strlen(temp)+1];
    m_trace = new char[strlen(trace)+1];

    sprintf(m_message,"%s %f",message,data);
    sprintf(m_trace,"%s",trace);
}

Error::Error(const char trace[], const Error &error)
{
    m_message = new char[strlen(error.m_message)+1];
    m_trace = new char[strlen(error.m_trace)+strlen(trace)+strlen(" <- ")+1];

    sprintf(m_message,"%s",error.m_message);
    sprintf(m_trace,"%s <- %s",trace,error.m_trace);
}

Error::Error(const Error& error)
{
    m_message = new char[strlen(error.m_message)+1];
    m_trace = new char[strlen(error.m_trace)+1];

    sprintf(m_message,"%s",error.m_message);
    sprintf(m_trace,"%s",error.m_trace);
}

Error::~Error()
{
    delete []m_message;
    delete []m_trace;
}

void Error::report()
{
    char *sdlerr = (char*)SDL_GetError();

    if( strlen((char*)sdlerr) )
        fprintf(stderr,"\n%s (%s)\n\n\t%s\n\n",m_message,sdlerr,m_trace);
    else
        fprintf(stderr,"\n%s\n\n\t%s\n\n",m_message,m_trace);
}


}   // namespace dds
