/*
    "error.h"   - Error class
     
    DDS - Dureks DemoSystem    
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_ERROR_H
#define _DDS_ERROR_H

namespace dds {

    /*  Error class  */

class Error {

    /* usage:
        "trace"     source of the error == <class>::<function> (e.g "String::Append()")
        "message"   error message, do not change upon rethrowing
        "data"      extra information
  */
public:
    // setup
    Error(const char trace[], const char message[]);
    Error(const char trace[], const char message[], const char data[]);
    Error(const char trace[], const char message[], int data);
    Error(const char trace[], const char message[], double data);
    // rethrowing
    Error(const char trace[], const Error&);
    Error(const Error&);
    ~Error();

    // information
    void report();

private:
    char *m_message, *m_trace;
};

}   // namespace dds

#endif  // _DDS_ERROR_H
