#include "sprite.h"
#include "fx_c.h"

namespace dds
{

void c_add_pixels_32(muuTransparencyInterface *iface)
{
    int32 *source = (int32*)iface->source.data;
    int32 *dest = (int32*)iface->destination.data;

    const int snl = iface->source.width >> 2;
    const int dnl = iface->destination.width >> 2;

    int32 color,color2;
    int r,g,b;

    for(Uint32 y=0;y<iface->height;y++) {
        for(Uint32 x=0;x<iface->width;x++) {
            color = *(source+x);
            color2 = *(dest+x);

            if( (r = ((color >> 16) & 0xFF)+((color2 >> 16) & 0xFF)) > 255)
                r = 255;
            if( (g = ((color >> 8) & 0xFF)+((color2 >> 8) & 0xFF)) > 255)
                g = 255;
            if( (b = (color & 0xFF)+(color2 & 0xFF)) > 255)
                b = 255;

            *(dest+x) = (int32)((r << 16)+(g << 8)+b);
        }

        source += snl;
        dest += dnl;
    }
}

void c_add_pixels_grade_32(muuTransparencyInterface *iface)
{
    int32 *source = (int32*)iface->source.data;
    int32 *dest = (int32*)iface->destination.data;

    const int snl = iface->source.width >> 2;
    const int dnl = iface->destination.width >> 2;
    const char8 grade = iface->grade;

    int32 color,color2;
    int r,g,b;

    for(Uint32 y=0;y<iface->height;y++) {
        for(Uint32 x=0;x<iface->width;x++) {
            color = *(source+x);
            color2 = *(dest+x);

            r = ((color >> 16) & 0xFF)-grade;
            if( r < 0 )
                r = 0;
            r += ((color2 >> 16) & 0xFF);
            if( r > 255 )
                r = 255;

            g = ((color >> 8) & 0xFF)-grade;
            if( g < 0 )
                g = 0;
            g += ((color2 >> 8) & 0xFF);
            if( g > 255 )
                g = 255;

            b = (color & 0xFF)-grade;
            if( b < 0 )
                b = 0;
            b += (color2 & 0xFF);
            if( b > 255 )
                b = 255;

            *(dest+x) = (int32)((r << 16)+(g << 8)+b);
        }

        source += snl;
        dest += dnl;
    }
}

void c_sub_pixels_32(muuTransparencyInterface *iface)
{
    int32 *source = (int32*)iface->source.data;
    int32 *dest = (int32*)iface->destination.data;

    const int snl = iface->source.width >> 2;
    const int dnl = iface->destination.width >> 2;

    int32 color,color2;
    int r,g,b;

    for(Uint32 y=0;y<iface->height;y++) {
        for(Uint32 x=0;x<iface->width;x++) {
            color = *(source+x);
            color2 = *(dest+x);

            if( (r = ((color2 >> 16) & 0xFF)-((color >> 16) & 0xFF)) < 0)
                r = 0;
            if( (g = ((color2 >> 8) & 0xFF)-((color >> 8) & 0xFF)) < 0)
                g = 0;
            if( (b = (color2 & 0xFF)-(color & 0xFF)) < 0)
                b = 0;

            *(dest+x) = (int32)((r << 16)+(g << 8)+b);
        }

        source += snl;
        dest += dnl;
    }
}

void c_mask_pixels_32(muuTransparencyInterface *iface)
{
//    fprintf(stderr,"width: %u, height: %u\n",iface->width,iface->height);
    Uint32 *source = (Uint32*)iface->source.data;
    Uint32 *dest = (Uint32*)iface->destination.data;

    const int snl = iface->source.width >> 2;
    const int dnl = iface->destination.width >> 2;

    Uint32 color, color2;

    for(Uint32 y=0;y<iface->height;y++) {
        for(Uint32 x=0;x<iface->width;x++) {
            color = *(source+x);
            color2 = *(dest+x);
            if( color && color2 )
                *(dest+x) = color;
        }

        source += snl;
        dest += dnl;
    }
}

void c_mask_pixels_16(muuTransparencyInterface *iface)
{
    Uint16 *source = (Uint16*)iface->source.data;
    Uint16 *dest = (Uint16*)iface->destination.data;

    const int snl = iface->source.width >> 1;
    const int dnl = iface->destination.width >> 1;

    Uint16 color,color2;

    for(Uint32 y=0;y<iface->height;y++) {
        for(Uint32 x=0;x<iface->width;x++) {
            color = *(source+x);
            color2 = *(dest+x);
            if( color && color2 )
                *(dest+x) = color;
        }

        source += snl;
        dest += dnl;
    }
}

}   // namespace dds