/*
    "console.h"   - SDL/C++ GFX font class

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_GFXFONT_H
#define _DDS_GFXFONT_H

#include "sdlbase.h"
#include "parser.h"
#include "image.h"

namespace dds {

    /* GFXFont class */

#define SFONT_SEPARATOR 32
#define SFONT_STARTCHAR 33

class GFXFont {
public:
    // setup
    GFXFont(const char sfont[], int32 flags=SDL_SWSURFACE);
    GFXFont(const char sfont[], const Format &format, int32 flags=SDL_SWSURFACE);
    ~GFXFont();

    // alpha & colorkeying
    inline void colorkey(int32 key, int32 flags=SDL_RLEACCEL|SDL_SRCCOLORKEY) const
        { image->colorkey(key,flags); }
    inline void alpha(char8 alpha, int32 flags=SDL_RLEACCEL|SDL_SRCALPHA) const
        { image->alpha(alpha,flags); }

    // typing
    void write(int px, int py, char text[], BaseSurface *dest);

private:
    void initialize();
    void map_sfont();

    Color* getpixel(int32 x, int32 y);

    BaseSurface *image;
    Area *letter[256];
    int32 m_spacing;    // space char
};


}   // namespace dds

#endif  // _DDS_GFXFONT_H
