/*
    "image.h"   - <SDL/C++> Image class (Surface) and loaders
     
    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_IMAGE_H
#define _DDS_IMAGE_H

#include "sdlbase.h"
#include "types.h"

namespace dds {

    /*  Image class  */

class Image: public BaseSurface {
    /* todo:
    */
public:
    // setup
    Image(const char image[], const int32 flags=SDL_SWSURFACE);
    Image(const char image[], const Format &format, const int32 flags=SDL_SWSURFACE);
    ~Image();

private:
    char *m_name;
};

    /* ImageLoader base class */

class ImageLoader {
public:
    virtual bool check(const char[]) = 0;
    virtual SDL_Surface* load(const char[], const int32 flags) = 0;
};

    /*  Image autoloader  */

class ImageLoader_auto: public ImageLoader {
public:
    bool check(const char[]);
    SDL_Surface* load(const char[], const int32 flags);
};

    /*  PNG loader class  */

class ImageLoader_PNG: public ImageLoader {
public:
    bool check(const char[]);
    SDL_Surface* load(const char[], const int32 flags);
};

    /*  JPEG loader class  */

class ImageLoader_JPEG: public ImageLoader
{
public:
    bool check(const char[]);
    SDL_Surface* load(const char[], const int32 flags);
};


}   // namespace dds

#endif  // _DDS_IMAGE_H