/*
    "linklist.h"   - List classes

    DDS - Dureks DemoSystem
    Copyright (C)2001 dureks

    This source code is licensed under the GNU GPL.
    See the GNU General Public License for more details.
*/

#ifndef _DDS_LINKLIST_H
#define _DDS_LINKLIST_H

#include "types.h"

namespace dds {

    /* Base list class */

class List {
public:
    enum listPos {
        start = -2,
        end = -1
    };

    inline const int32 length() const { return(m_length); }

protected:
    int32 m_length;
};

    /* Linked List class */
template <class T>
class LinkedList: public List {
    /* todo:
        - clean up link code a bit (push/pop can surely be done easier?)
  */
public:
    // link structure
    struct Link {
        Link *prev;
        Link *next;
        T *data;
    };

    // setup
    LinkedList();
    ~LinkedList();

    // list functions
    T* item(int32 i) const;
    void push(T *data, List::listPos sp = List::end);
    T* pop(List::listPos sp = List::end);
    T* remove(const T *data);

    bool has(const T *data);

private:
    Link *m_head;
    Link *m_tail;
};


    /*  LinkedList source code
        ---------------------- */

template <class T>
LinkedList<T>::LinkedList()
{
    m_head = NULL;
    m_tail = NULL;
    m_length = 0;
}

template <class T>
LinkedList<T>::~LinkedList()
{
    T *data;
    while( data = pop(List::end) )
        delete data;
}

template <class T>
T* LinkedList<T>::item(int32 i) const
{
    if( i >= m_length )
        return(NULL);

    Link *node = m_head;
    while(i--)
        node = node->next;

    return(node->data);
}

template <class T>
void LinkedList<T>::push(T *data, List::listPos sp)
{
    Link *node = new Link;
    node->data = data;

    if( sp == List::start ) {
        node->prev = NULL;
        node->next = m_head;
        if( m_head )
            m_head->prev = node;
        m_head = node;
        if( !m_tail )
            m_tail = m_head;
    }

    if( sp == List::end ) {
        node->prev = m_tail;
        node->next = NULL;
        if( m_tail )
            m_tail->next = node;
        m_tail = node;
        if( !m_head )
            m_head = m_tail;
    }

    m_length++;
}

template <class T>
T* LinkedList<T>::pop(List::listPos sp)
{
    // special case: empty list
    if( !m_length )
        return(NULL);

    T *data = NULL;

    // special case: listlength 1
    if( m_length == 1 ) {
        data = m_head->data;
        delete m_head;
        m_head = m_tail = NULL;
        m_length = 0;
        return(data);
    }

    if( sp == List::start ) {
        data = m_head->data;
        Link *node = m_head;
        m_head = m_head->next;
        m_head->prev = NULL;
        delete node;
    }

    if( sp == List::end ) {
        data = m_tail->data;
        Link *node = m_tail;
        m_tail = m_tail->prev;
        m_tail->next = NULL;
        delete node;
    }

    m_length--;
    return(data);
}

template <class T>
T* LinkedList<T>::remove(const T *data)
{
    Link *node = m_head;

    while( node ) {
        Link *next = node->next;
        Link *prev = node->prev;

        if( node->data == data ) {
            if( node == m_head )
                m_head = next;
            if( node == m_tail )
                m_tail = prev;
            if( next )
                next->prev = prev;
            if( prev )
                prev->next = next;

            T *data = node->data;
            delete node;
            m_length--;
            return(data);
        }

        node = node->next;
    }

    return(NULL);
}

template <class T>
bool LinkedList<T>::has(const T *data)
{
    Link *node = m_head;

    while( node ) {
        if(node->data == data )
            return(true);

        node = node->next;
    }

    return(false);
}


}   // namespace dds

#endif  // _DDS_LINKLIST_H
