#include "demo.h"
#include "console.h"
#include "surface.h"
#include "image.h"
#include "vector.h"
#include "emitter.h"
#include "sprite.h"
#include "error.h"

using namespace dds;

class Example: public Demo {
public:
    Example();
    ~Example() {};

protected:
    void display();
    void update();

    void mouse_motion(int16 x, int16 y, int xrel, int yrel);

private:
    Surface *flare;
    Vector2 mousepos;
    Gravity *gravity;
    Emitter *trail;

    Surface *buffer;
};

Example::Example()
{
    console = new Console(Console::video|Console::timer);
    console->open("DDS example Demo",640,480,0);

    // setup mouse trail
    Vector2 pos(0,0);
    trail = new Emitter(2000,pos);
    trail->fade(0.030f);
    trail->speed(2.0f,0.4f);
    gravity = new Gravity(9.81f);

    flare = new Surface(32,32,console->format());
    Color color(0xFF,0xFF,0xFF,0x00);
    flare->clear(color);
}

void Example::display()
{
    Color color(0x00,0x88,0xFF,0x00);
    console->clear(color);

    trail->draw(flare,console);

    console->update();
}

void Example::mouse_motion(int16 x, int16 y, int xrel, int yrel)
{
    // create new particles when moving mouse
    Vector2 dir(xrel,yrel);
    Vector2 off(1.0f,1.0f);
    trail->direction(dir,off);
    Vector2 pos(x,y);
    trail->position(pos);
    trail->revive(10);
}

void Example::update()
{
    gravity->apply(trail);
    trail->update();
}

/* ---------------------- main ----------------------
*/
int main(int argc, char **argv)
{
    try {
        Example example;
        example.thread(Demo::update_func, 20);
        example.run();
    } catch(Error &error) {
        error.report();
    }
    return(0);
}
